/*
 * Decompiled with CFR 0.152.
 */
package xelitez.frostcraft.netty;

import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteStreams;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import net.minecraft.entity.player.EntityPlayer;
import xelitez.frostcraft.netty.Packet;
import xelitez.frostcraft.network.PacketManagerClient;
import xelitez.frostcraft.network.PacketManagerServer;

public class PacketCustomData
extends Packet {
    private ByteBuf data;

    public PacketCustomData() {
    }

    public PacketCustomData(byte[] data) {
        this.data = Unpooled.wrappedBuffer((byte[])data);
    }

    @Override
    public void encodeInto(ChannelHandlerContext ctx, ByteBuf buffer) {
        if (this.data != null) {
            buffer.writeBytes(this.data);
        }
    }

    @Override
    public void decodeInto(ChannelHandlerContext ctx, ByteBuf buffer) {
        this.data = buffer.copy();
    }

    @Override
    public void handleClientSide(EntityPlayer player) {
        ByteArrayDataInput dat = ByteStreams.newDataInput((byte[])this.data.array());
        short ID = dat.readShort();
        PacketManagerClient.INSTANCE.onPacketData(dat, ID, player);
    }

    @Override
    public void handleServerSide(EntityPlayer player) {
        ByteArrayDataInput dat = ByteStreams.newDataInput((byte[])this.data.array());
        short ID = dat.readShort();
        PacketManagerServer.INSTANCE.onPacketData(dat, ID, player);
    }
}

