/*
 * Decompiled with CFR 0.152.
 */
package xelitez.frostcraft.energy;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.World;
import xelitez.frostcraft.tileentity.TileEntityThermalMachines;
import xelitez.frostcraft.tileentity.TileEntityThermalPipe;

public class EnergyRequestRegistry {
    private List<int[]> ids = new ArrayList<int[]>();
    private List<int[]> queue = new ArrayList<int[]>();
    private List<int[]> checked = new ArrayList<int[]>();
    public int checkSpeed = 5;
    private static EnergyRequestRegistry INSTANCE = new EnergyRequestRegistry();

    public static EnergyRequestRegistry getInstance() {
        return INSTANCE;
    }

    public int getAvailableRequestId() {
        return this.getAvailableId(0);
    }

    private int getAvailableId(int par1) {
        if (par1 >= Integer.MAX_VALUE) {
            return -1;
        }
        for (int[] id : this.ids) {
            if (id == null || id[0] != par1) continue;
            return this.getAvailableId(++par1);
        }
        return par1;
    }

    public int addRequest(TileEntityThermalMachines te, int request) {
        int id = this.getAvailableRequestId();
        if (id != -1) {
            int[] set = new int[]{id, request, te.field_145851_c, te.field_145848_d, te.field_145849_e, te.func_145831_w().field_73011_w.field_76574_g};
            this.ids.add(set);
        }
        return id;
    }

    public int[] getRequestData(int id) {
        for (int[] dat : this.ids) {
            if (dat == null || dat[0] != id) continue;
            return dat;
        }
        return null;
    }

    public boolean hasTileEntityRequests(TileEntityThermalMachines te) {
        for (int[] id : this.ids) {
            if (id == null || id[2] != te.field_145851_c || id[3] != te.field_145848_d || id[4] != te.field_145849_e || id[5] != te.func_145831_w().field_73011_w.field_76574_g) continue;
            if (this.getNumberOfPipesInQueue(id[0]) <= 0) {
                this.removeAll(id[0]);
                return false;
            }
            return true;
        }
        return false;
    }

    public void setPipeChecked(TileEntityThermalPipe te, int id) {
        int[] set = new int[]{id, te.field_145851_c, te.field_145848_d, te.field_145849_e, te.func_145831_w().field_73011_w.field_76574_g};
        this.checked.add(set);
    }

    public boolean isPipeChecked(TileEntityThermalPipe te, int id) {
        for (int[] check : this.checked) {
            if (check == null || check[0] != id || te.field_145851_c != check[1] || te.field_145848_d != check[2] || te.field_145849_e != check[3] || te.func_145831_w().field_73011_w.field_76574_g != check[4]) continue;
            return true;
        }
        return false;
    }

    private int getDimensionQueue(int dim) {
        int count = 0;
        for (int[] dat : this.queue) {
            if (dat == null || dat[4] != dim) continue;
            ++count;
        }
        return count;
    }

    public boolean addPipeToCheckQueue(int id, TileEntityThermalPipe te) {
        if (te != null && te instanceof TileEntityThermalPipe && !this.getIsPipeInQueue(id, te)) {
            int[] set = new int[]{id, te.field_145851_c, te.field_145848_d, te.field_145849_e, te.func_145831_w().field_73011_w.field_76574_g};
            this.queue.add(set);
            return true;
        }
        return false;
    }

    public void removePipeFromQueue(int x, int y, int z, int dim, int id) {
        for (int i = 0; i < this.queue.size(); ++i) {
            int[] dat;
            if (i >= this.queue.size() || (dat = this.queue.get(i)) == null || dat[0] != id || dat[1] != x || dat[2] != y || dat[3] != z || dat[4] != dim) continue;
            this.queue.remove(i);
            return;
        }
    }

    public void removePipeFromQueue(int x, int y, int z, int dim) {
        for (int i = 0; i < this.queue.size(); ++i) {
            int[] dat;
            if (i >= this.queue.size() || (dat = this.queue.get(i)) == null || dat[1] != x || dat[2] != y || dat[3] != z || dat[4] != dim) continue;
            this.removePipeFromQueue(x, y, z, dim, dat[0]);
        }
    }

    public boolean getIsPipeInQueue(int id, TileEntityThermalPipe te) {
        for (int i = 0; i < this.queue.size(); ++i) {
            int[] dat;
            if (i >= this.queue.size() || (dat = this.queue.get(i)) == null || dat[0] != id || dat[1] != te.field_145851_c || dat[2] != te.field_145848_d || dat[3] != te.field_145849_e || dat[4] != te.func_145831_w().field_73011_w.field_76574_g) continue;
            return true;
        }
        return false;
    }

    public int getNumberOfPipesInQueue(int id) {
        int count = 0;
        for (int[] dat : this.queue) {
            if (dat == null || dat[0] != id) continue;
            ++count;
        }
        return count;
    }

    public void removeAll(int id) {
        this.removeQueue(id);
        this.removeChecked(id);
        this.removeRequest(id);
    }

    public void removeQueue(int id) {
        for (int i = 0; i < this.queue.size(); ++i) {
            int[] dat;
            if (i >= this.queue.size() || (dat = this.queue.get(i)) == null || dat[0] != id) continue;
            this.queue.remove(i);
            this.removeQueue(id);
            return;
        }
    }

    public void removeRequest(int id) {
        for (int i = 0; i < this.ids.size(); ++i) {
            int[] dat;
            if (i >= this.ids.size() || (dat = this.ids.get(i)) == null || dat[0] != id) continue;
            this.ids.remove(i);
            return;
        }
    }

    public void removeChecked(int id) {
        for (int i = 0; i < this.checked.size(); ++i) {
            int[] dat;
            if (i >= this.checked.size() || (dat = this.checked.get(i)) == null || dat[0] != id) continue;
            this.checked.remove(i);
            this.removeChecked(id);
            return;
        }
    }

    @SubscribeEvent
    public void onTick(TickEvent.WorldTickEvent evt) {
        if (evt.side.isServer() && evt.phase == TickEvent.Phase.END) {
            World world = evt.world;
            block0: while (INSTANCE.getDimensionQueue(world.field_73011_w.field_76574_g) > 0) {
                for (int i = 0; i < EnergyRequestRegistry.INSTANCE.queue.size(); ++i) {
                    int[] dat;
                    if (i >= this.queue.size() || (dat = EnergyRequestRegistry.INSTANCE.queue.get(i)) == null || dat[4] != world.field_73011_w.field_76574_g) continue;
                    TileEntityThermalPipe te = (TileEntityThermalPipe)world.func_147438_o(dat[1], dat[2], dat[3]);
                    if (te != null) {
                        INSTANCE.setPipeChecked(te, dat[0]);
                        EnergyRequestRegistry.INSTANCE.queue.remove(i);
                        te.check(dat[0]);
                        continue block0;
                    }
                    EnergyRequestRegistry.INSTANCE.queue.remove(i);
                    continue block0;
                }
            }
        }
    }
}

