/*
 * Decompiled with CFR 0.152.
 */
package com.foodplus.nei;

import codechicken.nei.NEIClientUtils;
import codechicken.nei.recipe.ShapelessRecipeHandler;
import codechicken.nei.recipe.TemplateRecipeHandler;
import com.foodplus.blocks.worktop.WorktopCraftingManager;
import com.foodplus.core.gui.GuiWorktop;
import java.awt.Rectangle;
import java.util.Collection;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.ShapelessRecipes;
import net.minecraftforge.oredict.ShapelessOreRecipe;

public abstract class NEIShapelessRecipeHandler
extends ShapelessRecipeHandler {
    public void loadTransferRects() {
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(84, 23, 24, 18), this.getOverlayIdentifier(), new Object[0]));
    }

    public abstract String getRecipeName();

    public abstract List getRecipeList();

    public abstract Class getGuiClass();

    private ShapelessRecipeHandler.CachedShapelessRecipe shapelessRecipe(ShapelessRecipes recipe) {
        if (recipe.field_77579_b == null) {
            return null;
        }
        return new ShapelessRecipeHandler.CachedShapelessRecipe((ShapelessRecipeHandler)this, recipe.field_77579_b, recipe.func_77571_b());
    }

    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId.equals(this.getOverlayIdentifier())) {
            List allrecipes = WorktopCraftingManager.getInstance().getRecipeList();
            for (IRecipe irecipe : allrecipes) {
                ShapelessRecipeHandler.CachedShapelessRecipe recipe = null;
                if (irecipe instanceof ShapelessRecipes) {
                    recipe = this.shapelessRecipe((ShapelessRecipes)irecipe);
                } else if (irecipe instanceof ShapelessOreRecipe) {
                    recipe = this.forgeShapelessRecipe((ShapelessOreRecipe)irecipe);
                }
                if (recipe == null) continue;
                this.arecipes.add(recipe);
            }
        } else {
            super.loadCraftingRecipes(outputId, results);
        }
    }

    public void loadCraftingRecipes(ItemStack result) {
        List allrecipes = WorktopCraftingManager.getInstance().getRecipeList();
        for (IRecipe irecipe : allrecipes) {
            if (!NEIClientUtils.areStacksSameTypeCrafting((ItemStack)irecipe.func_77571_b(), (ItemStack)result)) continue;
            ShapelessRecipeHandler.CachedShapelessRecipe recipe = null;
            if (irecipe instanceof ShapelessRecipes) {
                recipe = this.shapelessRecipe((ShapelessRecipes)irecipe);
            } else if (irecipe instanceof ShapelessOreRecipe) {
                recipe = this.forgeShapelessRecipe((ShapelessOreRecipe)irecipe);
            }
            if (recipe == null) continue;
            this.arecipes.add(recipe);
        }
    }

    public void loadUsageRecipes(ItemStack ingredient) {
        List allrecipes = WorktopCraftingManager.getInstance().getRecipeList();
        for (IRecipe irecipe : allrecipes) {
            ShapelessRecipeHandler.CachedShapelessRecipe recipe = null;
            if (irecipe instanceof ShapelessRecipes) {
                recipe = this.shapelessRecipe((ShapelessRecipes)irecipe);
            } else if (irecipe instanceof ShapelessOreRecipe) {
                recipe = this.forgeShapelessRecipe((ShapelessOreRecipe)irecipe);
            }
            if (recipe == null || !recipe.contains((Collection)recipe.ingredients, ingredient)) continue;
            recipe.setIngredientPermutation((Collection)recipe.ingredients, ingredient);
            this.arecipes.add(recipe);
        }
    }

    public String getOverlayIdentifier() {
        return this.getRecipeName();
    }

    public static class ShapelessRecipeHandlerWorktop
    extends NEIShapelessRecipeHandler {
        @Override
        public String getRecipeName() {
            return "Worktop shapeless";
        }

        @Override
        public List getRecipeList() {
            return WorktopCraftingManager.getInstance().getRecipeList();
        }

        @Override
        public Class getGuiClass() {
            return GuiWorktop.class;
        }

        public String getGuiTexture() {
            return "foodplus:textures/gui/container/Worktop.png";
        }
    }
}

