/*
 * Decompiled with CFR 0.152.
 */
package com.foodplus.nei;

import codechicken.nei.ItemList;
import codechicken.nei.NEIServerUtils;
import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.TemplateRecipeHandler;
import com.foodplus.blocks.freezer.FreezerRecipeManager;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.gui.inventory.GuiFurnace;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntityFurnace;

public class NEIFreezerRecipeManager
extends TemplateRecipeHandler {
    public static ArrayList<FuelPair> afuels;
    public static HashSet<Block> efuels;

    public void loadTransferRects() {
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(50, 23, 18, 18), "snow", new Object[0]));
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(74, 23, 24, 18), "freezing", new Object[0]));
    }

    public Class<? extends GuiContainer> getGuiClass() {
        return GuiFurnace.class;
    }

    public String getRecipeName() {
        return "Freezer";
    }

    public TemplateRecipeHandler newInstance() {
        if (afuels == null) {
            NEIFreezerRecipeManager.findFuels();
        }
        return super.newInstance();
    }

    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId.equals("freezing") && ((Object)((Object)this)).getClass() == NEIFreezerRecipeManager.class) {
            Map recipes = FreezerRecipeManager.smelting().getSmeltingList();
            for (Map.Entry recipe : recipes.entrySet()) {
                this.arecipes.add(new SmeltingPair((ItemStack)recipe.getKey(), (ItemStack)recipe.getValue()));
            }
        } else {
            super.loadCraftingRecipes(outputId, results);
        }
    }

    public void loadCraftingRecipes(ItemStack result) {
        Map recipes = FreezerRecipeManager.smelting().getSmeltingList();
        for (Map.Entry recipe : recipes.entrySet()) {
            if (!NEIServerUtils.areStacksSameType((ItemStack)((ItemStack)recipe.getValue()), (ItemStack)result)) continue;
            this.arecipes.add(new SmeltingPair((ItemStack)recipe.getKey(), (ItemStack)recipe.getValue()));
        }
    }

    public void loadUsageRecipes(String inputId, Object ... ingredients) {
        if (inputId.equals("snow") && ((Object)((Object)this)).getClass() == NEIFreezerRecipeManager.class) {
            this.loadCraftingRecipes("freezing", new Object[0]);
        } else {
            super.loadUsageRecipes(inputId, ingredients);
        }
    }

    public void loadUsageRecipes(ItemStack ingredient) {
        Map recipes = FreezerRecipeManager.smelting().getSmeltingList();
        for (Map.Entry recipe : recipes.entrySet()) {
            if (!NEIServerUtils.areStacksSameTypeCrafting((ItemStack)((ItemStack)recipe.getKey()), (ItemStack)ingredient)) continue;
            SmeltingPair arecipe = new SmeltingPair((ItemStack)recipe.getKey(), (ItemStack)recipe.getValue());
            arecipe.setIngredientPermutation(Arrays.asList(arecipe.ingred), ingredient);
            this.arecipes.add(arecipe);
        }
    }

    public String getGuiTexture() {
        return "foodplus:textures/gui/container/Refrigerator.png";
    }

    public void drawExtras(int recipe) {
        this.drawProgressBar(51, 25, 176, 0, 14, 14, 48, 7);
        this.drawProgressBar(74, 23, 176, 14, 24, 16, 48, 0);
    }

    private static Set<Item> excludedFuels() {
        HashSet<Item> efuels = new HashSet<Item>();
        efuels.add(Item.func_150898_a((Block)Blocks.field_150338_P));
        efuels.add(Item.func_150898_a((Block)Blocks.field_150337_Q));
        efuels.add(Item.func_150898_a((Block)Blocks.field_150472_an));
        efuels.add(Item.func_150898_a((Block)Blocks.field_150444_as));
        efuels.add(Item.func_150898_a((Block)Blocks.field_150466_ao));
        efuels.add(Item.func_150898_a((Block)Blocks.field_150447_bR));
        return efuels;
    }

    private static void findFuels() {
        afuels = new ArrayList();
        Set<Item> efuels = NEIFreezerRecipeManager.excludedFuels();
        for (ItemStack item : ItemList.items) {
            int burnTime;
            if (efuels.contains(item.func_77973_b()) || (burnTime = TileEntityFurnace.func_145952_a((ItemStack)item)) <= 0) continue;
            afuels.add(new FuelPair(item.func_77946_l(), burnTime));
        }
    }

    public String getOverlayIdentifier() {
        return "freezing";
    }

    public static class FuelPair {
        public PositionedStack stack;
        public int burnTime;

        public FuelPair(ItemStack ingred, int burnTime) {
            this.stack = new PositionedStack((Object)ingred, 51, 42, false);
            this.burnTime = burnTime;
        }
    }

    public class SmeltingPair
    extends TemplateRecipeHandler.CachedRecipe {
        PositionedStack ingred;
        PositionedStack result;

        public SmeltingPair(ItemStack ingred, ItemStack result) {
            super((TemplateRecipeHandler)NEIFreezerRecipeManager.this);
            ingred.field_77994_a = 1;
            this.ingred = new PositionedStack((Object)ingred, 51, 6);
            this.result = new PositionedStack((Object)result, 111, 24);
        }

        public List<PositionedStack> getIngredients() {
            return this.getCycledIngredients(NEIFreezerRecipeManager.this.cycleticks / 48, Arrays.asList(this.ingred));
        }

        public PositionedStack getResult() {
            return this.result;
        }

        public PositionedStack getOtherStack() {
            return NEIFreezerRecipeManager.afuels.get((int)(NEIFreezerRecipeManager.this.cycleticks / 48 % NEIFreezerRecipeManager.afuels.size())).stack;
        }
    }
}

