/*
 * Decompiled with CFR 0.152.
 */
package flappyworld.world;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.World;
import net.minecraft.world.WorldSavedData;
import net.minecraft.world.storage.MapStorage;
import org.apache.commons.lang3.ArrayUtils;

public class WorldSavedDataFW
extends WorldSavedData {
    public HashMap<String, Long> highScores = new HashMap();

    public static WorldSavedDataFW forWorld(World world) {
        MapStorage storage = world.perWorldStorage;
        WorldSavedDataFW result = (WorldSavedDataFW)storage.func_75742_a(WorldSavedDataFW.class, "flappyworld");
        if (result == null) {
            result = new WorldSavedDataFW("flappyworld");
            storage.func_75745_a("flappyworld", (WorldSavedData)result);
        }
        return result;
    }

    public WorldSavedDataFW(String name) {
        super(name);
    }

    public void func_76184_a(NBTTagCompound nbt) {
        if (!nbt.func_74764_b("flappyworld")) {
            nbt.func_74782_a("flappyworld", (NBTBase)new NBTTagList());
        } else {
            NBTTagList mainList = nbt.func_150295_c("flappyworld", 10);
            for (int i = 0; i < mainList.func_74745_c(); ++i) {
                NBTTagCompound save = mainList.func_150305_b(i);
                if (!save.func_74764_b("playerName") || !save.func_74764_b("highScores")) continue;
                this.highScores.put(save.func_74779_i("playerName"), save.func_74763_f("highScores"));
            }
        }
    }

    public void func_76187_b(NBTTagCompound nbt) {
        NBTTagList tagList = new NBTTagList();
        for (String name : this.highScores.keySet()) {
            NBTTagCompound save = new NBTTagCompound();
            save.func_74778_a("playerName", name);
            save.func_74772_a("highScores", this.highScores.get(name).longValue());
            tagList.func_74742_a((NBTBase)save);
        }
        nbt.func_74782_a("flappyworld", (NBTBase)tagList);
    }

    public void setHighScore(EntityPlayer player, long highScore) {
        String name = player.getDisplayName();
        if (this.highScores.containsKey(name)) {
            this.highScores.remove(name);
        }
        this.highScores.put(name, highScore);
        this.func_76185_a();
    }

    public long getHighScore(EntityPlayer player) {
        return this.highScores.get(player.getDisplayName());
    }

    public boolean doesPlayerHighScoreExist(EntityPlayer player) {
        return this.highScores.containsKey(player.getDisplayName());
    }

    public long[] getScores() {
        Collection<Long> scores = this.highScores.values();
        ArrayList<Long> newScores = new ArrayList<Long>();
        for (Long score : scores) {
            boolean f = true;
            for (Long score2 : newScores) {
                if (!score2.equals(score)) continue;
                f = false;
            }
            if (!f) continue;
            newScores.add(score);
        }
        long[] res = new long[newScores.size()];
        for (int i = 0; i < res.length; ++i) {
            res[i] = (Long)newScores.get(i);
        }
        Arrays.sort(res);
        ArrayUtils.reverse((long[])res);
        return res;
    }

    public ArrayList<String> getPlayersWithScore(long score) {
        ArrayList<String> players = new ArrayList<String>();
        for (String name : this.highScores.keySet()) {
            if (this.highScores.get(name) != score) continue;
            players.add(name);
        }
        return players;
    }
}

