/*
 * Decompiled with CFR 0.152.
 */
package flappyworld.network;

import flappyworld.ReferenceFW;
import flappyworld.game.ClientGameSessionFW;
import flappyworld.game.GameSessionFW;
import flappyworld.game.PipeFW;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import java.util.ArrayList;
import net.minecraft.entity.player.EntityPlayer;
import tlhpoeCore.network.AbstractPacketT;

public class PacketSyncPlayerFW
extends AbstractPacketT {
    public long score;
    public long highScore;
    public double posY;
    public double motionY;
    public PipeFW[] pipes;

    public void encodeInto(ChannelHandlerContext ctx, ByteBuf buffer) {
        buffer.writeLong(this.score);
        buffer.writeLong(this.highScore);
        buffer.writeDouble(this.posY);
        buffer.writeDouble(this.motionY);
        buffer.writeShort(this.pipes.length);
        for (int i = 0; i < this.pipes.length; ++i) {
            PipeFW pipePair = this.pipes[i];
            buffer.writeDouble(pipePair.posX);
            buffer.writeInt(pipePair.height);
        }
    }

    public void decodeInto(ChannelHandlerContext ctx, ByteBuf buffer) {
        this.score = buffer.readLong();
        this.highScore = buffer.readLong();
        this.posY = buffer.readDouble();
        this.motionY = buffer.readDouble();
        this.pipes = new PipeFW[buffer.readShort()];
        for (int i = 0; i < this.pipes.length; ++i) {
            PipeFW pipePair = new PipeFW(null);
            pipePair.posX = buffer.readDouble();
            pipePair.height = buffer.readInt();
            this.pipes[i] = pipePair;
        }
    }

    public void handleClientSide(EntityPlayer player) {
        ClientGameSessionFW clientSession = ReferenceFW.clientSession;
        if (clientSession != null) {
            clientSession.score = this.score;
            clientSession.highScore = this.highScore;
            clientSession.posY = this.posY;
            clientSession.motionY = this.motionY;
            clientSession.pipes = this.pipes;
        }
    }

    public void handleServerSide(EntityPlayer player) {
    }

    public PacketSyncPlayerFW pack(EntityPlayer player) {
        GameSessionFW gameSession = ReferenceFW.gameSessions.get(player.getDisplayName());
        if (gameSession != null) {
            this.score = gameSession.score;
            this.highScore = gameSession.highScore;
            this.posY = gameSession.steve.posY;
            this.motionY = gameSession.steve.motionY;
            ArrayList<PipeFW> pipesGS = gameSession.pipes;
            this.pipes = new PipeFW[pipesGS.size()];
            for (int i = 0; i < pipesGS.size(); ++i) {
                this.pipes[i] = pipesGS.get(i);
            }
        }
        return this;
    }
}

