/*
 * Decompiled with CFR 0.152.
 */
package flappyworld.game;

import flappyworld.ReferenceFW;
import flappyworld.game.GameSessionFW;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;

public class SteveFW {
    public final GameSessionFW gameSession;
    public double posY = 100.0;
    public double motionY = 0.0;
    public boolean dead = false;
    public boolean canJump = true;
    public short timer = 0;

    public SteveFW(GameSessionFW gameSession) {
        this.gameSession = gameSession;
    }

    public void update() {
        if (!this.canJump) {
            if (this.timer >= 5) {
                this.timer = 0;
                this.canJump = true;
            } else {
                this.timer = (short)(this.timer + 1);
            }
        }
        this.posY += this.motionY;
        this.motionY -= ReferenceFW.gravity;
    }

    public void jump() {
        if (!this.dead && this.canJump && this.posY < 120.0) {
            this.motionY = ReferenceFW.jumpVel;
            this.canJump = false;
        }
    }

    public Shape getSteveBounds() {
        Rectangle r = new Rectangle(0, (int)this.posY, 16, (int)(this.posY + 16.0));
        AffineTransform t = new AffineTransform();
        double theta = Math.toRadians(SteveFW.getRotation(this.motionY));
        t.rotate(-theta, 8.0, this.posY + 8.0);
        return t.createTransformedShape(r);
    }

    public static double getRotation(double motionY) {
        double rotation = motionY * 10.0;
        if (rotation > 35.0) {
            rotation = 35.0;
        } else if (rotation < -45.0) {
            rotation = -45.0;
        }
        return rotation;
    }
}

