/*
 * Decompiled with CFR 0.152.
 */
package flappyworld.game;

import flappyworld.ReferenceFW;
import flappyworld.game.PipeFW;
import flappyworld.game.SteveFW;
import flappyworld.network.PacketSyncPlayerFW;
import flappyworld.world.WorldSavedDataFW;
import java.awt.Rectangle;
import java.util.ArrayList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;

public class GameSessionFW {
    public final EntityPlayerMP player;
    public SteveFW steve;
    public ArrayList<PipeFW> pipes;
    public long score = 0L;
    public long highScore = 0L;
    public boolean started;
    public boolean done;
    public boolean onGround;

    public GameSessionFW(EntityPlayerMP player) {
        this.player = player;
        this.steve = new SteveFW(this);
        this.pipes = new ArrayList();
        this.pipes.add(new PipeFW(this));
    }

    public void start() {
        this.started = true;
        WorldSavedDataFW data = WorldSavedDataFW.forWorld(this.player.field_70170_p);
        if (data.doesPlayerHighScoreExist((EntityPlayer)this.player)) {
            this.highScore = data.getHighScore((EntityPlayer)this.player);
        }
    }

    public void update() {
        if (this.started) {
            PipeFW pipe;
            int i;
            Rectangle ground = new Rectangle(0, -8, 1000, 1);
            if (this.steve.getSteveBounds().intersects(ground) || this.steve.posY < 0.0) {
                this.steve.dead = true;
                this.onGround = true;
                this.steve.motionY = 0.0;
                this.steve.posY = 0.0;
            }
            if (this.steve.dead && !this.onGround) {
                this.steve.posY += this.steve.motionY;
                this.steve.motionY -= ReferenceFW.gravity;
            }
            for (i = 0; i < this.pipes.size(); ++i) {
                pipe = this.pipes.get(i);
                if (!pipe.crossed && pipe.posX <= 5.0) {
                    ++this.score;
                    pipe.crossed = true;
                }
                if (!this.steve.getSteveBounds().intersects(pipe.getBounds())) continue;
                this.steve.dead = true;
            }
            if (!this.done && !this.steve.dead) {
                for (i = 0; i < this.pipes.size(); ++i) {
                    pipe = this.pipes.get(i);
                    pipe.update();
                    if (!pipe.done) continue;
                    this.pipes.remove(i);
                }
                this.steve.update();
            }
            if (this.steve.dead && !this.done) {
                this.done = true;
            }
            if (this.score > this.highScore) {
                this.highScore = this.score;
                WorldSavedDataFW data = WorldSavedDataFW.forWorld(this.player.field_70170_p);
                data.setHighScore((EntityPlayer)this.player, this.highScore);
            }
            PacketSyncPlayerFW packet = new PacketSyncPlayerFW().pack((EntityPlayer)this.player);
            packet.sendToClient(this.player);
        }
    }
}

