/*
 * Decompiled with CFR 0.152.
 */
package jinngine.physics.solver;

import java.util.List;
import jinngine.math.Vector3;
import jinngine.physics.Body;

public interface Solver {
    public double solve(List<NCPConstraint> var1, List<Body> var2, double var3);

    public void setMaximumIterations(int var1);

    public static final class NCPConstraint {
        public Body body1;
        public Body body2;
        public final Vector3 j1 = new Vector3();
        public final Vector3 j2 = new Vector3();
        public final Vector3 j3 = new Vector3();
        public final Vector3 j4 = new Vector3();
        public final Vector3 b1 = new Vector3();
        public final Vector3 b2 = new Vector3();
        public final Vector3 b3 = new Vector3();
        public final Vector3 b4 = new Vector3();
        public double lambda = 0.0;
        public double lower = 0.0;
        public double upper = 0.0;
        public double diagonal = 0.0;
        public double b = 0.0;
        public double c = 0.0;
        public double mu = 0.0;
        public NCPConstraint coupling;
        public double damper = 0.0;
        public double Fext;
        public double fischer;
        public double residual;
        public double d;
        public double q;
        public double z;
        public double dlambda;
        public double bestdlambda;
        public double s;
        public double u;
        public double l;
        public double distance;

        public final NCPConstraint assign(Body body1, Body body2, Vector3 b1, Vector3 b2, Vector3 b3, Vector3 b4, Vector3 j1, Vector3 j2, Vector3 j3, Vector3 j4, double lambdaMin, double lambdaMax, NCPConstraint coupledMax, double b, double c) {
            this.body1 = body1;
            this.body2 = body2;
            this.b1.assign(b1);
            this.b2.assign(b2);
            this.b3.assign(b3);
            this.b4.assign(b4);
            this.j1.assign(j1);
            this.j2.assign(j2);
            this.j3.assign(j3);
            this.j4.assign(j4);
            this.lambda = 0.0;
            this.lower = lambdaMin;
            this.upper = lambdaMax;
            this.coupling = coupledMax;
            this.b = b;
            this.c = c;
            this.diagonal = j1.dot(b1) + j2.dot(b2) + j3.dot(b3) + j4.dot(b4);
            return this;
        }
    }
}

