/*
 * Decompiled with CFR 0.152.
 */
package jinngine.physics.solver;

import java.util.List;
import jinngine.math.Vector3;
import jinngine.physics.Body;
import jinngine.physics.solver.Solver;

public class GaussSeidel
implements Solver {
    private int maximumIterations = 25;

    @Override
    public void setMaximumIterations(int n) {
        this.maximumIterations = n;
    }

    @Override
    public final double solve(List<Solver.NCPConstraint> constraints, List<Body> bodies, double epsilon) {
        for (int m = 0; m < this.maximumIterations; ++m) {
            for (Solver.NCPConstraint ci : constraints) {
                double w = ci.j1.dot(ci.body1.deltavelocity.add(ci.body1.externaldeltavelocity)) + ci.j2.dot(ci.body1.deltaomega.add(ci.body1.externaldeltaomega)) + ci.j3.dot(ci.body2.deltavelocity.add(ci.body2.externaldeltavelocity)) + ci.j4.dot(ci.body2.deltaomega.add(ci.body2.externaldeltaomega)) + ci.lambda * ci.damper;
                double deltaLambda = (-ci.b - w) / (ci.diagonal + ci.damper);
                double lambda0 = ci.lambda;
                deltaLambda = ci.lambda - lambda0;
                Vector3.add(ci.body1.deltavelocity, ci.b1.multiply(deltaLambda));
                Vector3.add(ci.body1.deltaomega, ci.b2.multiply(deltaLambda));
                Vector3.add(ci.body2.deltavelocity, ci.b3.multiply(deltaLambda));
                Vector3.add(ci.body2.deltaomega, ci.b4.multiply(deltaLambda));
            }
        }
        return 0.0;
    }
}

