/*
 * Decompiled with CFR 0.152.
 */
package jinngine.physics.constraint.joint;

import java.util.Iterator;
import java.util.ListIterator;
import jinngine.math.Matrix3;
import jinngine.math.Vector3;
import jinngine.physics.Body;
import jinngine.physics.constraint.Constraint;
import jinngine.physics.solver.Solver;
import jinngine.util.Pair;

public class BallInSocketJoint
implements Constraint {
    private final Body b1;
    private final Body b2;
    private final Vector3 p1;
    private final Vector3 p2;
    private final Solver.NCPConstraint c1 = new Solver.NCPConstraint();
    private final Solver.NCPConstraint c2 = new Solver.NCPConstraint();
    private final Solver.NCPConstraint c3 = new Solver.NCPConstraint();
    private double forcelimit = Double.POSITIVE_INFINITY;
    private double velocitylimit = Double.POSITIVE_INFINITY;

    public BallInSocketJoint(Body b1, Body b2, Vector3 p, Vector3 n) {
        this.b1 = b1;
        this.b2 = b2;
        this.p1 = b1.toModel(p);
        this.p2 = b2.toModel(p);
    }

    public void setForceLimit(double forcelimit) {
        this.forcelimit = forcelimit;
    }

    public void setCorrectionVelocityLimit(double limit) {
        this.velocitylimit = limit;
    }

    @Override
    public void applyConstraints(ListIterator<Solver.NCPConstraint> iterator, double dt) {
        Vector3 ri = Matrix3.multiply(this.b1.state.rotation, this.p1, new Vector3());
        Vector3 rj = Matrix3.multiply(this.b2.state.rotation, this.p2, new Vector3());
        Matrix3 Ji = Matrix3.identity().multiply(1.0);
        Matrix3 Jangi = ri.crossProductMatrix3().multiply(-1.0);
        Matrix3 Jj = Matrix3.identity().multiply(-1.0);
        Matrix3 Jangj = rj.crossProductMatrix3().multiply(1.0);
        Matrix3 MiInv = Matrix3.identity().multiply(1.0 / this.b1.state.mass);
        Matrix3 Bi = MiInv.multiply(Ji.transpose());
        Matrix3 Bangi = this.b1.state.inverseinertia.multiply(Jangi.transpose());
        if (this.b1.isFixed()) {
            Bi.assign(new Matrix3());
            Bangi.assign(new Matrix3());
        }
        Matrix3 MjInv = Matrix3.identity().multiply(1.0 / this.b2.state.mass);
        Matrix3 Bj = MjInv.multiply(Jj.transpose());
        Matrix3 Bangj = this.b2.state.inverseinertia.multiply(Jangj.transpose());
        if (this.b2.isFixed()) {
            Bj.assign(new Matrix3());
            Bangj.assign(new Matrix3());
        }
        Vector3 u = this.b1.state.velocity.add(this.b1.state.omega.cross(ri)).minus(this.b2.state.velocity.add(this.b2.state.omega.cross(rj)));
        Vector3 posError = this.b1.state.position.add(ri).minus(this.b2.state.position).minus(rj).multiply(1.0 / dt);
        if (posError.norm() > this.velocitylimit) {
            posError.assign(posError.normalize().multiply(this.velocitylimit));
        }
        u.assign(u.add(posError));
        this.c1.assign(this.b1, this.b2, Bi.column(0), Bangi.column(0), Bj.column(0), Bangj.column(0), Ji.row(0), Jangi.row(0), Jj.row(0), Jangj.row(0), -this.forcelimit, this.forcelimit, null, u.x, 0.0);
        this.c2.assign(this.b1, this.b2, Bi.column(1), Bangi.column(1), Bj.column(1), Bangj.column(1), Ji.row(1), Jangi.row(1), Jj.row(1), Jangj.row(1), -this.forcelimit, this.forcelimit, null, u.y, 0.0);
        this.c3.assign(this.b1, this.b2, Bi.column(2), Bangi.column(2), Bj.column(2), Bangj.column(2), Ji.row(2), Jangi.row(2), Jj.row(2), Jangj.row(2), -this.forcelimit, this.forcelimit, null, u.z, 0.0);
        iterator.add(this.c1);
        iterator.add(this.c2);
        iterator.add(this.c3);
    }

    @Override
    public Pair<Body> getBodies() {
        return new Pair<Body>(this.b1, this.b2);
    }

    @Override
    public final Iterator<Solver.NCPConstraint> getNcpConstraints() {
        return new Iterator<Solver.NCPConstraint>(){
            private int i = 0;

            @Override
            public final boolean hasNext() {
                return this.i < 3;
            }

            @Override
            public final Solver.NCPConstraint next() {
                switch (this.i) {
                    case 0: {
                        ++this.i;
                        return BallInSocketJoint.this.c1;
                    }
                    case 1: {
                        ++this.i;
                        return BallInSocketJoint.this.c2;
                    }
                    case 2: {
                        ++this.i;
                        return BallInSocketJoint.this.c3;
                    }
                }
                return null;
            }

            @Override
            public final void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }
}

