/*
 * Decompiled with CFR 0.152.
 */
package jinngine.physics;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import jinngine.collision.BroadphaseCollisionDetection;
import jinngine.collision.SAP2;
import jinngine.geometry.Geometry;
import jinngine.math.Matrix3;
import jinngine.physics.Body;
import jinngine.physics.DeactivationPolicy;
import jinngine.physics.DefaultDeactivationPolicy;
import jinngine.physics.Scene;
import jinngine.physics.Trigger;
import jinngine.physics.constraint.Constraint;
import jinngine.physics.constraint.contact.ContactConstraintManager;
import jinngine.physics.constraint.contact.DefaultContactConstraintManager;
import jinngine.physics.force.Force;
import jinngine.physics.solver.NonsmoothNonlinearConjugateGradient;
import jinngine.physics.solver.ProjectedGaussSeidel;
import jinngine.physics.solver.Solver;
import jinngine.util.ComponentGraph;
import jinngine.util.HashMapComponentGraph;
import jinngine.util.Pair;

public final class DefaultScene
implements Scene {
    public final List<Body> bodies = new ArrayList<Body>();
    public final List<Solver.NCPConstraint> ncpconstraints = new ArrayList<Solver.NCPConstraint>();
    private final List<Body> ncpbodies = new ArrayList<Body>();
    private final List<Force> forces = new ArrayList<Force>();
    private final List<Constraint> liveconstraints = new ArrayList<Constraint>();
    public final List<Trigger> triggers = new LinkedList<Trigger>();
    private final ComponentGraph.NodeClassifier<Body> classifier = new ComponentGraph.NodeClassifier<Body>(){

        @Override
        public boolean isDelimitor(Body node) {
            return node.isFixed();
        }
    };
    private final ComponentGraph.ComponentHandler<Body, ConstraintGroup> componenthandler = new ComponentGraph.ComponentHandler<Body, ConstraintGroup>(){

        @Override
        public ConstraintGroup newComponent() {
            return new ConstraintGroup();
        }

        @Override
        public void mergeComponent(ConstraintGroup remaining, ConstraintGroup leaving) {
            if (!remaining.deactivated || !leaving.deactivated) {
                remaining.deactivated = false;
                Iterator bodies = DefaultScene.this.constraintGraph.getNodesInComponent(remaining);
                while (bodies.hasNext()) {
                    DefaultScene.this.policy.activate((Body)bodies.next());
                }
                bodies = DefaultScene.this.constraintGraph.getNodesInComponent(leaving);
                while (bodies.hasNext()) {
                    DefaultScene.this.policy.activate((Body)bodies.next());
                }
            }
        }

        @Override
        public void nodeAddedToComponent(ConstraintGroup component, Body node) {
            if (!node.deactivated && component.deactivated) {
                Iterator bodies = DefaultScene.this.constraintGraph.getNodesInComponent(component);
                while (bodies.hasNext()) {
                    DefaultScene.this.policy.activate((Body)bodies.next());
                }
                component.deactivated = false;
            }
        }

        @Override
        public void nodeRemovedFromComponent(ConstraintGroup component, Body node) {
        }
    };
    private final ComponentGraph<Body, Constraint, ConstraintGroup> constraintGraph = new HashMapComponentGraph<Body, Constraint, ConstraintGroup>(this.classifier, this.componenthandler);
    private final BroadphaseCollisionDetection broadphase;
    private final ContactConstraintManager contactmanager;
    private final Solver solver;
    private final Solver pgs = new ProjectedGaussSeidel(1);
    private final DeactivationPolicy policy;
    private double timestep = 0.08;

    public DefaultScene(BroadphaseCollisionDetection broadphase, Solver solver, DeactivationPolicy policy) {
        this.broadphase = broadphase;
        this.solver = solver;
        this.policy = policy;
        this.contactmanager = new DefaultContactConstraintManager(broadphase, this.constraintGraph);
    }

    public DefaultScene() {
        this.policy = new DefaultDeactivationPolicy();
        this.broadphase = new SAP2();
        this.solver = new NonsmoothNonlinearConjugateGradient(75);
        this.contactmanager = new DefaultContactConstraintManager(this.broadphase, this.constraintGraph);
    }

    @Override
    public final void tick() {
        this.broadphase.run();
        for (Body bi : this.bodies) {
            bi.clearForces();
            bi.externaldeltavelocity.assignZero();
            bi.externaldeltaomega.assignZero();
        }
        for (Force fi : this.forces) {
            fi.apply(this.timestep);
        }
        for (Constraint live : this.liveconstraints) {
            this.ncpconstraints.clear();
            this.ncpbodies.clear();
            Pair<Body> bodies = live.getBodies();
            this.ncpbodies.add(bodies.getFirst());
            this.ncpbodies.add(bodies.getSecond());
            live.applyConstraints(this.ncpconstraints.listIterator(), this.timestep);
            this.pgs.solve(this.ncpconstraints, this.ncpbodies, 1.0E-7);
        }
        this.ncpconstraints.clear();
        ListIterator<Solver.NCPConstraint> constraintIterator = this.ncpconstraints.listIterator();
        Iterator<ConstraintGroup> components = this.constraintGraph.getComponents();
        while (components.hasNext()) {
            Constraint c;
            Iterator<Constraint> constraints;
            ConstraintGroup data;
            boolean activefound;
            Iterator<Body> bodyiter;
            ConstraintGroup g = components.next();
            if (!g.deactivated) {
                bodyiter = this.constraintGraph.getNodesInComponent(g);
                activefound = false;
                while (bodyiter.hasNext()) {
                    if (this.policy.shouldBeDeactivated(bodyiter.next())) continue;
                    activefound = true;
                    break;
                }
                if (activefound) {
                    data = g;
                    data.deactivated = false;
                    constraints = this.constraintGraph.getEdgesInComponent(g);
                    while (constraints.hasNext()) {
                        c = constraints.next();
                        c.applyConstraints(constraintIterator, this.timestep);
                    }
                    continue;
                }
                data = g;
                data.deactivated = true;
                bodyiter = this.constraintGraph.getNodesInComponent(g);
                while (bodyiter.hasNext()) {
                    this.policy.deactivate(bodyiter.next());
                }
                continue;
            }
            bodyiter = this.constraintGraph.getNodesInComponent(g);
            activefound = false;
            while (bodyiter.hasNext()) {
                if (!this.policy.shouldBeActivated(bodyiter.next())) continue;
                activefound = true;
                break;
            }
            if (!activefound) continue;
            data = g;
            data.deactivated = false;
            bodyiter = this.constraintGraph.getNodesInComponent(g);
            while (bodyiter.hasNext()) {
                this.policy.activate(bodyiter.next());
            }
            constraints = this.constraintGraph.getEdgesInComponent(g);
            while (constraints.hasNext()) {
                c = constraints.next();
                c.applyConstraints(constraintIterator, this.timestep);
            }
        }
        Iterator<Body> freebodies = this.constraintGraph.getFreeNodes();
        while (freebodies.hasNext()) {
            Body body = freebodies.next();
            if (body.deactivated) {
                if (!this.policy.shouldBeActivated(body)) continue;
                this.policy.activate(body);
                continue;
            }
            if (!this.policy.shouldBeDeactivated(body)) continue;
            this.policy.deactivate(body);
        }
        for (Body c : this.bodies) {
            if (c.deactivated) continue;
            c.deltavelocity.assignZero();
            c.deltaomega.assignZero();
        }
        this.solver.solve(this.ncpconstraints, this.bodies, 1.0E-7);
        for (Trigger trigger : this.triggers) {
            trigger.update(this);
        }
        for (Body body : this.bodies) {
            if (body.deactivated) continue;
            if (!body.isFixed()) {
                if (body.deltavelocity.isNaN() || body.deltaomega.isNaN()) {
                    System.exit(0);
                }
                if (body.externaldeltavelocity.isNaN() || body.externaldeltaomega.isNaN()) {
                    System.exit(0);
                }
                body.state.velocity.assign(body.state.velocity.add(body.deltavelocity).add(body.externaldeltavelocity));
                body.state.omega.assign(body.state.omega.add(body.deltaomega).add(body.externaldeltaomega));
                Matrix3.multiply((Matrix3)body.state.inertia, body.state.omega, body.state.L);
                body.state.P.assign(body.state.velocity.multiply(body.state.mass));
            }
            body.advancePositions(this.timestep);
        }
    }

    @Override
    public void addForce(Force f) {
        this.forces.add(f);
    }

    @Override
    public void removeForce(Force f) {
        this.forces.remove(f);
    }

    @Override
    public void addBody(Body c) {
        this.bodies.add(c);
        c.updateTransformations();
        Iterator<Geometry> i = c.getGeometries();
        while (i.hasNext()) {
            Geometry g = i.next();
            this.broadphase.add(g);
        }
    }

    @Override
    public void addConstraint(Constraint joint) {
        this.constraintGraph.addEdge(joint.getBodies(), joint);
    }

    @Override
    public Iterator<Constraint> getConstraints() {
        ArrayList<Constraint> list = new ArrayList<Constraint>();
        Iterator<ConstraintGroup> ci = this.constraintGraph.getComponents();
        while (ci.hasNext()) {
            Iterator<Constraint> ei = this.constraintGraph.getEdgesInComponent(ci.next());
            while (ei.hasNext()) {
                list.add(ei.next());
            }
        }
        return list.iterator();
    }

    @Override
    public final void removeConstraint(Constraint c) {
        if (c != null) {
            this.constraintGraph.removeEdge(c.getBodies());
        } else {
            System.out.println("Engine: attempt to remove null constraint");
        }
    }

    @Override
    public final void removeBody(Body body) {
        Iterator<Geometry> i = body.getGeometries();
        while (i.hasNext()) {
            this.broadphase.remove(i.next());
        }
        this.bodies.remove(body);
    }

    @Override
    public Iterator<Body> getBodies() {
        return this.bodies.iterator();
    }

    @Override
    public void setTimestep(double dt) {
        this.timestep = dt;
    }

    @Override
    public void fixBody(Body b, boolean fixed) {
        if (!this.bodies.contains(b)) {
            return;
        }
        if (b.isFixed() == fixed) {
            return;
        }
        this.removeBody(b);
        b.setFixed(fixed);
        this.addBody(b);
    }

    @Override
    public void addLiveConstraint(Constraint c) {
        this.liveconstraints.add(c);
    }

    @Override
    public void removeLiveConstraint(Constraint c) {
        this.liveconstraints.remove(c);
    }

    @Override
    public void addTrigger(Trigger t) {
        t.setup(this);
        this.triggers.add(t);
    }

    @Override
    public void removeTrigger(Trigger t) {
        this.triggers.remove(t);
        t.cleanup(this);
    }

    @Override
    public double getTimestep() {
        return this.timestep;
    }

    @Override
    public Iterator<Constraint> getConstraints(Body body) {
        return this.constraintGraph.getConnectedEdges(body);
    }

    @Override
    public ContactConstraintManager getContactConstraintManager() {
        return this.contactmanager;
    }

    @Override
    public BroadphaseCollisionDetection getBroadphase() {
        return this.broadphase;
    }

    public final class ConstraintGroup {
        public boolean deactivated = false;

        public String toString() {
            return this.deactivated ? "deactivated" : "active";
        }
    }
}

