/*
 * Decompiled with CFR 0.152.
 */
package jinngine.math;

import jinngine.math.Matrix4;
import jinngine.math.Vector3;

public class Matrix3 {
    public double a11 = 0.0;
    public double a12 = 0.0;
    public double a13 = 0.0;
    public double a21 = 0.0;
    public double a22 = 0.0;
    public double a23 = 0.0;
    public double a31 = 0.0;
    public double a32 = 0.0;
    public double a33 = 0.0;
    public static final Matrix3 zero = new Matrix3(0);

    public Matrix3() {
    }

    public Matrix3(double a11, double a12, double a13, double a21, double a22, double a23, double a31, double a32, double a33) {
        this.a11 = a11;
        this.a12 = a12;
        this.a13 = a13;
        this.a21 = a21;
        this.a22 = a22;
        this.a23 = a23;
        this.a31 = a31;
        this.a32 = a32;
        this.a33 = a33;
    }

    public Matrix3(Vector3 e1, Vector3 e2, Vector3 e3) {
        this.a11 = e1.x;
        this.a21 = e1.y;
        this.a31 = e1.z;
        this.a12 = e2.x;
        this.a22 = e2.y;
        this.a32 = e2.z;
        this.a13 = e3.x;
        this.a23 = e3.y;
        this.a33 = e3.z;
    }

    public Matrix3(Matrix3 B) {
        this.a11 = B.a11;
        this.a12 = B.a12;
        this.a13 = B.a13;
        this.a21 = B.a21;
        this.a22 = B.a22;
        this.a23 = B.a23;
        this.a31 = B.a31;
        this.a32 = B.a32;
        this.a33 = B.a33;
    }

    public Matrix3(Matrix4 B) {
        this.a11 = B.a11;
        this.a12 = B.a12;
        this.a13 = B.a13;
        this.a21 = B.a21;
        this.a22 = B.a22;
        this.a23 = B.a23;
        this.a31 = B.a31;
        this.a32 = B.a32;
        this.a33 = B.a33;
    }

    public void assign(Matrix3 B) {
        this.a11 = B.a11;
        this.a12 = B.a12;
        this.a13 = B.a13;
        this.a21 = B.a21;
        this.a22 = B.a22;
        this.a23 = B.a23;
        this.a31 = B.a31;
        this.a32 = B.a32;
        this.a33 = B.a33;
    }

    public Vector3 column(int n) {
        switch (n) {
            case 0: {
                return new Vector3(this.a11, this.a21, this.a31);
            }
            case 1: {
                return new Vector3(this.a12, this.a22, this.a32);
            }
            case 2: {
                return new Vector3(this.a13, this.a23, this.a33);
            }
        }
        return null;
    }

    public Vector3 row(int n) {
        switch (n) {
            case 0: {
                return new Vector3(this.a11, this.a12, this.a13);
            }
            case 1: {
                return new Vector3(this.a21, this.a22, this.a23);
            }
            case 2: {
                return new Vector3(this.a31, this.a32, this.a33);
            }
        }
        return null;
    }

    public void getColumnVectors(Vector3 r1, Vector3 r2, Vector3 r3) {
        r1.x = this.a11;
        r1.y = this.a21;
        r1.z = this.a31;
        r2.x = this.a12;
        r2.y = this.a22;
        r2.z = this.a32;
        r3.x = this.a13;
        r3.y = this.a23;
        r3.z = this.a33;
    }

    public void getRowVectors(Vector3 r1, Vector3 r2, Vector3 r3) {
        r1.x = this.a11;
        r1.y = this.a12;
        r1.z = this.a13;
        r2.x = this.a21;
        r2.y = this.a22;
        r2.z = this.a23;
        r3.x = this.a31;
        r3.y = this.a32;
        r3.z = this.a33;
    }

    public Matrix3(int s) {
        Matrix3.multiply(this, 0.0, this);
    }

    public static Matrix3 identity() {
        Matrix3 A = new Matrix3();
        A.a11 = 1.0;
        A.a12 = 0.0;
        A.a13 = 0.0;
        A.a21 = 0.0;
        A.a22 = 1.0;
        A.a23 = 0.0;
        A.a31 = 0.0;
        A.a32 = 0.0;
        A.a33 = 1.0;
        return A;
    }

    public final Matrix3 multiply(double s) {
        Matrix3 A = new Matrix3();
        A.a11 = this.a11 * s;
        A.a12 = this.a12 * s;
        A.a13 = this.a13 * s;
        A.a21 = this.a21 * s;
        A.a22 = this.a22 * s;
        A.a23 = this.a23 * s;
        A.a31 = this.a31 * s;
        A.a32 = this.a32 * s;
        A.a33 = this.a33 * s;
        return A;
    }

    public final Matrix3 scale(Vector3 s) {
        Matrix3 A = new Matrix3();
        A.a11 = this.a11 * s.x;
        A.a12 = this.a12 * s.y;
        A.a13 = this.a13 * s.z;
        A.a21 = this.a21 * s.x;
        A.a22 = this.a22 * s.y;
        A.a23 = this.a23 * s.z;
        A.a31 = this.a31 * s.x;
        A.a32 = this.a32 * s.y;
        A.a33 = this.a33 * s.z;
        return A;
    }

    public Matrix3 multiply(Matrix3 A) {
        Matrix3 R = new Matrix3();
        Matrix3.multiply(this, A, R);
        return R;
    }

    public static final Matrix3 multiply(Matrix3 A, Matrix3 B, Matrix3 C) {
        double t11 = A.a11 * B.a11 + A.a12 * B.a21 + A.a13 * B.a31;
        double t12 = A.a11 * B.a12 + A.a12 * B.a22 + A.a13 * B.a32;
        double t13 = A.a11 * B.a13 + A.a12 * B.a23 + A.a13 * B.a33;
        double t21 = A.a21 * B.a11 + A.a22 * B.a21 + A.a23 * B.a31;
        double t22 = A.a21 * B.a12 + A.a22 * B.a22 + A.a23 * B.a32;
        double t23 = A.a21 * B.a13 + A.a22 * B.a23 + A.a23 * B.a33;
        double t31 = A.a31 * B.a11 + A.a32 * B.a21 + A.a33 * B.a31;
        double t32 = A.a31 * B.a12 + A.a32 * B.a22 + A.a33 * B.a32;
        double t33 = A.a31 * B.a13 + A.a32 * B.a23 + A.a33 * B.a33;
        C.a11 = t11;
        C.a12 = t12;
        C.a13 = t13;
        C.a21 = t21;
        C.a22 = t22;
        C.a23 = t23;
        C.a31 = t31;
        C.a32 = t32;
        C.a33 = t33;
        return C;
    }

    public final Vector3 multiply(Vector3 v) {
        Vector3 r = new Vector3();
        Matrix3.multiply(this, v, r);
        return r;
    }

    public static final Matrix3 multiply(Matrix3 A, double s, Matrix3 C) {
        double t11 = A.a11 * s;
        double t12 = A.a12 * s;
        double t13 = A.a13 * s;
        double t21 = A.a21 * s;
        double t22 = A.a22 * s;
        double t23 = A.a23 * s;
        double t31 = A.a31 * s;
        double t32 = A.a32 * s;
        double t33 = A.a33 * s;
        C.a11 = t11;
        C.a12 = t12;
        C.a13 = t13;
        C.a21 = t21;
        C.a22 = t22;
        C.a23 = t23;
        C.a31 = t31;
        C.a32 = t32;
        C.a33 = t33;
        return C;
    }

    public static final Matrix3 transpose(Matrix3 A) {
        double t11 = A.a11;
        double t12 = A.a12;
        double t13 = A.a13;
        double t21 = A.a21;
        double t22 = A.a22;
        double t23 = A.a23;
        double t31 = A.a31;
        double t32 = A.a32;
        double t33 = A.a33;
        A.a11 = t11;
        A.a12 = t21;
        A.a13 = t31;
        A.a21 = t12;
        A.a22 = t22;
        A.a23 = t32;
        A.a31 = t13;
        A.a32 = t23;
        A.a33 = t33;
        return A;
    }

    public final Matrix3 transpose() {
        Matrix3 A = new Matrix3(this);
        Matrix3.transpose(A);
        return A;
    }

    public static final void subtract(Matrix3 A, Matrix3 B, Matrix3 C) {
        double t11 = A.a11 - B.a11;
        double t12 = A.a12 - B.a12;
        double t13 = A.a13 - B.a13;
        double t21 = A.a21 - B.a21;
        double t22 = A.a22 - B.a22;
        double t23 = A.a23 - B.a23;
        double t31 = A.a31 - B.a31;
        double t32 = A.a32 - B.a32;
        double t33 = A.a33 - B.a33;
        C.a11 = t11;
        C.a12 = t12;
        C.a13 = t13;
        C.a21 = t21;
        C.a22 = t22;
        C.a23 = t23;
        C.a31 = t31;
        C.a32 = t32;
        C.a33 = t33;
    }

    public Matrix3 add(Matrix3 B) {
        Matrix3 A = new Matrix3(this);
        Matrix3.add(A, B, A);
        return A;
    }

    public static final void add(Matrix3 A, Matrix3 B, Matrix3 C) {
        double t11 = A.a11 + B.a11;
        double t12 = A.a12 + B.a12;
        double t13 = A.a13 + B.a13;
        double t21 = A.a21 + B.a21;
        double t22 = A.a22 + B.a22;
        double t23 = A.a23 + B.a23;
        double t31 = A.a31 + B.a31;
        double t32 = A.a32 + B.a32;
        double t33 = A.a33 + B.a33;
        C.a11 = t11;
        C.a12 = t12;
        C.a13 = t13;
        C.a21 = t21;
        C.a22 = t22;
        C.a23 = t23;
        C.a31 = t31;
        C.a32 = t32;
        C.a33 = t33;
    }

    public static final Vector3 transposeVectorAndMultiply(Vector3 v, Matrix3 A, Vector3 r) {
        double t1 = v.x * A.a11 + v.y * A.a21 + v.z * A.a31;
        double t2 = v.x * A.a12 + v.y * A.a22 + v.z * A.a32;
        double t3 = v.x * A.a13 + v.y * A.a23 + v.z * A.a33;
        r.x = t1;
        r.y = t2;
        r.z = t3;
        return r;
    }

    public static final Vector3 multiply(Matrix3 A, Vector3 v, Vector3 r) {
        double t1 = v.x * A.a11 + v.y * A.a12 + v.z * A.a13;
        double t2 = v.x * A.a21 + v.y * A.a22 + v.z * A.a23;
        double t3 = v.x * A.a31 + v.y * A.a32 + v.z * A.a33;
        r.x = t1;
        r.y = t2;
        r.z = t3;
        return r;
    }

    public static final double determinant(Matrix3 A) {
        return A.a11 * A.a22 * A.a33 - A.a11 * A.a23 * A.a32 + A.a21 * A.a32 * A.a13 - A.a21 * A.a12 * A.a33 + A.a31 * A.a12 * A.a23 - A.a31 * A.a22 * A.a13;
    }

    public static final Matrix3 inverse(Matrix3 A, Matrix3 C) {
        double t11 = (A.a22 * A.a33 - A.a23 * A.a32) / (A.a31 * A.a12 * A.a23 - A.a31 * A.a13 * A.a22 - A.a21 * A.a12 * A.a33 + A.a21 * A.a13 * A.a32 + A.a11 * A.a22 * A.a33 - A.a11 * A.a23 * A.a32);
        double t12 = -(A.a12 * A.a33 - A.a13 * A.a32) / (A.a31 * A.a12 * A.a23 - A.a31 * A.a13 * A.a22 - A.a21 * A.a12 * A.a33 + A.a21 * A.a13 * A.a32 + A.a11 * A.a22 * A.a33 - A.a11 * A.a23 * A.a32);
        double t13 = (A.a12 * A.a23 - A.a13 * A.a22) / (A.a31 * A.a12 * A.a23 - A.a31 * A.a13 * A.a22 - A.a21 * A.a12 * A.a33 + A.a21 * A.a13 * A.a32 + A.a11 * A.a22 * A.a33 - A.a11 * A.a23 * A.a32);
        double t21 = -(-A.a31 * A.a23 + A.a21 * A.a33) / (A.a31 * A.a12 * A.a23 - A.a31 * A.a13 * A.a22 - A.a21 * A.a12 * A.a33 + A.a21 * A.a13 * A.a32 + A.a11 * A.a22 * A.a33 - A.a11 * A.a23 * A.a32);
        double t22 = (-A.a31 * A.a13 + A.a11 * A.a33) / (A.a31 * A.a12 * A.a23 - A.a31 * A.a13 * A.a22 - A.a21 * A.a12 * A.a33 + A.a21 * A.a13 * A.a32 + A.a11 * A.a22 * A.a33 - A.a11 * A.a23 * A.a32);
        double t23 = -(-A.a21 * A.a13 + A.a11 * A.a23) / (A.a31 * A.a12 * A.a23 - A.a31 * A.a13 * A.a22 - A.a21 * A.a12 * A.a33 + A.a21 * A.a13 * A.a32 + A.a11 * A.a22 * A.a33 - A.a11 * A.a23 * A.a32);
        double t31 = (-A.a31 * A.a22 + A.a21 * A.a32) / (A.a31 * A.a12 * A.a23 - A.a31 * A.a13 * A.a22 - A.a21 * A.a12 * A.a33 + A.a21 * A.a13 * A.a32 + A.a11 * A.a22 * A.a33 - A.a11 * A.a23 * A.a32);
        double t32 = -(-A.a31 * A.a12 + A.a11 * A.a32) / (A.a31 * A.a12 * A.a23 - A.a31 * A.a13 * A.a22 - A.a21 * A.a12 * A.a33 + A.a21 * A.a13 * A.a32 + A.a11 * A.a22 * A.a33 - A.a11 * A.a23 * A.a32);
        double t33 = (-A.a21 * A.a12 + A.a11 * A.a22) / (A.a31 * A.a12 * A.a23 - A.a31 * A.a13 * A.a22 - A.a21 * A.a12 * A.a33 + A.a21 * A.a13 * A.a32 + A.a11 * A.a22 * A.a33 - A.a11 * A.a23 * A.a32);
        C.a11 = t11;
        C.a12 = t12;
        C.a13 = t13;
        C.a21 = t21;
        C.a22 = t22;
        C.a23 = t23;
        C.a31 = t31;
        C.a32 = t32;
        C.a33 = t33;
        return C;
    }

    public final Matrix3 inverse() {
        Matrix3 I = new Matrix3();
        Matrix3.inverse(this, I);
        return I;
    }

    public static final void set(double[][] matrixArray, Matrix3 A) {
        A.a11 = matrixArray[0][0];
        A.a12 = matrixArray[0][1];
        A.a13 = matrixArray[0][2];
        A.a21 = matrixArray[1][0];
        A.a22 = matrixArray[1][1];
        A.a23 = matrixArray[1][2];
        A.a31 = matrixArray[2][0];
        A.a32 = matrixArray[2][1];
        A.a33 = matrixArray[2][2];
    }

    public static final void set(Matrix3 A, Matrix3 B) {
        B.a11 = A.a11;
        B.a12 = A.a12;
        B.a13 = A.a13;
        B.a21 = A.a21;
        B.a22 = A.a22;
        B.a23 = A.a23;
        B.a31 = A.a31;
        B.a32 = A.a32;
        B.a33 = A.a33;
    }

    public static final void set(Matrix3 A, double p11, double p12, double p13, double p21, double p22, double p23, double p31, double p32, double p33) {
        A.a11 = p11;
        A.a12 = p12;
        A.a13 = p13;
        A.a21 = p21;
        A.a22 = p22;
        A.a23 = p23;
        A.a31 = p31;
        A.a32 = p32;
        A.a33 = p33;
    }

    public static final Matrix3 identity(Matrix3 C) {
        C.a11 = 1.0;
        C.a12 = 0.0;
        C.a13 = 0.0;
        C.a21 = 0.0;
        C.a22 = 1.0;
        C.a23 = 0.0;
        C.a31 = 0.0;
        C.a32 = 0.0;
        C.a33 = 1.0;
        return C;
    }

    public static final Matrix3 scale(Matrix3 C, Vector3 s) {
        C.a11 = s.x;
        C.a12 = 0.0;
        C.a13 = 0.0;
        C.a21 = 0.0;
        C.a22 = s.y;
        C.a23 = 0.0;
        C.a31 = 0.0;
        C.a32 = 0.0;
        C.a33 = s.z;
        return C;
    }

    public static final Matrix3 diagonal(Vector3 d) {
        Matrix3 C = new Matrix3();
        C.a11 = d.x;
        C.a12 = 0.0;
        C.a13 = 0.0;
        C.a21 = 0.0;
        C.a22 = d.y;
        C.a23 = 0.0;
        C.a31 = 0.0;
        C.a32 = 0.0;
        C.a33 = d.z;
        return C;
    }

    public final Matrix3 copy() {
        Matrix3 M = new Matrix3();
        Matrix3.set(this, M);
        return M;
    }

    public static final void print(Matrix3 A) {
        System.out.println("[ " + A.a11 + " , " + A.a12 + " , " + A.a13 + " ]");
        System.out.println("[ " + A.a21 + " , " + A.a22 + " , " + A.a23 + " ]");
        System.out.println("[ " + A.a31 + " , " + A.a32 + " , " + A.a33 + " ]");
    }

    public final boolean isNaN() {
        return Double.isNaN(this.a11) || Double.isNaN(this.a12) || Double.isNaN(this.a13) || Double.isNaN(this.a21) || Double.isNaN(this.a22) || Double.isNaN(this.a23) || Double.isNaN(this.a31) || Double.isNaN(this.a32) || Double.isNaN(this.a33);
    }

    public static final double[] pack(Matrix3 M) {
        double[] array = new double[]{M.a11, M.a21, M.a31, M.a12, M.a22, M.a32, M.a13, M.a23, M.a33};
        return array;
    }
}

