/*
 * Decompiled with CFR 0.152.
 */
package jinngine.geometry.contact;

import java.util.Iterator;
import java.util.List;
import jinngine.collision.GJK;
import jinngine.collision.RayCast;
import jinngine.geometry.Geometry;
import jinngine.geometry.Sphere;
import jinngine.geometry.SupportMap3;
import jinngine.geometry.contact.ContactGenerator;
import jinngine.math.Matrix3;
import jinngine.math.Vector3;
import jinngine.physics.Body;

public final class SupportMapSphereContactGenerator
implements ContactGenerator {
    private final Body b1;
    private final Body b2;
    private final Geometry g1;
    private final SupportMap3 convex;
    private final SupportMap3 pointmap;
    private final Sphere sphere;
    private final Vector3 spherecentreworld = new Vector3();
    private final Vector3 convexcentreworld = new Vector3();
    private final ContactGenerator.ContactPoint cp = new ContactGenerator.ContactPoint();
    private boolean incontact = false;
    private boolean invertnormal = false;
    private static double epsilon = 1.0E-7;
    private static double envelope = 0.0625;
    private static double shell = envelope * 0.75;
    private final GJK closest = new GJK();
    private final RayCast raycast = new RayCast();

    public SupportMapSphereContactGenerator(Body b1, Geometry g1, SupportMap3 convex, Body b2, Sphere sphere) {
        this.convex = convex;
        this.sphere = sphere;
        this.b1 = b1;
        this.b2 = b2;
        this.g1 = g1;
        this.pointmap = new SupportMap3(){

            @Override
            public final Vector3 supportPoint(Vector3 direction) {
                return SupportMapSphereContactGenerator.this.spherecentreworld.copy();
            }

            @Override
            public final void supportFeature(Vector3 d, double epsilon, List<Vector3> face) {
            }
        };
        this.cp.restitution = 0.7;
        this.cp.friction = 0.5;
    }

    public SupportMapSphereContactGenerator(Body b2, Sphere sphere, Body b1, Geometry g1, SupportMap3 convex) {
        this.convex = convex;
        this.sphere = sphere;
        this.b1 = b1;
        this.g1 = g1;
        this.b2 = b2;
        this.pointmap = new SupportMap3(){

            @Override
            public final Vector3 supportPoint(Vector3 direction) {
                return SupportMapSphereContactGenerator.this.spherecentreworld.copy();
            }

            @Override
            public final void supportFeature(Vector3 d, double epsilon, List<Vector3> face) {
            }
        };
        this.cp.restitution = 0.7;
        this.cp.friction = 0.5;
        this.invertnormal = true;
    }

    @Override
    public final Iterator<ContactGenerator.ContactPoint> getContacts() {
        return new Iterator<ContactGenerator.ContactPoint>(){
            boolean done = false;

            @Override
            public boolean hasNext() {
                return !this.done && SupportMapSphereContactGenerator.this.incontact;
            }

            @Override
            public ContactGenerator.ContactPoint next() {
                this.done = true;
                return SupportMapSphereContactGenerator.this.cp;
            }

            @Override
            public void remove() {
            }
        };
    }

    @Override
    public final void run() {
        this.sphere.getLocalTranslation(this.spherecentreworld);
        Matrix3.multiply(this.b2.state.rotation, this.spherecentreworld, this.spherecentreworld);
        Vector3.add(this.spherecentreworld, this.b2.state.position);
        this.closest.run(this.convex, this.pointmap, this.cp.paw, this.cp.pbw, this.sphere.getRadius() + envelope, epsilon, 31);
        if (this.closest.getState().simplexSize > 3 || this.cp.paw.minus(this.cp.pbw).norm() < 1.0E-7) {
            System.out.println("SupportMap-sphere: penetration");
            this.g1.getLocalTranslation(this.convexcentreworld);
            Matrix3.multiply(this.g1.getBody().state.rotation, this.convexcentreworld, this.convexcentreworld);
            Vector3 direction = this.g1.getBody().getPosition().add(this.convexcentreworld).minus(this.spherecentreworld);
            Vector3 sp = this.convex.supportPoint(direction.negate()).minus(this.pointmap.supportPoint(direction));
            double lambda = direction.dot(sp) / direction.dot(direction) - envelope / direction.norm();
            this.raycast.run(this.convex, this.pointmap, new Vector3(), direction, this.cp.paw, this.cp.pbw, lambda, this.sphere.getRadius() + envelope, epsilon);
            this.cp.normal.assign(this.cp.paw.minus(this.cp.pbw).normalize());
            this.cp.paw.assign(this.spherecentreworld.add(this.cp.normal.multiply(-this.cp.paw.dot(this.cp.normal))));
            this.cp.pbw.assign(this.spherecentreworld.add(this.cp.normal.multiply(this.sphere.getRadius())));
        } else {
            this.cp.normal.assign(this.cp.paw.minus(this.cp.pbw).normalize());
            this.cp.pbw.assign(this.spherecentreworld.add(this.cp.normal.multiply(this.sphere.getRadius())));
        }
        this.cp.distance = this.cp.paw.minus(this.cp.pbw).dot(this.cp.normal);
        this.cp.point.assign(this.cp.paw.add(this.cp.pbw).multiply(0.5));
        if (this.invertnormal) {
            Vector3.multiply(this.cp.normal, -1.0);
        }
        if (this.cp.distance >= 0.0 && this.cp.distance < envelope) {
            this.cp.depth = shell - this.cp.distance;
            this.incontact = true;
            return;
        }
        if (this.cp.distance < 0.0) {
            this.cp.depth = shell - this.cp.distance;
            this.incontact = true;
            return;
        }
        this.cp.depth = 0.0;
        this.incontact = false;
    }

    @Override
    public final void remove() {
    }
}

