/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.common.teams;

import com.flansmod.common.FlansMod;
import com.flansmod.common.guns.AttachmentType;
import com.flansmod.common.guns.ItemGun;
import com.flansmod.common.types.InfoType;
import com.flansmod.common.types.TypeFile;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class PlayerClass
extends InfoType {
    public static List<PlayerClass> classes = new ArrayList<PlayerClass>();
    public List<ItemStack> startingItems = new ArrayList<ItemStack>();
    public boolean horse = false;

    public PlayerClass(TypeFile file) {
        super(file);
        classes.add(this);
    }

    @Override
    protected void read(String[] split, TypeFile file) {
        super.read(split, file);
        try {
            if (split[0].equals("AddItem")) {
                Item matchingItem = null;
                int amount = 1;
                int damage = 0;
                String[] itemNames = split[1].split("\\+");
                for (Object object : Item.field_150901_e) {
                    Item item = (Item)object;
                    if (item == null || item.func_77658_a() == null || !item.func_77658_a().equals(itemNames[0]) && (item.func_77658_a().split("\\.").length <= 1 || !item.func_77658_a().split("\\.")[1].equals(itemNames[0]))) continue;
                    matchingItem = item;
                }
                for (InfoType type : InfoType.infoTypes) {
                    if (!type.shortName.equals(itemNames[0]) || type.item == null) continue;
                    matchingItem = type.item;
                }
                if (matchingItem == null) {
                    FlansMod.log("Tried to add " + split[1] + " to player class " + this.shortName + " but the item did not exist");
                    return;
                }
                if (split.length > 2) {
                    amount = Integer.parseInt(split[2]);
                }
                if (split.length > 3) {
                    damage = Integer.parseInt(split[3]);
                }
                ItemStack stack = new ItemStack(matchingItem, amount, damage);
                if (itemNames.length > 1 && matchingItem instanceof ItemGun) {
                    NBTTagCompound tags = new NBTTagCompound();
                    NBTTagCompound attachmentTags = new NBTTagCompound();
                    int genericID = 0;
                    for (int i = 0; i < itemNames.length - 1; ++i) {
                        AttachmentType attachment = AttachmentType.getAttachment(itemNames[i + 1]);
                        String tagName = null;
                        switch (attachment.type) {
                            case sights: {
                                tagName = "scope";
                                break;
                            }
                            case barrel: {
                                tagName = "barrel";
                                break;
                            }
                            case stock: {
                                tagName = "stock";
                                break;
                            }
                            case grip: {
                                tagName = "grip";
                                break;
                            }
                            case generic: {
                                tagName = "generic_" + genericID++;
                            }
                        }
                        NBTTagCompound specificAttachmentTags = new NBTTagCompound();
                        new ItemStack(attachment.item).func_77955_b(specificAttachmentTags);
                        attachmentTags.func_74782_a(tagName, (NBTBase)specificAttachmentTags);
                    }
                    tags.func_74782_a("attachments", (NBTBase)attachmentTags);
                    stack.field_77990_d = tags;
                }
                this.startingItems.add(stack);
            }
        }
        catch (Exception e) {
            System.out.println("Reading class file failed.");
            e.printStackTrace();
        }
    }

    public static PlayerClass getClass(String s) {
        for (PlayerClass playerClass : classes) {
            if (!playerClass.shortName.equals(s)) continue;
            return playerClass;
        }
        return null;
    }
}

