/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.common.guns.boxes;

import com.flansmod.common.FlansMod;
import com.flansmod.common.guns.BulletType;
import com.flansmod.common.guns.boxes.BlockGunBox;
import com.flansmod.common.types.InfoType;
import com.flansmod.common.types.TypeFile;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;

public class GunBoxType
extends InfoType {
    public BlockGunBox block;
    public String topTexturePath;
    public String sideTexturePath;
    public String bottomTexturePath;
    @SideOnly(value=Side.CLIENT)
    public IIcon top;
    @SideOnly(value=Side.CLIENT)
    public IIcon side;
    @SideOnly(value=Side.CLIENT)
    public IIcon bottom;
    public int numGuns;
    public int nextGun = -1;
    public InfoType[] guns;
    public BulletType[] bullets;
    public BulletType[] altBullets;
    public List<ItemStack>[] gunParts;
    public List<ItemStack>[] bulletParts;
    public List<ItemStack>[] altBulletParts;
    private static int lastIconIndex = 2;
    public static HashMap<String, GunBoxType> gunBoxMap = new HashMap();
    public static ArrayList<String> shortNameList = new ArrayList();

    public GunBoxType(TypeFile file) {
        super(file);
        for (String line : file.lines) {
            String[] split;
            if (line == null) break;
            if (line.startsWith("//") || (split = line.split(" ")).length < 2 || !split[0].equals("NumGuns")) continue;
            this.numGuns = Integer.parseInt(split[1]);
            this.guns = new InfoType[this.numGuns];
            this.bullets = new BulletType[this.numGuns];
            this.altBullets = new BulletType[this.numGuns];
            this.gunParts = new List[this.numGuns];
            this.bulletParts = new List[this.numGuns];
            this.altBulletParts = new List[this.numGuns];
            for (int i = 0; i < this.numGuns; ++i) {
                this.gunParts[i] = new ArrayList<ItemStack>();
                this.bulletParts[i] = new ArrayList<ItemStack>();
                this.altBulletParts[i] = new ArrayList<ItemStack>();
            }
        }
    }

    @Override
    public void read(TypeFile file) {
        super.read(file);
        gunBoxMap.put(this.shortName, this);
        shortNameList.add(this.shortName);
    }

    @Override
    protected void read(String[] split, TypeFile file) {
        super.read(split, file);
        try {
            int i;
            if (split[0].equals("TopTexture")) {
                this.topTexturePath = split[1];
            }
            if (split[0].equals("BottomTexture")) {
                this.bottomTexturePath = split[1];
            }
            if (split[0].equals("SideTexture")) {
                this.sideTexturePath = split[1];
            }
            if (split[0].equals("AddGun")) {
                ++this.nextGun;
                if (this.gunParts[this.nextGun] == null) {
                    FlansMod.log("NumGuns was not found or was incorrect");
                }
                this.guns[this.nextGun] = InfoType.getType(split[1]);
                for (i = 0; i < (split.length - 2) / 2; ++i) {
                    if (split[i * 2 + 3].contains(".")) {
                        this.gunParts[this.nextGun].add(GunBoxType.getRecipeElement(split[i * 2 + 3].split("\\.")[0], Integer.parseInt(split[i * 2 + 2]), Integer.valueOf(split[i * 2 + 3].split("\\.")[1])));
                        continue;
                    }
                    this.gunParts[this.nextGun].add(GunBoxType.getRecipeElement(split[i * 2 + 3], Integer.parseInt(split[i * 2 + 2]), 0));
                }
            }
            if (split[0].equals("AddAmmo")) {
                if (this.bulletParts[this.nextGun] == null) {
                    FlansMod.log("NumGuns was not found or was incorrect");
                }
                this.bullets[this.nextGun] = BulletType.getBullet(split[1]);
                for (i = 0; i < (split.length - 2) / 2; ++i) {
                    if (split[i * 2 + 3].contains(".")) {
                        this.bulletParts[this.nextGun].add(GunBoxType.getRecipeElement(split[i * 2 + 3].split("\\.")[0], Integer.parseInt(split[i * 2 + 2]), Integer.valueOf(split[i * 2 + 3].split("\\.")[1])));
                        continue;
                    }
                    this.bulletParts[this.nextGun].add(GunBoxType.getRecipeElement(split[i * 2 + 3], Integer.parseInt(split[i * 2 + 2]), 0));
                }
            }
            if (split[0].equals("AddAltAmmo") || split[0].equals("AddAlternateAmmo")) {
                if (this.altBulletParts[this.nextGun] == null) {
                    FlansMod.log("NumGuns was not found or was incorrect");
                }
                this.altBullets[this.nextGun] = BulletType.getBullet(split[1]);
                for (i = 0; i < (split.length - 2) / 2; ++i) {
                    if (split[i * 2 + 3].contains(".")) {
                        this.altBulletParts[this.nextGun].add(GunBoxType.getRecipeElement(split[i * 2 + 3].split("\\.")[0], Integer.parseInt(split[i * 2 + 2]), Integer.valueOf(split[i * 2 + 3].split("\\.")[1])));
                        continue;
                    }
                    this.altBulletParts[this.nextGun].add(GunBoxType.getRecipeElement(split[i * 2 + 3], Integer.parseInt(split[i * 2 + 2]), 0));
                }
            }
        }
        catch (Exception e) {
            System.out.println("Reading gun box file failed : " + this.shortName);
            e.printStackTrace();
        }
    }

    public static GunBoxType getBox(String s) {
        return gunBoxMap.get(s);
    }

    public static GunBoxType getBox(Block block) {
        for (GunBoxType type : gunBoxMap.values()) {
            if (type.block != block) continue;
            return type;
        }
        return null;
    }

    public static ItemStack getRecipeElement(String stringy, int amount, int damage) {
        ItemStack stack = GunBoxType.getRecipeElement(stringy, damage);
        if (stack == null) {
            return stack;
        }
        stack.field_77994_a = amount;
        return stack;
    }

    @Override
    public void addRecipe(Item par1Item) {
        if (this.smeltableFrom != null) {
            GameRegistry.addSmelting((ItemStack)GunBoxType.getRecipeElement(this.smeltableFrom, 0), (ItemStack)new ItemStack(this.item), (float)0.0f);
        }
        if (this.recipeLine == null) {
            return;
        }
        try {
            if (!this.shapeless) {
                Object[] newRecipe1;
                int last;
                int rows = 3;
                if (((String)this.recipe[0]).charAt(0) == ' ' && ((String)this.recipe[1]).charAt(0) == ' ' && ((String)this.recipe[2]).charAt(0) == ' ') {
                    int i;
                    for (i = 0; i < 3; ++i) {
                        this.recipe[i] = ((String)this.recipe[i]).substring(1);
                    }
                    if (((String)this.recipe[0]).charAt(0) == ' ' && ((String)this.recipe[1]).charAt(0) == ' ' && ((String)this.recipe[2]).charAt(0) == ' ') {
                        for (i = 0; i < 3; ++i) {
                            this.recipe[i] = ((String)this.recipe[i]).substring(1);
                        }
                    }
                }
                if (((String)this.recipe[0]).charAt(last = ((String)this.recipe[0]).length() - 1) == ' ' && ((String)this.recipe[1]).charAt(last) == ' ' && ((String)this.recipe[2]).charAt(last) == ' ') {
                    int i;
                    for (i = 0; i < 3; ++i) {
                        this.recipe[i] = ((String)this.recipe[i]).substring(0, last);
                    }
                    if (((String)this.recipe[0]).charAt(--last) == ' ' && ((String)this.recipe[1]).charAt(last) == ' ' && ((String)this.recipe[2]).charAt(last) == ' ') {
                        for (i = 0; i < 3; ++i) {
                            this.recipe[i] = ((String)this.recipe[i]).substring(0, 0);
                        }
                    }
                }
                if (this.recipe[0].equals(" ") || this.recipe[0].equals("  ") || this.recipe[0].equals("   ")) {
                    Object[] newRecipe = new Object[this.recipe.length - 1];
                    newRecipe[0] = this.recipe[1];
                    newRecipe[1] = this.recipe[2];
                    this.recipe = newRecipe;
                    --rows;
                    if (this.recipe[0].equals(" ") || this.recipe[0].equals("  ") || this.recipe[0].equals("   ")) {
                        newRecipe1 = new Object[this.recipe.length - 1];
                        newRecipe1[0] = this.recipe[1];
                        this.recipe = newRecipe1;
                        --rows;
                    }
                }
                if (this.recipe[rows - 1].equals(" ") || this.recipe[rows - 1].equals("  ") || this.recipe[rows - 1].equals("   ")) {
                    Object[] newRecipe = new Object[this.recipe.length - 1];
                    newRecipe[0] = this.recipe[0];
                    newRecipe[1] = this.recipe[1];
                    this.recipe = newRecipe;
                    if (this.recipe[--rows - 1].equals(" ") || this.recipe[rows - 1].equals("  ") || this.recipe[rows - 1].equals("   ")) {
                        newRecipe1 = new Object[this.recipe.length - 1];
                        newRecipe1[0] = this.recipe[0];
                        this.recipe = newRecipe1;
                        --rows;
                    }
                }
                for (int i = 0; i < (this.recipeLine.length - 1) / 2; ++i) {
                    this.recipe[i * 2 + rows] = Character.valueOf(this.recipeLine[i * 2 + 1].charAt(0));
                    this.recipe[i * 2 + rows + 1] = this.recipeLine[i * 2 + 2].contains(".") ? GunBoxType.getRecipeElement(this.recipeLine[i * 2 + 2].split("\\.")[0], Integer.valueOf(this.recipeLine[i * 2 + 2].split("\\.")[1])) : GunBoxType.getRecipeElement(this.recipeLine[i * 2 + 2], 0);
                }
                GameRegistry.addRecipe((ItemStack)new ItemStack((Block)this.block, this.recipeOutput, 0), (Object[])this.recipe);
            } else {
                this.recipe = new Object[this.recipeLine.length - 1];
                for (int i = 0; i < this.recipeLine.length - 1; ++i) {
                    this.recipe[i] = this.recipeLine[i + 1].contains(".") ? GunBoxType.getRecipeElement(this.recipeLine[i + 1].split("\\.")[0], Integer.valueOf(this.recipeLine[i + 1].split("\\.")[1])) : GunBoxType.getRecipeElement(this.recipeLine[i + 1], 0);
                }
                GameRegistry.addShapelessRecipe((ItemStack)new ItemStack((Block)this.block, this.recipeOutput, 0), (Object[])this.recipe);
            }
        }
        catch (Exception e) {
            FlansMod.log("Failed to add recipe for : " + this.shortName);
            e.printStackTrace();
        }
    }
}

