/*
 * Decompiled with CFR 0.152.
 */
package jinngine.util;

import jinngine.math.Matrix3;
import jinngine.math.Vector3;

public class GramSchmidt {
    public static Matrix3 run(Vector3 v) {
        Vector3 t1 = v.normalize();
        Vector3 t2 = new Vector3(1.0, 0.0, 0.0);
        t2.assign(t2.minus(t1.multiply(t1.dot(t2))));
        if (t2.norm() < 1.0E-10) {
            t2.assign(new Vector3(0.0, 0.0, 1.0));
            t2.assign(t2.minus(t1.multiply(t1.dot(t2))));
        }
        t2.assign(t2.normalize());
        Vector3 t3 = t1.cross(t2).normalize();
        return new Matrix3(t1, t2, t3);
    }

    public static Matrix3 run(Vector3 v1, Vector3 v2) {
        Vector3 t1 = v1.normalize();
        Vector3 t2 = v2.copy();
        t2.assign(t2.minus(t1.multiply(t1.dot(t2))));
        if (t2.norm() < 1.0E-10) {
            t2.assign(new Vector3(0.0, 0.0, 1.0));
            t2.assign(t2.minus(t1.multiply(t1.dot(t2))));
        }
        t2.assign(t2.normalize());
        Vector3 t3 = t1.cross(t2).normalize();
        return new Matrix3(t1, t2, t3);
    }
}

