/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.common.teams;

import com.flansmod.common.FlansMod;
import com.flansmod.common.PlayerData;
import com.flansmod.common.PlayerHandler;
import com.flansmod.common.teams.ArmourType;
import com.flansmod.common.teams.ITeamBase;
import com.flansmod.common.teams.ItemTeamArmour;
import com.flansmod.common.teams.PlayerClass;
import com.flansmod.common.types.EnumType;
import com.flansmod.common.types.InfoType;
import com.flansmod.common.types.TypeFile;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class Team
extends InfoType {
    public static List<Team> teams = new ArrayList<Team>();
    public List<String> members = new ArrayList<String>();
    public List<ITeamBase> bases = new ArrayList<ITeamBase>();
    public List<PlayerClass> classes = new ArrayList<PlayerClass>();
    public static Team spectators;
    public int score = 0;
    public int teamColour = 0xFFFFFF;
    public char textColour = (char)102;
    public ItemStack hat;
    public ItemStack chest;
    public ItemStack legs;
    public ItemStack shoes;

    public Team(String s, String s1, int teamCol, char textCol) {
        super(new TypeFile(EnumType.team, s, false));
        this.shortName = s;
        this.name = s1;
        this.teamColour = teamCol;
        this.textColour = textCol;
        teams.add(this);
    }

    public Team(TypeFile file) {
        super(file);
        teams.add(this);
    }

    @Override
    protected void read(String[] split, TypeFile file) {
        super.read(split, file);
        try {
            ArmourType armour;
            if (split[0].equals("TeamColour")) {
                this.teamColour = (Integer.parseInt(split[1]) << 16) + (Integer.parseInt(split[2]) << 8) + Integer.parseInt(split[3]);
            }
            if (split[0].equals("TextColour")) {
                if (split[1].equals("Black")) {
                    this.textColour = (char)48;
                }
                if (split[1].equals("Blue")) {
                    this.textColour = (char)49;
                }
                if (split[1].equals("Green")) {
                    this.textColour = (char)50;
                }
                if (split[1].equals("Aqua")) {
                    this.textColour = (char)51;
                }
                if (split[1].equals("Red")) {
                    this.textColour = (char)52;
                }
                if (split[1].equals("Purple")) {
                    this.textColour = (char)53;
                }
                if (split[1].equals("Orange")) {
                    this.textColour = (char)54;
                }
                if (split[1].equals("LGrey")) {
                    this.textColour = (char)55;
                }
                if (split[1].equals("Grey")) {
                    this.textColour = (char)56;
                }
                if (split[1].equals("LBlue")) {
                    this.textColour = (char)57;
                }
                if (split[1].equals("LGreen")) {
                    this.textColour = (char)97;
                }
                if (split[1].equals("LAqua")) {
                    this.textColour = (char)98;
                }
                if (split[1].equals("Red")) {
                    this.textColour = (char)99;
                }
                if (split[1].equals("Pink")) {
                    this.textColour = (char)100;
                }
                if (split[1].equals("Yellow")) {
                    this.textColour = (char)101;
                }
                if (split[1].equals("White")) {
                    this.textColour = (char)102;
                }
            }
            if (split[0].equals("Hat") || split[0].equals("Helmet")) {
                if (split[1].equals("None")) {
                    return;
                }
                for (ItemTeamArmour item : FlansMod.armourItems) {
                    armour = item.type;
                    if (armour == null || !armour.shortName.equals(split[1])) continue;
                    this.hat = new ItemStack((Item)item);
                }
            }
            if (split[0].equals("Chest") || split[0].equals("Top")) {
                if (split[1].equals("None")) {
                    return;
                }
                for (ItemTeamArmour item : FlansMod.armourItems) {
                    armour = item.type;
                    if (armour == null || !armour.shortName.equals(split[1])) continue;
                    this.chest = new ItemStack((Item)item);
                }
            }
            if (split[0].equals("Legs") || split[0].equals("Bottom")) {
                if (split[1].equals("None")) {
                    return;
                }
                for (ItemTeamArmour item : FlansMod.armourItems) {
                    armour = item.type;
                    if (armour == null || !armour.shortName.equals(split[1])) continue;
                    this.legs = new ItemStack((Item)item);
                }
            }
            if (split[0].equals("Shoes") || split[0].equals("Boots")) {
                if (split[1].equals("None")) {
                    return;
                }
                for (ItemTeamArmour item : FlansMod.armourItems) {
                    armour = item.type;
                    if (armour == null || !armour.shortName.equals(split[1])) continue;
                    this.shoes = new ItemStack((Item)item);
                }
            }
            if (split[0].equals("AddDefaultClass") || split[0].equals("AddClass")) {
                this.classes.add(PlayerClass.getClass(split[1]));
            }
        }
        catch (Exception e) {
            System.out.println("Reading team file failed.");
            e.printStackTrace();
        }
    }

    public static Team getTeam(String s) {
        for (Team team : teams) {
            if (!team.shortName.equals(s)) continue;
            return team;
        }
        return null;
    }

    public void addBase(ITeamBase base) {
        this.bases.add(base);
    }

    public void removeBase(ITeamBase base) {
        this.bases.remove(base);
    }

    public void removePlayer(EntityPlayer player) {
        this.removePlayer(player.func_70005_c_());
    }

    public String removePlayer(String username) {
        this.members.remove(username);
        if (PlayerHandler.getPlayerData(username) != null) {
            PlayerHandler.getPlayerData((String)username).team = null;
        }
        return username;
    }

    public EntityPlayer addPlayer(EntityPlayer player) {
        this.addPlayer(player.func_70005_c_());
        return player;
    }

    public String addPlayer(String username) {
        ArrayList<String> list = new ArrayList<String>();
        list.add(username);
        for (Team team : teams) {
            team.members.removeAll(list);
        }
        this.members.add(username);
        PlayerHandler.getPlayerData((String)username).team = this;
        return username;
    }

    public String removeWorstPlayer() {
        this.sortPlayers();
        if (this.members.size() == 0) {
            return null;
        }
        return this.removePlayer(this.members.get(this.members.size() - 1));
    }

    public void sortPlayers() {
        Collections.sort(this.members, new ComparatorScore());
    }

    public static class ComparatorScore
    implements Comparator<String> {
        @Override
        public int compare(String a, String b) {
            PlayerData dataA = PlayerHandler.getPlayerData(a);
            PlayerData dataB = PlayerHandler.getPlayerData(b);
            if (dataA == null || dataB == null) {
                return 0;
            }
            return dataB.score - dataA.score;
        }
    }
}

