/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.common.teams;

import com.flansmod.common.PlayerData;
import com.flansmod.common.teams.EntityFlag;
import com.flansmod.common.teams.Gametype;
import com.flansmod.common.teams.ITeamBase;
import com.flansmod.common.teams.ITeamObject;
import com.flansmod.common.teams.PlayerClass;
import com.flansmod.common.teams.Team;
import com.flansmod.common.teams.TeamsManager;
import java.util.ArrayList;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.Vec3;

public class GametypeCTF
extends Gametype {
    public boolean friendlyFire = false;
    public boolean autoBalance = true;
    public int scoreLimit = 5;
    public int newRoundTimer = 0;
    public int time;
    public int autoBalanceInterval = 1200;

    public GametypeCTF() {
        super("Capture the Flag", "CTF", 2);
    }

    @Override
    public void initGametype() {
        this.startNewRound();
    }

    @Override
    public void teamsSet() {
        this.startNewRound();
    }

    @Override
    public void stopGametype() {
        super.stopGametype();
        GametypeCTF.resetScores();
    }

    @Override
    public void tick() {
        --this.newRoundTimer;
        if (this.newRoundTimer == 0) {
            if (TeamsManager.useRotation) {
                TeamsManager.getInstance().switchToNextGametype();
                return;
            }
            this.startNewRound();
        }
        if (GametypeCTF.teamsManager.teams != null) {
            for (Team team : GametypeCTF.teamsManager.teams) {
                if (team == null || team.score < this.scoreLimit || this.newRoundTimer >= 0) continue;
                TeamsManager.messageAll("\u00a7" + team.textColour + team.name + "\u00a7f won!");
                this.newRoundTimer = 200;
                TeamsManager.messageAll("\u00a7fThe next round will start in 10 seconds");
                this.time = -300;
            }
        }
        ++this.time;
        if (this.autoBalance && this.time % this.autoBalanceInterval == this.autoBalanceInterval - 200 && this.needAutobalance()) {
            TeamsManager.messageAll("\u00a7fAutobalancing teams...");
        }
        if (this.autoBalance && this.time % this.autoBalanceInterval == 0 && this.needAutobalance()) {
            this.autobalance();
        }
    }

    public boolean needAutobalance() {
        int membersTeamB;
        if (GametypeCTF.teamsManager.teams == null || GametypeCTF.teamsManager.teams[0] == null || GametypeCTF.teamsManager.teams[1] == null) {
            return false;
        }
        int membersTeamA = GametypeCTF.teamsManager.teams[0].members.size();
        return Math.abs(membersTeamA - (membersTeamB = GametypeCTF.teamsManager.teams[1].members.size())) > 1;
    }

    public void autobalance() {
        int i;
        int membersTeamB;
        if (GametypeCTF.teamsManager.teams == null || GametypeCTF.teamsManager.teams[0] == null || GametypeCTF.teamsManager.teams[1] == null) {
            return;
        }
        int membersTeamA = GametypeCTF.teamsManager.teams[0].members.size();
        if (membersTeamA - (membersTeamB = GametypeCTF.teamsManager.teams[1].members.size()) > 1) {
            for (i = 0; i < (membersTeamA - membersTeamB) / 2; ++i) {
                GametypeCTF.sendClassMenuToPlayer(this.getPlayer(GametypeCTF.teamsManager.teams[1].addPlayer(GametypeCTF.teamsManager.teams[0].removeWorstPlayer())));
            }
        }
        if (membersTeamB - membersTeamA > 1) {
            for (i = 0; i < (membersTeamB - membersTeamA) / 2; ++i) {
                GametypeCTF.sendClassMenuToPlayer(this.getPlayer(GametypeCTF.teamsManager.teams[0].addPlayer(GametypeCTF.teamsManager.teams[1].removeWorstPlayer())));
            }
        }
    }

    @Override
    public void playerJoined(EntityPlayerMP player) {
        GametypeCTF.sendTeamsMenuToPlayer(player);
    }

    @Override
    public boolean playerChoseTeam(EntityPlayerMP player, Team team, Team previousTeam) {
        int membersOnBothTeams;
        int membersOnTeamTheyDontWantToJoin;
        int membersOnTeamTheyWantToJoin;
        if (GametypeCTF.teamsManager.teams == null || GametypeCTF.teamsManager.teams[0] == null || GametypeCTF.teamsManager.teams[1] == null) {
            return false;
        }
        if (this.autoBalance && (membersOnTeamTheyWantToJoin = team.members.size()) > (membersOnTeamTheyDontWantToJoin = (membersOnBothTeams = GametypeCTF.teamsManager.teams[0].members.size() + GametypeCTF.teamsManager.teams[1].members.size()) - membersOnTeamTheyWantToJoin)) {
            return false;
        }
        if (previousTeam != null && previousTeam != Team.spectators && previousTeam != team && GametypeCTF.isAValidTeam(previousTeam, true)) {
            ++GametypeCTF.getPlayerData((EntityPlayerMP)player).deaths;
            --GametypeCTF.getPlayerData((EntityPlayerMP)player).score;
            GametypeCTF.getPlayerData((EntityPlayerMP)player).playerClass = null;
            GametypeCTF.getPlayerData((EntityPlayerMP)player).newPlayerClass = null;
        }
        GametypeCTF.sendClassMenuToPlayer(player);
        if (team != previousTeam) {
            teamsManager.forceRespawn(player);
        }
        return true;
    }

    @Override
    public boolean playerChoseClass(EntityPlayerMP player, PlayerClass playerClass) {
        Team team = GametypeCTF.getPlayerData((EntityPlayerMP)player).team;
        if (!team.classes.contains(playerClass)) {
            return false;
        }
        GametypeCTF.getPlayerData((EntityPlayerMP)player).newPlayerClass = playerClass;
        if (GametypeCTF.getPlayerData((EntityPlayerMP)player).playerClass == null) {
            teamsManager.resetInventory((EntityPlayer)player);
        } else {
            player.func_145747_a((IChatComponent)new ChatComponentText("You will respawn with the " + playerClass.name.toLowerCase() + " class"));
        }
        return true;
    }

    @Override
    public void playerQuit(EntityPlayerMP player) {
    }

    @Override
    public boolean playerAttacked(EntityPlayerMP player, DamageSource source) {
        if (GametypeCTF.getPlayerData(player) == null || GametypeCTF.getPlayerData((EntityPlayerMP)player).team == null) {
            return false;
        }
        if (this.newRoundTimer > 0) {
            return false;
        }
        EntityPlayerMP attacker = GametypeCTF.getPlayerFromDamageSource(source);
        if (attacker != null) {
            if (GametypeCTF.getPlayerData(attacker) == null || GametypeCTF.getPlayerData((EntityPlayerMP)attacker).team == null) {
                return false;
            }
            if (GametypeCTF.getPlayerData((EntityPlayerMP)attacker).team == Team.spectators) {
                return false;
            }
            if (GametypeCTF.getPlayerData((EntityPlayerMP)player).team == GametypeCTF.getPlayerData((EntityPlayerMP)attacker).team) {
                return this.friendlyFire;
            }
        }
        return GametypeCTF.getPlayerData((EntityPlayerMP)player).team != Team.spectators;
    }

    @Override
    public void playerKilled(EntityPlayerMP player, DamageSource source) {
        EntityPlayerMP attacker = GametypeCTF.getPlayerFromDamageSource(source);
        if (attacker != null) {
            if (attacker == player) {
                --GametypeCTF.getPlayerData((EntityPlayerMP)player).score;
            } else {
                ++GametypeCTF.getPlayerData((EntityPlayerMP)attacker).score;
                ++GametypeCTF.getPlayerData((EntityPlayerMP)attacker).kills;
            }
        } else {
            --GametypeCTF.getPlayerData((EntityPlayerMP)player).score;
        }
        ++GametypeCTF.getPlayerData((EntityPlayerMP)player).deaths;
        for (Team team : GametypeCTF.teamsManager.teams) {
            for (ITeamBase base : team.bases) {
                ITeamObject obj = base.getFlag();
            }
        }
    }

    @Override
    public void baseAttacked(ITeamBase base, DamageSource source) {
    }

    @Override
    public void objectAttacked(ITeamObject object, DamageSource source) {
    }

    @Override
    public void baseClickedByPlayer(ITeamBase base, EntityPlayerMP player) {
    }

    @Override
    public void objectClickedByPlayer(ITeamObject object, EntityPlayerMP player) {
        Team team;
        EntityFlag flag;
        if (object instanceof EntityFlag && (flag = (EntityFlag)object).getBase().getOwner() != null && flag.getBase().getOwner() != Team.spectators && (team = GametypeCTF.getPlayerData((EntityPlayerMP)player).team) != null && team != Team.spectators) {
            if (team == flag.getBase().getOwner()) {
                EntityFlag otherFlag;
                if (flag.field_70154_o == null && !flag.isHome) {
                    flag.reset();
                    TeamsManager.messageAll("\u00a7f" + player.func_70005_c_() + " returned the \u00a7" + flag.getBase().getOwner().textColour + flag.getBase().getOwner().name + "\u00a7f flag");
                } else if (player.field_70153_n instanceof EntityFlag && (otherFlag = (EntityFlag)player.field_70153_n).getBase().getOwner() != null && otherFlag.getBase().getOwner() != team && otherFlag.getBase().getOwner() != Team.spectators && flag.isHome && this.newRoundTimer <= 0) {
                    ++team.score;
                    otherFlag.reset();
                    TeamsManager.messageAll("\u00a7f" + player.func_70005_c_() + " captured the \u00a7" + otherFlag.getBase().getOwner().textColour + otherFlag.getBase().getOwner().name + "\u00a7f flag");
                }
            } else if (flag.field_70154_o == player) {
                flag.func_70078_a(null);
                TeamsManager.messageAll("\u00a7f" + player.func_70005_c_() + " dropped the \u00a7" + flag.getBase().getOwner().textColour + flag.getBase().getOwner().name + "\u00a7f flag");
            } else if (flag.field_70154_o == null) {
                flag.func_70078_a((Entity)player);
                TeamsManager.messageAll("\u00a7f" + player.func_70005_c_() + " picked up the \u00a7" + flag.getBase().getOwner().textColour + flag.getBase().getOwner().name + "\u00a7f flag");
                flag.isHome = false;
            }
        }
    }

    @Override
    public Vec3 getSpawnPoint(EntityPlayerMP player) {
        PlayerData data = GametypeCTF.getPlayerData(player);
        ArrayList<ITeamObject> validSpawnPoints = new ArrayList<ITeamObject>();
        if (data.team == null) {
            return null;
        }
        for (int j = 0; j < data.team.bases.size(); ++j) {
            ITeamBase base = data.team.bases.get(j);
            if (base.getMap() != GametypeCTF.teamsManager.currentMap) continue;
            for (int i = 0; i < base.getObjects().size(); ++i) {
                if (!base.getObjects().get(i).isSpawnPoint()) continue;
                validSpawnPoints.add(base.getObjects().get(i));
            }
        }
        if (validSpawnPoints.size() > 0) {
            ITeamObject spawnPoint = (ITeamObject)validSpawnPoints.get(rand.nextInt(validSpawnPoints.size()));
            return Vec3.func_72443_a((double)spawnPoint.getPosX(), (double)spawnPoint.getPosY(), (double)spawnPoint.getPosZ());
        }
        return null;
    }

    @Override
    public void playerRespawned(EntityPlayerMP player) {
    }

    @Override
    public boolean setVariable(String variable, String value) {
        if (variable.toLowerCase().equals("scorelimit")) {
            this.scoreLimit = Integer.parseInt(value);
            return true;
        }
        if (variable.toLowerCase().equals("friendlyfire")) {
            this.friendlyFire = Boolean.parseBoolean(value);
            return true;
        }
        if (variable.toLowerCase().equals("autobalance")) {
            this.autoBalance = Boolean.parseBoolean(value);
            return true;
        }
        return false;
    }

    @Override
    public void readFromNBT(NBTTagCompound tags) {
        this.scoreLimit = tags.func_74762_e("CTFScoreLimit");
        this.friendlyFire = tags.func_74767_n("CTFFriendlyFire");
        this.autoBalance = tags.func_74767_n("CTFAutoBalance");
    }

    @Override
    public void saveToNBT(NBTTagCompound tags) {
        tags.func_74768_a("CTFScoreLimit", this.scoreLimit);
        tags.func_74757_a("CTFFriendlyFire", this.friendlyFire);
        tags.func_74757_a("CTFAutoBalance", this.autoBalance);
    }

    @Override
    public boolean sortScoreboardByTeam() {
        return true;
    }
}

