/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.common.driveables;

import com.flansmod.common.driveables.CollisionBox;
import com.flansmod.common.driveables.EntityDriveable;
import com.flansmod.common.driveables.EnumDriveablePart;
import com.flansmod.common.guns.EntityBullet;
import com.flansmod.common.vector.Vector3f;
import net.minecraft.nbt.NBTTagCompound;

public class DriveablePart {
    public EnumDriveablePart type;
    public CollisionBox box;
    public int maxHealth;
    public int health;
    public boolean onFire;
    public boolean dead;

    public DriveablePart(EnumDriveablePart e, CollisionBox b) {
        this.type = e;
        this.box = b;
        this.maxHealth = b == null ? 0 : b.health;
        this.health = this.maxHealth;
    }

    public void update(EntityDriveable driveable) {
        if (this.onFire) {
            --this.health;
        }
        if (this.health <= 0 && this.maxHealth > 0) {
            this.dead = true;
        }
    }

    public void writeToNBT(NBTTagCompound tags) {
        tags.func_74768_a(this.type.getShortName() + "_Health", this.health);
        tags.func_74757_a(this.type.getShortName() + "_Fire", this.onFire);
    }

    public void readFromNBT(NBTTagCompound tags) {
        if (!tags.func_74764_b(this.type.getShortName() + "_Health")) {
            this.health = this.maxHealth;
            this.onFire = false;
            return;
        }
        this.health = tags.func_74762_e(this.type.getShortName() + "_Health");
        this.onFire = tags.func_74767_n(this.type.getShortName() + "_Fire");
    }

    public float smashIntoGround(EntityDriveable driveable, float damage) {
        if (this.box == null || this.dead) {
            return 0.0f;
        }
        if (!driveable.canHitPart(this.type)) {
            return 0.0f;
        }
        if (this.maxHealth == 0) {
            return damage;
        }
        this.health -= (int)(damage / 2.0f);
        return damage / 2.0f;
    }

    public boolean rayTrace(EntityDriveable driveable, EntityBullet bullet, Vector3f origin, Vector3f motion) {
        boolean hit;
        if (this.box == null || this.health <= 0 || this.dead) {
            return false;
        }
        if (!driveable.canHitPart(this.type)) {
            return false;
        }
        boolean enteringX = this.coordIsEntering(origin.x, origin.x + motion.x, (float)this.box.x / 16.0f, (float)(this.box.x + this.box.w) / 16.0f);
        boolean enteringY = this.coordIsEntering(origin.y, origin.y + motion.y, (float)this.box.y / 16.0f, (float)(this.box.y + this.box.h) / 16.0f);
        boolean enteringZ = this.coordIsEntering(origin.z, origin.z + motion.z, (float)this.box.z / 16.0f, (float)(this.box.z + this.box.d) / 16.0f);
        boolean inX = this.coordIsIn(origin.x, origin.x + motion.x, (float)this.box.x / 16.0f, (float)(this.box.x + this.box.w) / 16.0f);
        boolean inY = this.coordIsIn(origin.y, origin.y + motion.y, (float)this.box.y / 16.0f, (float)(this.box.y + this.box.h) / 16.0f);
        boolean inZ = this.coordIsIn(origin.z, origin.z + motion.z, (float)this.box.z / 16.0f, (float)(this.box.z + this.box.d) / 16.0f);
        boolean bl = hit = enteringX && inY && inZ || inX && enteringY && inZ || inX && inY && enteringZ;
        if (bullet != null && hit) {
            this.health = (int)((float)this.health - bullet.damage * (float)bullet.type.damageVsDriveable);
            if (bullet.type.fire > 0) {
                this.onFire = true;
            }
        }
        return hit;
    }

    private boolean coordIsEntering(float start, float end, float min, float max) {
        if (start < min && end >= min) {
            return true;
        }
        return start > max && end <= max;
    }

    private boolean coordIsIn(float start, float end, float min, float max) {
        if (start >= min && start <= max) {
            return true;
        }
        if (end >= min && end <= max) {
            return true;
        }
        if (start < min && end > max) {
            return true;
        }
        return end < min && start > max;
    }

    public void attack(float damage, boolean fireDamage) {
        this.health = (int)((float)this.health - damage);
        if (fireDamage) {
            this.onFire = true;
        }
    }
}

