/*
 * Decompiled with CFR 0.152.
 */
package grim3212.mc.fireplaces;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import grim3212.mc.core.Grim3212Core;
import grim3212.mc.fireplaces.FireplaceCore;
import grim3212.mc.fireplaces.FireplaceCoreClient;
import grim3212.mc.fireplaces.TileEntityFireplace;
import grim3212.mc.fireplaces.TileEntityFireplaceBase;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockFireplaceBase
extends BlockContainer {
    public boolean isBase;
    public boolean dropNormal = true;

    protected BlockFireplaceBase(boolean isBase, boolean dropNormal) {
        super(Material.field_151576_e);
        if (isBase) {
            this.func_149647_a(Grim3212Core.tabsGrimBlocks);
        }
        this.isBase = isBase;
        this.dropNormal = dropNormal;
    }

    public TileEntity func_149915_a(World par1World, int var2) {
        return new TileEntityFireplace();
    }

    public boolean func_149686_d() {
        return false;
    }

    public int func_149745_a(Random par1Random) {
        return 0;
    }

    public boolean func_149662_c() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_149646_a(IBlockAccess par1IBlockAccess, int par2, int par3, int par4, int par5) {
        return true;
    }

    public IIcon func_149673_e(IBlockAccess world, int x, int y, int z, int side) {
        TileEntityFireplaceBase tileentity = (TileEntityFireplaceBase)world.func_147438_o(x, y, z);
        int MaterialIndex = tileentity.GetMaterialIndex();
        if (MaterialIndex > FireplaceCore.BlockTypes.length) {
            MaterialIndex = 0;
        }
        if (FireplaceCore.BlockTypes[MaterialIndex] == Blocks.field_150322_A) {
            return Blocks.field_150322_A.func_149673_e(world, x, y, z, side);
        }
        if (FireplaceCore.BlockTypes[MaterialIndex] == Blocks.field_150417_aV) {
            return FireplaceCore.BlockTypes[MaterialIndex].func_149691_a(side, MaterialIndex - 9);
        }
        return FireplaceCore.BlockTypes[MaterialIndex].func_149733_h(side);
    }

    public float getExplosionResistance(Entity entity, World world, int x, int y, int z, double explosionX, double explosionY, double explosionZ) {
        try {
            TileEntityFireplaceBase tileentity = (TileEntityFireplaceBase)world.func_147438_o(x, y, z);
            int MaterialIndex = tileentity.GetMaterialIndex();
            if (MaterialIndex > FireplaceCore.BlockTypes.length) {
                MaterialIndex = 0;
            }
            return FireplaceCore.BlockTypes[MaterialIndex].getExplosionResistance(entity, world, x, y, z, explosionX, explosionY, explosionZ);
        }
        catch (Exception e) {
            return 0.0f;
        }
    }

    public float func_149712_f(World world, int x, int y, int z) {
        try {
            TileEntityFireplaceBase tileentity = (TileEntityFireplaceBase)world.func_147438_o(x, y, z);
            int MaterialIndex = tileentity.GetMaterialIndex();
            if (MaterialIndex > FireplaceCore.BlockTypes.length) {
                MaterialIndex = 0;
            }
            return FireplaceCore.BlockTypes[MaterialIndex].func_149712_f(world, x, y, z);
        }
        catch (Exception e) {
            return 0.0f;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int MaterialIndex) {
        if (MaterialIndex > FireplaceCore.BlockTypes.length) {
            MaterialIndex = 0;
        }
        if (FireplaceCore.BlockTypes[MaterialIndex] == Blocks.field_150322_A) {
            return Blocks.field_150322_A.func_149691_a(side, MaterialIndex);
        }
        if (FireplaceCore.BlockTypes[MaterialIndex] == Blocks.field_150417_aV) {
            return FireplaceCore.BlockTypes[MaterialIndex].func_149691_a(side, MaterialIndex - 9);
        }
        return FireplaceCore.BlockTypes[MaterialIndex].func_149733_h(side);
    }

    public ItemStack getPickBlock(MovingObjectPosition target, World world, int x, int y, int z) {
        return new ItemStack((Block)this);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item par1, CreativeTabs par2CreativeTabs, List par3List) {
        for (int i = 0; i < FireplaceCore.BlockTypes.length; ++i) {
            if (!FireplaceCore.EnabledMaterials[i]) continue;
            par3List.add(new ItemStack(par1, 1, i));
        }
    }

    public void func_149699_a(World world, int x, int y, int z, EntityPlayer player) {
        TileEntityFireplaceBase tileentity = (TileEntityFireplaceBase)world.func_147438_o(x, y, z);
        if (tileentity.GetIsLit()) {
            BlockFireplaceBase.produceSmoke(world, x, y, z, 0.5, 0.3, 0.5, 3, true);
            world.func_72908_a((double)x + 0.5, (double)y + 0.5, (double)z + 0.5, "random.fizz", 1.0f, world.field_73012_v.nextFloat() * 0.4f + 0.8f);
            tileentity.keepValid = true;
            world.func_147465_d(x, y, z, FireplaceCore.TransitionMap.get((Object)this), 0, 3);
            tileentity.func_145829_t();
            world.func_147455_a(x, y, z, (TileEntity)tileentity);
            tileentity.keepValid = false;
        }
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int par6, float par7, float par8, float par9) {
        TileEntityFireplaceBase tileentity = (TileEntityFireplaceBase)world.func_147438_o(x, y, z);
        ItemStack hand = player.field_71071_by.func_70301_a(player.field_71071_by.field_70461_c);
        if (hand != null && (hand.func_77973_b() == Items.field_151033_d || hand.func_77973_b() == Items.field_151059_bz)) {
            if (!tileentity.GetIsLit()) {
                hand.func_77972_a(1, (EntityLivingBase)player);
                world.func_72908_a((double)x + 0.5, (double)y + 0.5, (double)z + 0.5, "fire.ignite", 1.0f, world.field_73012_v.nextFloat() * 0.4f + 0.8f);
                tileentity.keepValid = true;
                world.func_147465_d(x, y, z, FireplaceCore.TransitionMap.get((Object)this), 0, 3);
                tileentity.func_145829_t();
                world.func_147455_a(x, y, z, (TileEntity)tileentity);
                tileentity.keepValid = false;
            }
            return true;
        }
        return false;
    }

    public static void produceSmoke(World world, int x, int y, int z, double xMod, double yMod, double zMod, int amount, boolean makelarge) {
        for (int i = 0; i < amount; ++i) {
            double xVar = (world.field_73012_v.nextDouble() - 0.5) / 5.0;
            double yVar = (world.field_73012_v.nextDouble() - 0.5) / 5.0;
            double zVar = (world.field_73012_v.nextDouble() - 0.5) / 5.0;
            world.func_72869_a((makelarge ? "large" : "") + "smoke", (double)x + xMod + xVar, (double)y + yMod + yVar, (double)z + zMod + zVar, 0.0, 0.0, 0.0);
        }
    }

    public void func_149749_a(World worldObj, int xCoord, int yCoord, int zCoord, Block par5, int par6) {
        if (!this.dropNormal) {
            super.func_149749_a(worldObj, xCoord, yCoord, zCoord, par5, par6);
            return;
        }
        TileEntityFireplaceBase tileentity = (TileEntityFireplaceBase)worldObj.func_147438_o(xCoord, yCoord, zCoord);
        if (tileentity != null && !tileentity.keepValid && FMLCommonHandler.instance().getEffectiveSide() == Side.SERVER) {
            ItemStack itemstack = this.isBase ? new ItemStack((Block)this, 1, tileentity.MaterialIndex) : new ItemStack(FireplaceCore.TransitionMap.get((Object)this), 1, tileentity.MaterialIndex);
            this.func_149642_a(worldObj, xCoord, yCoord, zCoord, itemstack);
        }
        super.func_149749_a(worldObj, xCoord, yCoord, zCoord, par5, par6);
    }

    public void func_149651_a(IIconRegister par1IconRegister) {
        FireplaceCoreClient.Tex_chimney2 = par1IconRegister.func_94245_a("grim3212fireplaces:chimney2");
        FireplaceCoreClient.Tex_chimney3 = par1IconRegister.func_94245_a("grim3212fireplaces:chimney3");
        FireplaceCoreClient.Tex_chimney4 = par1IconRegister.func_94245_a("grim3212fireplaces:chimney4");
        FireplaceCoreClient.Tex_chimney5 = par1IconRegister.func_94245_a("grim3212fireplaces:chimney5");
        FireplaceCoreClient.Tex_chimney6 = par1IconRegister.func_94245_a("grim3212fireplaces:chimney6");
        FireplaceCoreClient.Tex_chimney7 = par1IconRegister.func_94245_a("grim3212fireplaces:chimney7");
        FireplaceCoreClient.Tex_chimney8 = par1IconRegister.func_94245_a("grim3212fireplaces:chimney8");
        FireplaceCoreClient.Tex_chimney9 = par1IconRegister.func_94245_a("grim3212fireplaces:chimney9");
        FireplaceCoreClient.Tex_chimney10 = par1IconRegister.func_94245_a("grim3212fireplaces:chimney10");
        FireplaceCoreClient.Tex_chimney18 = par1IconRegister.func_94245_a("grim3212fireplaces:chimney18");
        FireplaceCoreClient.Tex_chimneyInv = par1IconRegister.func_94245_a("grim3212fireplaces:chimneyInv");
        FireplaceCoreClient.Tex_fireplacecoal = par1IconRegister.func_94245_a("grim3212fireplaces:fireplacecoal");
        FireplaceCoreClient.Tex_fireplacenet = par1IconRegister.func_94245_a("grim3212fireplaces:fireplacenet");
    }
}

