/*
 * Decompiled with CFR 0.152.
 */
package net.ipixeli.gender.client;

import cpw.mods.fml.client.registry.ClientRegistry;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.InputEvent;
import cpw.mods.fml.common.network.internal.FMLProxyPacket;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.Random;
import net.ipixeli.gender.client.GuiGenderList;
import net.ipixeli.gender.client.ManagerPlayerClient;
import net.ipixeli.gender.client.ManagerTempObject;
import net.ipixeli.gender.client.ModelZombieGender;
import net.ipixeli.gender.client.ObjectPlayerClient;
import net.ipixeli.gender.client.ObjectPlayerTemp;
import net.ipixeli.gender.client.PlayerSound;
import net.ipixeli.gender.client.RenderPlayerGender;
import net.ipixeli.gender.client.RenderZombieGender;
import net.ipixeli.gender.client.Settings;
import net.ipixeli.gender.common.Gender;
import net.ipixeli.gender.common.GenderCommon;
import net.ipixeli.gender.common.SpecialFew;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.Entity;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.entity.PlaySoundAtEntityEvent;
import org.lwjgl.input.Keyboard;

public class GenderClient
extends GenderCommon {
    protected static final ResourceLocation texFemale = new ResourceLocation("gender", "texture/charfemale.png");
    protected static final ResourceLocation texFemaleC = new ResourceLocation("gender", "texture/charfemalechild.png");
    protected static final ResourceLocation texMale = new ResourceLocation("gender", "texture/char.png");
    protected static final ResourceLocation texMaleC = new ResourceLocation("gender", "texture/charmalechild.png");
    protected static final ResourceLocation texFemaleZ = new ResourceLocation("gender", "texture/zombiefemale.png");
    protected static final ResourceLocation texFemaleZC = new ResourceLocation("gender", "texture/zombiefemalechild.png");
    protected static final ResourceLocation texMaleZ = new ResourceLocation("gender", "texture/zombiemale.png");
    protected static final ResourceLocation texMaleZC = new ResourceLocation("gender", "texture/zombiemalechild.png");
    protected static final ResourceLocation hurtMale = new ResourceLocation("gender", "hurtM");
    protected static final ResourceLocation hurtFemale = new ResourceLocation("gender", "hurtF");
    Random rand = new Random();
    public static GenderClient instance;
    protected static final boolean useObf = true;
    protected static final String mbm = "f";
    protected static final String zbm = "r";
    public static Settings config;
    private static Minecraft mc;
    private final KeyBinding keyMenu = new KeyBinding("Gender", 34, "Gender");
    protected static ObjectPlayerClient me;

    @Override
    public void preInit(FMLPreInitializationEvent event) {
        instance = this;
        mc = Minecraft.func_71410_x();
        config = new Settings(Gender.instance.getDir(), "Gender.cfg");
        config.loadList();
        new ManagerPlayerClient();
        ManagerPlayerClient.instance.loadClientList();
        SpecialFew.hardCodeClientObjectsOnce();
        if (me == null) {
            ManagerPlayerClient.instance.getOrCreate(GenderClient.clientUsername());
        }
    }

    @Override
    public void postInit() {
        ClientRegistry.registerKeyBinding((KeyBinding)this.keyMenu);
        FMLCommonHandler.instance().bus().register((Object)this);
    }

    @SubscribeEvent
    public void onKey(InputEvent.KeyInputEvent event) {
        if (GenderClient.mc.field_71462_r != null) {
            return;
        }
        if (Keyboard.isKeyDown((int)this.keyMenu.func_151463_i())) {
            mc.func_147108_a((GuiScreen)new GuiGenderList(this));
        }
    }

    protected static void sendChannel(String message) {
        byte[] b = message.getBytes();
        byte[] b2 = GenderClient.mc.field_71439_g.getDisplayName().getBytes();
        ByteBuf payload = Unpooled.buffer();
        payload.writeInt(b2.length);
        payload.writeBytes(b2);
        payload.writeInt(b.length);
        payload.writeBytes(b);
        FMLProxyPacket packet = new FMLProxyPacket(payload, "Gender");
        Gender.packetHandler.sendToServer(packet);
        if (Gender.modedebug) {
            System.out.println(Gender.prefix + "Packet sent: " + message);
        }
    }

    public static void onJoinSendMessage() {
        System.out.println(Gender.prefix + "Preparing Renders...");
        RenderManager.field_78727_a.field_78729_o.put(EntityPlayer.class, new RenderPlayerGender());
        RenderManager.field_78727_a.field_78729_o.put(EntityZombie.class, new RenderZombieGender(new ModelZombieGender(), 0.5f));
        Render rpo = RenderManager.field_78727_a.func_78713_a((Entity)GenderClient.mc.field_71439_g);
        System.out.println(Gender.prefix + "Player Renders Registered " + (rpo != null && rpo instanceof RenderPlayerGender ? "Properly" : "Improperly") + "!");
        ManagerTempObject.clear();
        GenderClient.sendGenderInfoPacket();
    }

    @Override
    public void onHurt(EntityPlayer entity) {
        if (GenderClient.config.enablePlayerGenderSounds) {
            ObjectPlayerTemp tmp = ManagerTempObject.getObjectTmp(entity.getDisplayName());
            boolean tmpFemale = tmp != null && tmp.isFemale();
            ResourceLocation sound = ManagerPlayerClient.instance.hasEntry(entity.getDisplayName()) && ManagerPlayerClient.instance.isClientFemale(entity.getDisplayName()) || tmpFemale ? hurtFemale : hurtMale;
            float volume = 1.0f;
            boolean tmpChild = tmp != null && tmp.isChild();
            float pitch = (this.rand.nextFloat() - this.rand.nextFloat()) * 0.2f + 1.0f + (ManagerPlayerClient.instance.hasEntry(entity.getDisplayName()) && ManagerPlayerClient.instance.isClientChild(entity.getDisplayName()) || tmpChild ? 0.3f : 0.0f);
            Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)new PlayerSound(sound, volume, pitch, entity));
        }
    }

    public static boolean preventDouble(PlaySoundAtEntityEvent e) {
        boolean isSP = Minecraft.func_71410_x().func_71356_B();
        boolean hasMPEntity = e.entity instanceof EntityPlayerMP;
        return isSP && !hasMPEntity || !isSP && !hasMPEntity;
    }

    public static void sendGenderInfoPacket() {
        GenderClient.sendChannel((me.isClientFemale() ? "F" : "M") + ":" + (me.isClientChild() ? "C" : "A"));
    }

    public static String clientUsername() {
        return mc.func_110432_I().func_111285_a();
    }

    public ObjectPlayerClient me() {
        return me;
    }

    protected static String stringGender() {
        return me.isClientFemale() ? "Female" : "Male";
    }

    protected static String stringAge() {
        return me.isClientChild() ? "Child" : "Adult";
    }

    public boolean isZombieFemale(double entityId) {
        if (!(entityId > 0.0) && !GenderClient.config.enableZombieGenders) {
            return false;
        }
        double divdou = entityId / 8.0;
        double ieee = Math.IEEEremainder(entityId, 8.0);
        return divdou > 0.0 && ieee > 2.0;
    }
}

