/*
 * Decompiled with CFR 0.152.
 */
package fr.elias.fakeores.client;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelRenderer;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.opengl.GL11;

public class ModelCubeWorld
extends ModelBase {
    byte[][][][] modelData;
    int[] pointers;
    final ModelRenderer cube = new ModelRenderer((ModelBase)this, 0, 0).func_78789_a(0.0f, 0.0f, 0.0f, 1, 1, 1);

    public ModelCubeWorld(InputStream stream) {
        int it = 0;
        int area = 0;
        byte[] sizesBuffer = new byte[12];
        try {
            int i;
            while ((i = stream.read()) != -1) {
                byte val = (byte)(i & 0xFF);
                if (it < 12) {
                    sizesBuffer[it] = val;
                } else {
                    int z;
                    if (it == 12) {
                        int x = sizesBuffer[0] | sizesBuffer[1] << 8 | sizesBuffer[2] << 16 | sizesBuffer[3] << 24;
                        int y = sizesBuffer[4] | sizesBuffer[5] << 8 | sizesBuffer[6] << 16 | sizesBuffer[7] << 24;
                        z = sizesBuffer[8] | sizesBuffer[9] << 8 | sizesBuffer[10] << 16 | sizesBuffer[11] << 24;
                        this.modelData = new byte[x][y][z][3];
                        area = x * y;
                        sizesBuffer = null;
                    }
                    int it1 = it - 12;
                    int it1d = it1 / 3;
                    z = it1d / area;
                    int it2d = it1d - area * z;
                    int x = it2d % this.modelData.length;
                    int y = it2d / this.modelData.length;
                    if (x >= this.modelData.length || y >= this.modelData[0].length || z >= this.modelData[0][0].length) {
                        ++it;
                        continue;
                    }
                    this.modelData[x][y][z][it1 % 3] = val;
                }
                ++it;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.calculatePointers(false);
    }

    public byte[][][][] getModelData() {
        return this.modelData;
    }

    public void calculatePointers(boolean renderHidden) {
        ArrayList<Integer> newPointers = new ArrayList<Integer>();
        for (int x = 0; x < this.modelData.length; ++x) {
            for (int y = 0; y < this.modelData[0].length; ++y) {
                for (int z = 0; z < this.modelData[0][0].length; ++z) {
                    if (!this.cubeExists(x, y, z)) continue;
                    if (!renderHidden) {
                        int hiddenSides = 0;
                        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
                            if (!this.cubeExists(x + dir.offsetX, y + dir.offsetY, z + dir.offsetZ)) continue;
                            ++hiddenSides;
                        }
                        if (hiddenSides == 6) continue;
                    }
                    newPointers.add(x & 0x3FF | (y & 0x3FF) << 10 | (z & 0x3FF) << 20);
                }
            }
        }
        this.pointers = new int[newPointers.size()];
        int it = 0;
        Iterator i$ = newPointers.iterator();
        while (i$.hasNext()) {
            int i;
            this.pointers[it] = i = ((Integer)i$.next()).intValue();
            ++it;
        }
    }

    public boolean cubeExists(int x, int y, int z) {
        int xs = this.modelData.length;
        int ys = this.modelData[0].length;
        int zs = this.modelData[0][0].length;
        if (x >= xs || x < 0 || y >= ys || y < 0 || z >= zs || z < 0) {
            return false;
        }
        byte[] values = this.modelData[x][y][z];
        return values[0] != 0 || values[1] != 0 || values[2] != 0;
    }

    public void render() {
        GL11.glPushMatrix();
        GL11.glDisable((int)3553);
        GL11.glEnable((int)32826);
        float scale = 0.0625f;
        GL11.glScalef((float)0.0625f, (float)0.0625f, (float)0.0625f);
        GL11.glRotatef((float)-90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        for (int i : this.pointers) {
            int x = i & 0x3FF;
            int y = i >> 10 & 0x3FF;
            int z = i >> 20 & 0x3FF;
            GL11.glTranslatef((float)x, (float)y, (float)z);
            byte[] color = this.modelData[x][y][z];
            GL11.glColor3ub((byte)color[0], (byte)color[1], (byte)color[2]);
            this.cube.func_78785_a(1.0f);
            GL11.glTranslatef((float)(-x), (float)(-y), (float)(-z));
        }
        GL11.glEnable((int)3553);
        GL11.glDisable((int)32826);
        GL11.glPopMatrix();
    }
}

