/*
 * Decompiled with CFR 0.152.
 */
package factorization.sockets;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import factorization.api.Coord;
import factorization.api.FzOrientation;
import factorization.api.Quaternion;
import factorization.api.datahelpers.DataHelper;
import factorization.api.datahelpers.IDataSerializable;
import factorization.api.datahelpers.Share;
import factorization.common.BlockIcons;
import factorization.common.FactoryType;
import factorization.servo.RenderServoMotor;
import factorization.servo.ServoMotor;
import factorization.shared.BlockRenderHelper;
import factorization.shared.Core;
import factorization.shared.FzUtil;
import factorization.sockets.ISocketHolder;
import factorization.sockets.TileEntitySocketBase;
import java.io.IOException;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.Entity;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.opengl.GL11;

public class SocketShifter
extends TileEntitySocketBase {
    public ShifterMode mode = ShifterMode.MODE_PULSE_SOME;
    public int foreignSlot = -1;
    public boolean exporting = true;
    public byte transferLimit = (byte)64;
    byte cooldown = 0;

    @Override
    public FactoryType getFactoryType() {
        return FactoryType.SOCKET_SHIFTER;
    }

    @Override
    public FactoryType getParentFactoryType() {
        return FactoryType.SOCKET_EMPTY;
    }

    @Override
    public ItemStack getCreatingItem() {
        return Core.registry.socket_shifter;
    }

    @Override
    public boolean canUpdate() {
        return true;
    }

    @Override
    public IDataSerializable serialize(String prefix, DataHelper data) throws IOException {
        this.exporting = data.as(Share.MUTABLE, "exp").putBoolean(this.exporting);
        this.mode = data.hasLegacy("strm") ? (data.as(Share.MUTABLE, "strm").putBoolean(true) ? ShifterMode.MODE_STREAM : ShifterMode.MODE_PULSE_EXACT) : data.as(Share.MUTABLE, "mode").putEnum(this.mode);
        this.transferLimit = data.as(Share.MUTABLE, "lim").putByte(this.transferLimit);
        this.foreignSlot = data.as(Share.MUTABLE, "for").putInt(this.foreignSlot);
        this.cooldown = data.as(Share.PRIVATE, "wait").putByte(this.cooldown);
        if (data.isWriter()) {
            return this;
        }
        if (this.mode == ShifterMode.MODE_STREAM && this.transferLimit != 1) {
            this.transferLimit = 1;
            data.log("transfer limit must be 1 in stream mode");
        }
        if (this.foreignSlot < -1) {
            this.foreignSlot = -1;
            data.log("foreign slot was < -1");
        }
        if (this.transferLimit > 64) {
            this.transferLimit = (byte)64;
            data.log("transfer limit was > 64");
        }
        if (this.transferLimit < 1) {
            this.transferLimit = 1;
            data.log("transfer limit was < 1");
        }
        return this;
    }

    @Override
    public void genericUpdate(ISocketHolder socket, Coord coord, boolean powered) {
        boolean had_change;
        FzUtil.FzInv pushInv;
        FzUtil.FzInv pullInv;
        block41: {
            int pushEnd;
            int pushStart;
            int pullEnd;
            int pullStart;
            FzUtil.FzInv localInv;
            if (this.field_145850_b.field_72995_K) {
                return;
            }
            if (this.mode == ShifterMode.MODE_STREAM) {
                if (this.cooldown > 0) {
                    this.cooldown = (byte)(this.cooldown - 1);
                    return;
                }
                if (!powered) {
                    return;
                }
            } else {
                if (!powered && this.cooldown > 0) {
                    this.cooldown = (byte)(this.cooldown - 1);
                    return;
                }
                if (this.cooldown > 0) {
                    return;
                }
                if (!powered) {
                    return;
                }
            }
            ForgeDirection back = this.facing.getOpposite();
            if (socket != this) {
                localInv = FzUtil.openInventory((IInventory)socket, this.facing);
            } else {
                coord.adjust(back);
                localInv = FzUtil.openInventory(coord.getTE(IInventory.class), this.facing);
                coord.adjust(this.facing);
            }
            if (localInv == null) {
                return;
            }
            coord.adjust(this.facing);
            FzUtil.FzInv foreignInv = FzUtil.openInventory(coord.getTE(IInventory.class), back);
            coord.adjust(back);
            if (foreignInv == null) {
                ForgeDirection top = this.facing;
                for (Entity entity : this.getEntities(socket, coord, top, 0)) {
                    if (entity instanceof IInventory && (foreignInv = FzUtil.openInventory(entity, false)) != null) break;
                }
                if (foreignInv == null) {
                    return;
                }
            }
            if (this.foreignSlot >= foreignInv.size()) {
                return;
            }
            if (this.exporting) {
                pullInv = localInv;
                pushInv = foreignInv;
                pullStart = 0;
                pullEnd = localInv.size() - 1;
                if (this.foreignSlot == -1) {
                    pushStart = 0;
                    pushEnd = foreignInv.size() - 1;
                } else {
                    pushStart = pushEnd = this.foreignSlot;
                }
            } else {
                pullInv = foreignInv;
                pushInv = localInv;
                pushStart = 0;
                pushEnd = localInv.size() - 1;
                if (this.foreignSlot == -1) {
                    pullStart = 0;
                    pullEnd = foreignInv.size() - 1;
                } else {
                    pullStart = pullEnd = this.foreignSlot;
                }
            }
            pushInv.setCallOnInventoryChanged(false);
            pullInv.setCallOnInventoryChanged(false);
            had_change = false;
            if (this.mode == ShifterMode.MODE_PULSE_SOME) {
                int toMove = this.transferLimit;
                for (int pull = pullStart; pull <= pullEnd; ++pull) {
                    int delta;
                    int push;
                    int firstEmptySlot = -1;
                    for (push = pushStart; push <= pushEnd; ++push) {
                        if (pushInv.get(push) == null) {
                            if (firstEmptySlot != -1) continue;
                            firstEmptySlot = push;
                            continue;
                        }
                        delta = pullInv.transfer(pull, pushInv, push, toMove);
                        toMove -= delta;
                        if (delta > 0) {
                            had_change = true;
                        }
                        if (toMove > 0) {
                            continue;
                        }
                        break block41;
                    }
                    if (toMove <= 0) break;
                    if (firstEmptySlot == -1) {
                        firstEmptySlot = pushStart;
                    }
                    for (push = firstEmptySlot; push <= pushEnd; ++push) {
                        if (pushInv.get(push) != null) continue;
                        delta = pullInv.transfer(pull, pushInv, push, toMove);
                        toMove -= delta;
                        if (delta > 0) {
                            had_change = true;
                        }
                        if (toMove > 0) {
                            continue;
                        }
                        break block41;
                    }
                    if (!had_change) {
                        continue;
                    }
                    break;
                }
            } else {
                boolean[] visitedSlots = new boolean[pullInv.size()];
                for (int pull = pullStart; pull <= pullEnd; ++pull) {
                    ItemStack is;
                    int freeForIs;
                    if (this.countItem(pullInv, pull, this.transferLimit, visitedSlots) < this.transferLimit || (freeForIs = pushInv.getFreeSpaceFor(is = pullInv.get(pull), this.transferLimit)) < this.transferLimit) continue;
                    had_change = true;
                    int limit = this.transferLimit;
                    block5: for (int i = pull; i <= pullEnd; ++i) {
                        if (!FzUtil.couldMerge(is, pullInv.get(i))) continue;
                        while (limit > 0) {
                            int delta;
                            int push;
                            int origLimit = limit;
                            for (push = pushStart; push <= pushEnd; ++push) {
                                if (pushInv.get(push) == null || (limit -= (delta = pullInv.transfer(i, pushInv, push, limit))) > 0) {
                                    continue;
                                }
                                break block41;
                            }
                            if (limit <= 0) break block41;
                            for (push = pushStart; push <= pushEnd; ++push) {
                                if (pushInv.get(push) != null || (limit -= (delta = pullInv.transfer(i, pushInv, push, limit))) > 0) {
                                    continue;
                                }
                                break block41;
                            }
                            if (limit != origLimit) continue;
                            continue block5;
                        }
                    }
                    break;
                }
            }
        }
        if (had_change) {
            pullInv.setCallOnInventoryChanged(true);
            pushInv.setCallOnInventoryChanged(true);
            pullInv.onInvChanged();
            pushInv.onInvChanged();
        }
        this.cooldown = (byte)(this.mode == ShifterMode.MODE_STREAM ? 8 : 1);
    }

    int countItem(FzUtil.FzInv inv, int start, int minimum, boolean[] visitedSlots) {
        if (visitedSlots[start]) {
            return 0;
        }
        visitedSlots[start] = true;
        ItemStack seed = inv.get(start);
        if (seed == null || seed.field_77994_a == 0) {
            return 0;
        }
        if (!inv.canExtract(start, seed)) {
            return 0;
        }
        int count = seed.field_77994_a;
        if (count >= minimum) {
            return count;
        }
        for (int i = ++start; i < inv.size(); ++i) {
            if (visitedSlots[i]) continue;
            ItemStack is = inv.get(i);
            if (is == null) {
                visitedSlots[i] = true;
                continue;
            }
            if (!FzUtil.couldMerge(seed, is)) continue;
            visitedSlots[i] = true;
            if (!inv.canExtract(i, is) || (count += is.field_77994_a) < minimum) continue;
            return count;
        }
        return count;
    }

    public void probe(ServoMotor motor) {
        int targetEnd;
        int targetStart;
        Coord at = motor.getCurrentPos();
        ForgeDirection fd = motor.getOrientation().top;
        ForgeDirection fdOp = fd.getOpposite();
        at.adjust(fd);
        FzUtil.FzInv target = FzUtil.openInventory(at.getTE(IInventory.class), fdOp);
        at.adjust(fdOp);
        if (target == null) {
            motor.getArgStack().push(-1);
            return;
        }
        FzUtil.FzInv backInv = FzUtil.openInventory(motor, false);
        if (this.foreignSlot == -1) {
            targetStart = 0;
            targetEnd = target.size() - 1;
        } else {
            if (this.foreignSlot >= target.size()) {
                motor.getArgStack().push(-1);
                return;
            }
            targetStart = targetEnd = this.foreignSlot;
        }
        int count = 0;
        for (int backIndex = 0; backIndex < backInv.size(); ++backIndex) {
            ItemStack is = backInv.get(backIndex);
            for (int i = targetStart; i < targetEnd; ++i) {
                ItemStack it = target.get(i);
                if (it == null || !FzUtil.couldMerge(is, it) || !target.canInsert(i, it) && !target.canExtract(i, it)) continue;
                count += it.field_77994_a;
            }
        }
        motor.getArgStack().push(count);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderStatic(ServoMotor motor, Tessellator tess) {
        BlockRenderHelper block = BlockRenderHelper.instance;
        block.useTextures(BlockIcons.socket$shifter_front, null, BlockIcons.socket$shifter_side, BlockIcons.socket$shifter_side, BlockIcons.socket$shifter_side, BlockIcons.socket$shifter_side, BlockIcons.socket$shifter_side, BlockIcons.socket$shifter_side);
        float[] minYs = new float[]{0.5f, 0.1875f, -0.125f};
        float[] ds = new float[]{0.25f, 0.3125f, 0.375f};
        int end = ds.length;
        if (motor != null) {
            --end;
        }
        for (int i = 0; i < end; ++i) {
            float d = ds[i];
            float minY = minYs[i];
            block.func_149676_a(d, minY, d, 1.0f - d, 0.75f, 1.0f - d);
            block.beginWithMirroredUVs();
            block.rotateCenter(Quaternion.fromOrientation(FzOrientation.fromDirection(this.facing.getOpposite())));
            block.renderRotated(tess, this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderItemOnServo(RenderServoMotor render, ServoMotor motor, ItemStack is, float partial) {
        GL11.glPushMatrix();
        GL11.glTranslatef((float)0.0f, (float)0.7f, (float)0.0f);
        GL11.glRotatef((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glRotatef((float)-90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        float s = 0.9375f;
        GL11.glScalef((float)s, (float)s, (float)s);
        render.renderItem(is);
        GL11.glPopMatrix();
    }

    public static enum ShifterMode {
        MODE_STREAM,
        MODE_PULSE_EXACT,
        MODE_PULSE_SOME;

    }
}

