/*
 * Decompiled with CFR 0.152.
 */
package factorization.sockets;

import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import factorization.api.Charge;
import factorization.api.Coord;
import factorization.api.FzOrientation;
import factorization.api.IChargeConductor;
import factorization.api.Quaternion;
import factorization.api.datahelpers.DataHelper;
import factorization.api.datahelpers.IDataSerializable;
import factorization.api.datahelpers.Share;
import factorization.common.BlockIcons;
import factorization.common.FactoryType;
import factorization.notify.Notify;
import factorization.oreprocessing.TileEntityGrinder;
import factorization.oreprocessing.TileEntityGrinderRender;
import factorization.servo.RenderServoMotor;
import factorization.servo.ServoMotor;
import factorization.shared.BlockRenderHelper;
import factorization.shared.Core;
import factorization.shared.FzUtil;
import factorization.shared.NetworkFactorization;
import factorization.sockets.ISocketHolder;
import factorization.sockets.TileEntitySocketBase;
import factorization.weird.TileEntityDayBarrel;
import java.io.DataInput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EffectRenderer;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.StatCollector;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.event.world.WorldEvent;
import org.lwjgl.opengl.GL11;

public class SocketLacerator
extends TileEntitySocketBase
implements IChargeConductor {
    Charge charge = new Charge(this);
    short speed = 0;
    short progress;
    short last_shared_speed = 0;
    boolean grab_items = false;
    boolean grind_items = false;
    long targetHash = -1L;
    boolean ticked = false;
    boolean isPowered = false;
    static final byte grind_time = 25;
    static final short max_speed = 400;
    static final short min_speed = 40;
    ArrayList<ItemStack> buffer = new ArrayList();
    private float rotation = 0.0f;
    private float prev_rotation = 0.0f;
    MovingObjectPosition present_breaking_target = null;
    MovingObjectPosition previous_breaking_target = null;
    public static final DamageSource laceration = new DamageSource("laceration"){

        public IChatComponent func_151519_b(EntityLivingBase victim) {
            String ret = "death.attack.laceration.";
            if (victim.field_70170_p != null) {
                long now = victim.field_70170_p.func_82737_E();
                ret = ret + (now % 6L + 1L);
            } else {
                ret = ret + "1";
            }
            EntityLivingBase attacker = victim.func_94060_bK();
            String fightingMessage = ret + ".player";
            if (attacker != null && StatCollector.func_94522_b((String)fightingMessage)) {
                return new ChatComponentTranslation(fightingMessage, new Object[]{victim.func_145748_c_(), attacker.func_145748_c_()});
            }
            return new ChatComponentTranslation(ret, new Object[]{victim.func_145748_c_()});
        }
    };
    static SocketLacerator dropGrabber = null;
    private static MovingObjectPosition particleMop = new MovingObjectPosition(0, 0, 0, 0, Vec3.func_72443_a((double)0.0, (double)0.0, (double)0.0));
    @SideOnly(value=Side.CLIENT)
    static EffectRenderer particleTweaker;
    @SideOnly(value=Side.CLIENT)
    static EffectRenderer origER;
    @SideOnly(value=Side.CLIENT)
    static SocketLacerator me;
    @SideOnly(value=Side.CLIENT)
    static int px;
    @SideOnly(value=Side.CLIENT)
    static int py;
    @SideOnly(value=Side.CLIENT)
    static int pz;
    @SideOnly(value=Side.CLIENT)
    static double facex;
    @SideOnly(value=Side.CLIENT)
    static double facey;
    @SideOnly(value=Side.CLIENT)
    static double facez;

    @Override
    public String getInfo() {
        int s = this.speed * 100 / 400;
        String msg = s + "% speed";
        if (!this.buffer.isEmpty()) {
            msg = msg + "\nBuffered output";
        }
        return msg;
    }

    @Override
    public Charge getCharge() {
        return this.charge;
    }

    @Override
    public FactoryType getFactoryType() {
        return FactoryType.SOCKET_LACERATOR;
    }

    @Override
    public ItemStack getCreatingItem() {
        return new ItemStack((Item)Core.registry.diamond_cutting_head);
    }

    @Override
    public FactoryType getParentFactoryType() {
        return FactoryType.SOCKET_BARE_MOTOR;
    }

    @Override
    public boolean canUpdate() {
        return true;
    }

    @Override
    public void func_145845_h() {
        this.charge.update();
        super.func_145845_h();
    }

    @Override
    public boolean activate(EntityPlayer entityplayer, ForgeDirection side) {
        if (this.field_145850_b.field_72995_K) {
            return false;
        }
        if (!this.buffer.isEmpty()) {
            Notify.send(this, "%s items buffered", "" + this.buffer.size());
            return false;
        }
        if (this.getBackingInventory(this) == null) {
            Notify.send(this, "No output inventory", new String[0]);
            return false;
        }
        return false;
    }

    void slowDown() {
        this.speed = (short)Math.max(0, this.speed - 1);
    }

    void destroyPartially(MovingObjectPosition mop, int amount) {
        if (mop == null) {
            return;
        }
        this.field_145850_b.func_147443_d(this.hashCode(), mop.field_72311_b, mop.field_72312_c, mop.field_72309_d, amount);
    }

    @Override
    public void genericUpdate(ISocketHolder socket, Coord coord, boolean powered) {
        if (this.field_145850_b.field_72995_K) {
            this.prev_rotation = this.rotation;
            this.rotation += (float)this.speed / 4.0f;
            this.ticked = true;
            return;
        }
        this.isPowered = powered;
        this.genericUpdate_implementation(socket, coord, powered);
        if (FzUtil.significantChange(this.last_shared_speed, this.speed)) {
            socket.sendMessage(NetworkFactorization.MessageType.LaceratorSpeed, this.speed);
            this.last_shared_speed = this.speed;
        }
        if (this.previous_breaking_target != null && this.present_breaking_target != null) {
            if (this.previous_breaking_target.field_72311_b != this.present_breaking_target.field_72311_b || this.previous_breaking_target.field_72312_c != this.present_breaking_target.field_72312_c || this.previous_breaking_target.field_72309_d != this.present_breaking_target.field_72309_d) {
                this.destroyPartially(this.previous_breaking_target, 99);
            }
        } else if (this.present_breaking_target == null) {
            this.destroyPartially(this.previous_breaking_target, 99);
        }
        this.previous_breaking_target = this.present_breaking_target;
        if (this.progress == 0) {
            this.destroyPartially(this.present_breaking_target, 99);
            this.present_breaking_target = null;
        }
    }

    private void genericUpdate_implementation(ISocketHolder socket, Coord coord, boolean powered) {
        if (this.getBackingInventory(socket) == null) {
            this.slowDown();
            return;
        }
        if (socket.dumpBuffer(this.buffer)) {
            Iterator<ItemStack> iterator = this.buffer.iterator();
            while (iterator.hasNext()) {
                ItemStack is = iterator.next();
                if (FzUtil.normalize(is) != null) continue;
                iterator.remove();
            }
            this.slowDown();
            return;
        }
        FzOrientation orientation = FzOrientation.fromDirection(this.facing).getSwapped();
        if (powered) {
            this.slowDown();
            this.progress = 0;
        } else if (!this.rayTrace(socket, coord, orientation, powered, false, true)) {
            this.slowDown();
            this.progress = 0;
        }
        if (this.grab_items) {
            this.grab_items = false;
            for (Entity entity : this.getEntities(socket, coord, orientation.top, 1)) {
                if (entity.field_70128_L || !(entity instanceof EntityItem)) continue;
                EntityItem ei = (EntityItem)entity;
                if (ei.field_70173_aa > 1) continue;
                ItemStack is = ei.func_92059_d();
                this.processCollectedItem(is);
                ei.func_70106_y();
            }
        }
    }

    @Override
    public boolean handleMessageFromServer(NetworkFactorization.MessageType messageType, DataInput input) throws IOException {
        if (super.handleMessageFromServer(messageType, input)) {
            return true;
        }
        if (messageType == NetworkFactorization.MessageType.LaceratorSpeed) {
            this.speed = input.readShort();
            return true;
        }
        return false;
    }

    @Override
    protected byte getExtraInfo2() {
        return (byte)(127 * this.speed / 400);
    }

    @Override
    protected void useExtraInfo2(byte b) {
        this.speed = (short)(b * 400 / 127);
    }

    void processCollectedItem(ItemStack is) {
        if (!this.grind_items) {
            this.buffer.add(is);
            return;
        }
        boolean appliedRecipe = false;
        ArrayList<TileEntityGrinder.GrinderRecipe> recipes = TileEntityGrinder.recipes;
        for (int i = 0; i < recipes.size(); ++i) {
            TileEntityGrinder.GrinderRecipe gr = recipes.get(i);
            if (!FzUtil.oreDictionarySimilar(gr.getOreDictionaryInput(), is)) continue;
            ItemStack output = gr.output.func_77946_l();
            output.field_77994_a = 0;
            int min = (int)gr.probability;
            output.field_77994_a += min;
            output.field_77994_a = output.field_77994_a + (rand.nextFloat() < gr.probability - (float)min ? 1 : 0);
            is = output;
            appliedRecipe = true;
            break;
        }
        if (appliedRecipe) {
            this.grind_items = false;
        }
        this.buffer.add(is);
    }

    boolean cantDoWork(ISocketHolder socket) {
        if (!this.isPowered && socket.extractCharge(4)) {
            this.speed = (short)Math.min(400, this.speed + 4);
            if (this.speed == 400) {
                return false;
            }
        } else if (this.speed > 0) {
            this.speed = (short)(this.speed - 1);
        }
        return !this.workCheck();
    }

    boolean workCheck() {
        return this.speed > 40 && rand.nextInt(400) < this.speed / 4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean handleRay(ISocketHolder socket, MovingObjectPosition mop, boolean mopIsThis, boolean powered) {
        dropGrabber = this;
        try {
            boolean bl = this._handleRay(socket, mop, mopIsThis, powered);
            return bl;
        }
        finally {
            dropGrabber = null;
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void captureDrops(BlockEvent.HarvestDropsEvent event) {
        if (dropGrabber == null) {
            return;
        }
        if (dropGrabber != this) {
            dropGrabber.captureDrops(event);
            return;
        }
        int maxDist = 4;
        int dist = (this.field_145851_c - event.x) * (this.field_145851_c - event.x) + (this.field_145848_d - event.y) * (this.field_145848_d - event.y) + (this.field_145849_e - event.z) * (this.field_145849_e - event.z);
        if (dist > 4) {
            return;
        }
        ArrayList drops = event.drops;
        for (int i = 0; i < drops.size(); ++i) {
            ItemStack is = (ItemStack)drops.get(i);
            this.processCollectedItem(is);
        }
        drops.clear();
    }

    private boolean _handleRay(ISocketHolder socket, MovingObjectPosition mop, boolean mopIsThis, boolean powered) {
        if (mop == null) {
            return false;
        }
        if (mopIsThis) {
            return false;
        }
        if (mop.field_72313_a == MovingObjectPosition.MovingObjectType.ENTITY) {
            if (!(mop.field_72308_g instanceof EntityLivingBase)) {
                return false;
            }
            EntityLivingBase elb = (EntityLivingBase)mop.field_72308_g;
            if (elb.field_70128_L || elb.func_110143_aJ() <= 0.0f) {
                return false;
            }
            if (this.cantDoWork(socket)) {
                return !this.grab_items;
            }
            socket.extractCharge(1);
            float damage = 4.0f * (float)this.speed / 400.0f;
            if (elb.func_110143_aJ() <= damage && rand.nextInt(20) == 1) {
                elb.field_70718_bc = 100;
            }
            if (elb.func_70097_a(laceration, damage)) {
                if (elb.func_110143_aJ() <= 0.0f) {
                    this.grab_items = true;
                }
                this.targetHash = -1L;
            }
            this.progress = 0;
            return true;
        }
        if (mop.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK) {
            boolean doBreak;
            Block block = this.field_145850_b.func_147439_a(mop.field_72311_b, mop.field_72312_c, mop.field_72309_d);
            if (block == null || block.isAir((IBlockAccess)this.field_145850_b, mop.field_72311_b, mop.field_72312_c, mop.field_72309_d)) {
                return false;
            }
            int md = this.field_145850_b.func_72805_g(mop.field_72311_b, mop.field_72312_c, mop.field_72309_d);
            if (!block.func_149678_a(md, false)) {
                return false;
            }
            TileEntity te = null;
            TileEntityDayBarrel barrel = null;
            if (block == Core.registry.factory_block && (te = this.field_145850_b.func_147438_o(mop.field_72311_b, mop.field_72312_c, mop.field_72309_d)) instanceof TileEntityDayBarrel) {
                barrel = (TileEntityDayBarrel)te;
                if (barrel.item == null) {
                    return false;
                }
            }
            if (this.cantDoWork(socket)) {
                return true;
            }
            socket.extractCharge(1);
            long foundHash = mop.field_72311_b + (mop.field_72312_c << 2) + (mop.field_72309_d << 4);
            float hardness = block.func_149712_f(this.field_145850_b, mop.field_72311_b, mop.field_72312_c, mop.field_72309_d);
            if (hardness < 0.0f) {
                this.speed = (short)(this.speed - 80);
                return true;
            }
            foundHash = (foundHash << 4) + (long)block.hashCode() + (long)md;
            if (barrel != null) {
                foundHash += (long)(barrel.item.hashCode() * 5 + barrel.item.func_77960_j() * 10);
            }
            if (foundHash != this.targetHash) {
                this.targetHash = foundHash;
                this.progress = 0;
            } else {
                SocketLacerator pardner;
                TileEntity partner;
                this.progress = (short)(this.progress + 1);
                if (socket == this && rand.nextInt(4) == 0 && (partner = this.field_145850_b.func_147438_o(mop.field_72311_b + this.facing.offsetX, mop.field_72312_c + this.facing.offsetY, mop.field_72309_d + this.facing.offsetZ)) instanceof SocketLacerator && (pardner = (SocketLacerator)partner).workCheck()) {
                    this.progress = (short)(this.progress + 16);
                }
            }
            boolean bl = doBreak = (float)this.progress >= 25.0f * hardness || Core.cheat;
            if (barrel == null && !doBreak) {
                float perc = (float)this.progress / (25.0f * hardness);
                int breakage = (int)(perc * 10.0f);
                this.destroyPartially(mop, breakage);
                this.present_breaking_target = mop;
            } else if (doBreak) {
                this.destroyPartially(mop, 99);
            }
            if (doBreak) {
                this.grab_items = true;
                this.grind_items = true;
                if (barrel == null) {
                    ItemStack pick;
                    int i1 = md;
                    this.field_145850_b.func_72926_e(2001, mop.field_72311_b, mop.field_72312_c, mop.field_72309_d, Block.func_149682_b((Block)block) + md << 12);
                    EntityPlayer player = this.getFakePlayer();
                    player.field_71071_by.field_70462_a[0] = pick = new ItemStack(Items.field_151046_w);
                    boolean canHarvest = false;
                    if (block != null) {
                        canHarvest = block.canHarvestBlock(player, md);
                    }
                    canHarvest = true;
                    boolean didRemove = this.removeBlock(player, block, md, mop.field_72311_b, mop.field_72312_c, mop.field_72309_d);
                    if (didRemove && canHarvest) {
                        block.func_149636_a(this.field_145850_b, player, mop.field_72311_b, mop.field_72312_c, mop.field_72309_d, md);
                    }
                    block.func_149681_a(this.field_145850_b, mop.field_72311_b, mop.field_72312_c, mop.field_72309_d, md, player);
                    if (block.removedByPlayer(this.field_145850_b, player, mop.field_72311_b, mop.field_72312_c, mop.field_72309_d)) {
                        block.func_149664_b(this.field_145850_b, mop.field_72311_b, mop.field_72312_c, mop.field_72309_d, md);
                        block.func_149636_a(this.field_145850_b, player, mop.field_72311_b, mop.field_72312_c, mop.field_72309_d, 0);
                    }
                    player.field_71071_by.field_70462_a[0] = null;
                } else if (barrel.getItemCount() > 0) {
                    ItemStack is = barrel.item.func_77946_l();
                    is.field_77994_a = 1;
                    barrel.changeItemCount(-1);
                    this.grind_items = true;
                    this.processCollectedItem(is);
                }
                this.progress = 0;
            }
            return true;
        }
        return false;
    }

    private boolean removeBlock(EntityPlayer thisPlayerMP, Block block, int md, int x, int y, int z) {
        if (block == null) {
            return false;
        }
        block.func_149681_a(this.field_145850_b, x, y, z, md, thisPlayerMP);
        if (block.removedByPlayer(this.field_145850_b, thisPlayerMP, x, y, z)) {
            block.func_149664_b(this.field_145850_b, x, y, z, md);
            return true;
        }
        return false;
    }

    @Override
    public IDataSerializable serialize(String prefix, DataHelper data) throws IOException {
        this.charge = data.as(Share.PRIVATE, "charge").put(this.charge);
        this.speed = data.as(Share.VISIBLE, "spd").putShort(this.speed);
        this.progress = data.as(Share.PRIVATE, "prg").putShort(this.progress);
        this.buffer = data.as(Share.PRIVATE, "buf").putItemArray(this.buffer);
        this.grab_items = data.as(Share.PRIVATE, "grb").putBoolean(this.grab_items);
        this.targetHash = data.as(Share.PRIVATE, "hsh").putLong(this.targetHash);
        this.grind_items = data.as(Share.PRIVATE, "grn").putBoolean(this.grind_items);
        return this;
    }

    @Override
    protected void onRemove() {
        super.onRemove();
        Coord here = this.getCoord();
        for (ItemStack is : this.buffer) {
            FzUtil.spawnItemStack(here, is);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderTesr(ServoMotor motor, float partial) {
        float d = 0.5f;
        GL11.glTranslatef((float)d, (float)d, (float)d);
        Quaternion.fromOrientation(FzOrientation.fromDirection(this.facing.getOpposite())).glRotate();
        float turn = FzUtil.interp(this.prev_rotation, this.rotation, partial) / 5.0f;
        GL11.glRotatef((float)turn, (float)0.0f, (float)1.0f, (float)0.0f);
        float sd = motor == null ? 0.0625f : 0.1875f;
        GL11.glTranslatef((float)0.0f, (float)(-0.25f + sd + (float)Math.abs(Math.sin(turn / 800.0f)) / 32.0f), (float)0.0f);
        TileEntityGrinderRender.renderGrindHead();
        if (this.ticked) {
            this.ticked = false;
            if (this.speed > 133) {
                this.addParticles();
            }
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderStatic(ServoMotor motor, Tessellator tess) {
        IIcon metal = BlockIcons.motor_texture;
        float d = 0.25f;
        float yd = -d + 0.003f;
        BlockRenderHelper block = BlockRenderHelper.instance;
        block.useTextures(null, null, metal, metal, metal, metal);
        float yoffset = 0.3125f;
        float sd = motor == null ? 0.0f : 0.125f;
        block.func_149676_a(d, d + yd + yoffset + 0.125f + sd, d, 1.0f - d, 1.0f - (d + 0.0f) + yd + yoffset, 1.0f - d);
        block.beginWithMirroredUVs();
        block.rotateCenter(Quaternion.fromOrientation(FzOrientation.fromDirection(this.facing.getOpposite())));
        block.renderRotated(tess, this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SideOnly(value=Side.CLIENT)
    void addParticles() {
        Minecraft mc = Minecraft.func_71410_x();
        if (particleTweaker == null) {
            particleTweaker = new ParticleWarper(this.field_145850_b, mc.field_71446_o);
        }
        px = this.field_145851_c + this.facing.offsetX;
        py = this.field_145848_d + this.facing.offsetY;
        pz = this.field_145849_e + this.facing.offsetZ;
        ForgeDirection op = this.facing.getOpposite();
        facex = (double)px + 0.5 + 0.5 * (double)op.offsetX;
        facey = (double)py + 0.5 + 0.5 * (double)op.offsetY;
        facez = (double)pz + 0.5 + 0.5 * (double)op.offsetZ;
        Block b = this.field_145850_b.func_147439_a(px, py, pz);
        if (b == null) {
            return;
        }
        origER = mc.field_71452_i;
        me = this;
        mc.field_71452_i = particleTweaker;
        try {
            for (int i = 0; i < 1; ++i) {
                particleTweaker.func_78867_a(px, py, pz, op.ordinal());
            }
        }
        finally {
            me = null;
            mc.field_71452_i = origER;
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void resetEffectRenderer(WorldEvent.Unload loadEvent) {
        particleTweaker = null;
    }

    @Override
    public void uninstall() {
        if (!this.field_145850_b.field_72995_K) {
            this.destroyPartially(this.present_breaking_target, 99);
            this.destroyPartially(this.previous_breaking_target, 99);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderItemOnServo(RenderServoMotor render, ServoMotor motor, ItemStack is, float partial) {
        GL11.glPushMatrix();
        GL11.glTranslatef((float)0.0f, (float)0.375f, (float)0.0f);
        float turn = FzUtil.interp(this.prev_rotation, this.rotation, partial) / 5.0f;
        GL11.glRotatef((float)(-turn), (float)0.0f, (float)1.0f, (float)0.0f);
        float s = 0.75f;
        GL11.glScalef((float)s, (float)s, (float)s);
        int count = 6;
        for (int i = 0; i < motor.func_70302_i_(); ++i) {
            is = motor.func_70301_a(i);
            if (is == null) continue;
            GL11.glPushMatrix();
            GL11.glRotatef((float)(360 * i / 4), (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glTranslatef((float)0.0f, (float)((float)count-- / 16.0f), (float)0.3125f);
            render.renderItem(is);
            GL11.glPopMatrix();
        }
        GL11.glPopMatrix();
    }

    @Override
    public void installedOnServo(ServoMotor servoMotor) {
        super.installedOnServo(servoMotor);
        servoMotor.resizeInventory(4);
    }

    static class ParticleWarper
    extends EffectRenderer {
        public ParticleWarper(World world, TextureManager textureManager) {
            super(world, textureManager);
        }

        public void func_78873_a(EntityFX particle) {
            if (particle == null) {
                return;
            }
            ForgeDirection fd = SocketLacerator.me.facing;
            if (fd.offsetY != 0) {
                origER.func_78873_a(particle);
                return;
            }
            particle.field_70165_t = facex;
            particle.field_70163_u = facey;
            particle.field_70161_v = facez;
            float theta = (float)(Math.random() * Math.PI * 2.0);
            double dist = 0.25;
            Vec3 dir = me.func_145831_w().func_82732_R().func_72345_a(0.0, dist, 0.0);
            if (fd.offsetX != 0) {
                dir.func_72440_a(theta);
            } else if (fd.offsetY != 0) {
                dir.func_72442_b(theta);
            } else if (fd.offsetZ != 0) {
                dir.func_72446_c(theta);
            }
            particle.field_70165_t += dir.field_72450_a;
            particle.field_70163_u += dir.field_72448_b;
            particle.field_70161_v += dir.field_72449_c;
            theta = 1.5707964f;
            if (fd.offsetX != 0) {
                dir.func_72440_a(theta);
            } else if (fd.offsetY != 0) {
                dir.func_72442_b(theta);
            } else if (fd.offsetZ != 0) {
                dir.func_72446_c(theta);
            }
            float speed = 0.8f * (float)SocketLacerator.me.speed / 400.0f;
            particle.field_70159_w = dir.field_72450_a * (double)speed;
            particle.field_70181_x = dir.field_72448_b * (double)speed;
            particle.field_70179_y = dir.field_72449_c * (double)speed;
            if (particle.field_70181_x > (double)(speed / 4.0f)) {
                particle.field_70181_x *= 3.0;
            }
            particle.func_70541_f(1.0f + rand.nextFloat() * 2.0f / 3.0f);
            origER.func_78873_a(particle);
        }
    }
}

