/*
 * Decompiled with CFR 0.152.
 */
package factorization.shared;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import factorization.shared.Core;
import java.io.IOException;
import java.io.InputStream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.client.model.ModelFormatException;
import net.minecraftforge.client.model.obj.WavefrontObject;
import org.lwjgl.opengl.GL11;

public class ObjectModel {
    private final ResourceLocation modelLocation;
    private int render_list = -1;

    public ObjectModel(ResourceLocation modelLocation) {
        this.modelLocation = modelLocation;
        Core.loadBus(this);
    }

    public void render(IIcon icon) {
        WavefrontObject model;
        if (this.render_list == 0) {
            return;
        }
        if (this.render_list == -1 && (model = this.readModel()) != null) {
            this.recordModel(model, icon);
        }
        GL11.glCallList((int)this.render_list);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private WavefrontObject readModel() {
        WavefrontObject objectModel = null;
        try {
            InputStream input = null;
            try {
                input = Minecraft.func_71410_x().func_110442_L().func_110536_a(this.modelLocation).func_110527_b();
                if (input == null) {
                    Core.logWarning("Missing 3D model: " + this.modelLocation, new Object[0]);
                    this.render_list = 0;
                    WavefrontObject wavefrontObject = null;
                    return wavefrontObject;
                }
                objectModel = new WavefrontObject(this.modelLocation.toString(), input);
                input.close();
                input = null;
                return objectModel;
            }
            finally {
                if (input != null) {
                    input.close();
                }
            }
        }
        catch (IOException e) {
            Core.logWarning("Failed to load model %s", this.modelLocation);
            e.printStackTrace();
            return null;
        }
        catch (ModelFormatException e) {
            Core.logWarning("Failed to load model %s", this.modelLocation);
            e.printStackTrace();
            return null;
        }
    }

    private void recordModel(WavefrontObject objectModel, final IIcon icon) {
        if (objectModel == null) {
            return;
        }
        Tessellator subsetTessellator = new Tessellator(){

            public void func_78385_a(double u, double v) {
                super.func_78385_a((double)icon.func_94214_a(u * 16.0), (double)icon.func_94207_b(v * 16.0));
            }
        };
        this.render_list = GLAllocation.func_74526_a((int)1);
        GL11.glNewList((int)this.render_list, (int)4864);
        double modelScale = 0.0625;
        GL11.glScaled((double)modelScale, (double)modelScale, (double)modelScale);
        subsetTessellator.func_78382_b();
        objectModel.tessellateAll(subsetTessellator);
        subsetTessellator.func_78381_a();
        modelScale = 1.0 / modelScale;
        GL11.glScaled((double)modelScale, (double)modelScale, (double)modelScale);
        GL11.glEndList();
    }

    @SubscribeEvent
    public void resourcePackChanged(TextureStitchEvent.Post event) {
        if (this.render_list != -1 && this.render_list != 0) {
            GLAllocation.func_74523_b((int)this.render_list);
        }
        this.render_list = -1;
    }
}

