/*
 * Decompiled with CFR 0.152.
 */
package factorization.servo.instructions;

import factorization.api.Coord;
import factorization.api.datahelpers.DataHelper;
import factorization.api.datahelpers.IDataSerializable;
import factorization.common.BlockIcons;
import factorization.servo.CpuBlocking;
import factorization.servo.EntryAction;
import factorization.servo.Instruction;
import factorization.servo.ServoMotor;
import factorization.shared.FzUtil;
import java.io.IOException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraftforge.common.util.ForgeDirection;

public class SetEntryAction
extends Instruction {
    EntryAction mode = EntryAction.ENTRY_EXECUTE;

    @Override
    public IDataSerializable serialize(String prefix, DataHelper data) throws IOException {
        this.mode = data.asSameShare("mode").putEnum(this.mode);
        return this;
    }

    @Override
    protected ItemStack getRecipeItem() {
        return new ItemStack(Items.field_151099_bA);
    }

    @Override
    public void motorHit(ServoMotor motor) {
    }

    @Override
    public boolean preMotorHit(ServoMotor motor) {
        motor.executioner.entry_action = this.mode == EntryAction.ENTRY_WRITE ? (motor.getArgStack().getSize() > 0 ? this.mode : EntryAction.ENTRY_EXECUTE) : this.mode;
        return true;
    }

    @Override
    public IIcon getIcon(ForgeDirection side) {
        switch (this.mode) {
            default: {
                return BlockIcons.servo$entry_execute;
            }
            case ENTRY_LOAD: {
                return BlockIcons.servo$entry_load;
            }
            case ENTRY_WRITE: {
                return BlockIcons.servo$entry_write;
            }
            case ENTRY_IGNORE: 
        }
        return BlockIcons.servo$entry_ignore;
    }

    @Override
    public String getName() {
        return "fz.instruction.entryaction";
    }

    @Override
    public boolean onClick(EntityPlayer player, Coord block, ForgeDirection side) {
        if (!SetEntryAction.playerHasProgrammer(player)) {
            return false;
        }
        this.mode = (EntryAction)FzUtil.shiftEnum((Enum)this.mode, (Enum[])EntryAction.values(), (int)1);
        return true;
    }

    @Override
    public String getInfo() {
        switch (this.mode) {
            default: {
                return "Execute Immediately";
            }
            case ENTRY_LOAD: {
                return "Read to IO Stack";
            }
            case ENTRY_WRITE: {
                return "Write from IO Stack";
            }
            case ENTRY_IGNORE: 
        }
        return "Ignore Instructions";
    }

    @Override
    public CpuBlocking getBlockingBehavior() {
        return CpuBlocking.BLOCK_FOR_TICK;
    }
}

