/*
 * Decompiled with CFR 0.152.
 */
package factorization.servo.instructions;

import factorization.api.Coord;
import factorization.api.FzColor;
import factorization.api.datahelpers.DataHelper;
import factorization.api.datahelpers.IDataSerializable;
import factorization.common.BlockIcons;
import factorization.common.FactoryType;
import factorization.servo.Decorator;
import factorization.servo.ServoMotor;
import factorization.shared.Core;
import java.io.IOException;
import net.minecraft.block.Block;
import net.minecraft.block.BlockCactus;
import net.minecraft.block.BlockReed;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.util.ForgeDirection;

public class ScanColor
extends Decorator {
    static final FzColor[] colorArray = new FzColor[]{FzColor.LIME, FzColor.LIME, FzColor.LIME, FzColor.GREEN, FzColor.GREEN, FzColor.GREEN, FzColor.GREEN, FzColor.YELLOW, FzColor.YELLOW, FzColor.YELLOW, FzColor.YELLOW, FzColor.ORANGE, FzColor.ORANGE, FzColor.ORANGE, FzColor.ORANGE, FzColor.RED};

    @Override
    public IDataSerializable serialize(String prefix, DataHelper data) throws IOException {
        return this;
    }

    @Override
    public void motorHit(ServoMotor motor) {
        Coord at = motor.getCurrentPos();
        FzColor col = FzColor.readColor(at = at.add(motor.getOrientation().top));
        if (col != null) {
            motor.getArgStack().push((Object)col);
            return;
        }
        Block block = at.getBlock();
        if (block instanceof BlockReed || block instanceof BlockCactus) {
            return;
        }
        if (block instanceof IPlantable) {
            int md = ((IPlantable)block).getPlantMetadata((IBlockAccess)at.w, at.x, at.y, at.z);
            motor.getArgStack().push((Object)colorArray[md]);
            return;
        }
    }

    @Override
    public IIcon getIcon(ForgeDirection side) {
        return BlockIcons.servo$scan_color;
    }

    @Override
    public boolean onClick(EntityPlayer player, Coord block, ForgeDirection side) {
        return false;
    }

    @Override
    public boolean onClick(EntityPlayer player, ServoMotor motor) {
        return false;
    }

    @Override
    public String getName() {
        return "fz.decorator.scancolor";
    }

    @Override
    protected void addRecipes() {
        Core.registry.recipe(this.toItem(), new Object[]{"+Q+", "Q#Q", "+Q+", Character.valueOf('+'), FactoryType.SERVORAIL.itemStack(), Character.valueOf('Q'), Items.field_151128_bU, Character.valueOf('#'), Core.registry.logicMatrixIdentifier});
    }

    @Override
    public float getSize() {
        return super.getSize() - 0.03125f;
    }

    @Override
    public boolean collides() {
        return false;
    }
}

