/*
 * Decompiled with CFR 0.152.
 */
package factorization.servo.instructions;

import factorization.api.Coord;
import factorization.api.datahelpers.DataHelper;
import factorization.api.datahelpers.IDataSerializable;
import factorization.api.datahelpers.Share;
import factorization.common.BlockIcons;
import factorization.servo.CpuBlocking;
import factorization.servo.Instruction;
import factorization.servo.ServoMotor;
import factorization.servo.ServoStack;
import java.io.IOException;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraftforge.common.util.ForgeDirection;

public class Jump
extends Instruction {
    byte mode = 1;

    @Override
    public IDataSerializable serialize(String prefix, DataHelper data) throws IOException {
        this.mode = data.as(Share.MUTABLE, "mode").putByte(this.mode);
        return this;
    }

    @Override
    protected ItemStack getRecipeItem() {
        return new ItemStack((Block)Blocks.field_150331_J);
    }

    @Override
    public void motorHit(ServoMotor motor) {
        if (this.mode == 1) {
            Boolean b = motor.getArgStack().popType(Boolean.class);
            motor.executioner.markDirty();
            if (b == null) {
                motor.putError("Jump: Stack Underflow of Boolean");
                return;
            }
            if (b.booleanValue()) {
                ServoStack ss = motor.getInstructionsStack();
                if (ss.getSize() > 0) {
                    ss.pop();
                } else {
                    motor.executioner.jmp = this.mode;
                }
            }
        } else {
            motor.executioner.jmp = this.mode;
        }
    }

    @Override
    public IIcon getIcon(ForgeDirection side) {
        if (this.mode == 1) {
            return BlockIcons.servo$jmp_instruction;
        }
        if (this.mode == 2) {
            return BlockIcons.servo$jmp_tile;
        }
        return BlockIcons.error;
    }

    @Override
    public boolean onClick(EntityPlayer player, Coord block, ForgeDirection side) {
        if (!Jump.playerHasProgrammer(player)) {
            return super.onClick(player, block, side);
        }
        this.mode = this.mode == 1 ? (byte)2 : (byte)1;
        return true;
    }

    @Override
    public String getInfo() {
        if (this.mode == 1) {
            return "Jump next";
        }
        if (this.mode == 2) {
            return "Unconditional Skip";
        }
        return "?";
    }

    @Override
    public String getName() {
        return "fz.instruction.jmp";
    }

    @Override
    public CpuBlocking getBlockingBehavior() {
        return CpuBlocking.BLOCK_FOR_TICK;
    }
}

