/*
 * Decompiled with CFR 0.152.
 */
package factorization.servo;

import cpw.mods.fml.common.network.internal.FMLNetworkHandler;
import cpw.mods.fml.common.network.internal.FMLProxyPacket;
import cpw.mods.fml.common.registry.IEntityAdditionalSpawnData;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import factorization.api.Coord;
import factorization.api.FzOrientation;
import factorization.api.IChargeConductor;
import factorization.api.IEntityMessage;
import factorization.api.datahelpers.DataHelper;
import factorization.api.datahelpers.DataInNBT;
import factorization.api.datahelpers.DataInPacket;
import factorization.api.datahelpers.DataInPacketClientEdited;
import factorization.api.datahelpers.DataOutNBT;
import factorization.api.datahelpers.DataOutPacket;
import factorization.api.datahelpers.Share;
import factorization.common.FactoryType;
import factorization.servo.Decorator;
import factorization.servo.Executioner;
import factorization.servo.ItemServoRailWidget;
import factorization.servo.MotionHandler;
import factorization.servo.ServoComponent;
import factorization.servo.ServoStack;
import factorization.servo.TileEntityServoRail;
import factorization.shared.Core;
import factorization.shared.FzNetDispatch;
import factorization.shared.FzUtil;
import factorization.shared.NetworkFactorization;
import factorization.shared.Sound;
import factorization.shared.TileEntityCommon;
import factorization.sockets.GuiDataConfig;
import factorization.sockets.ISocketHolder;
import factorization.sockets.SocketEmpty;
import factorization.sockets.TileEntitySocketBase;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.ByteBufOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSourceIndirect;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class ServoMotor
extends Entity
implements IEntityAdditionalSpawnData,
IEntityMessage,
IInventory,
ISocketHolder {
    public final MotionHandler motionHandler = new MotionHandler(this);
    public Executioner executioner = new Executioner(this);
    public TileEntitySocketBase socket = new SocketEmpty();
    public boolean isSocketActive = false;
    public boolean isSocketPulsed = false;
    ItemStack[] inv = new ItemStack[1];
    ItemStack[] inv_last_sent = new ItemStack[this.inv.length];
    private static final ItemStack EMPTY_ITEM = new ItemStack((Item)null);
    private final ArrayList<MovingObjectPosition> ret = new ArrayList();
    private static final Vec3 nullVec = Vec3.func_72443_a((double)0.0, (double)0.0, (double)0.0);

    public ServoMotor(World world) {
        super(world);
        this.func_70105_a(1.0f, 1.0f);
        this.field_70178_ae = true;
    }

    public void spawnServoMotor() {
        this.motionHandler.beforeSpawn();
        this.field_70170_p.func_72838_d((Entity)this);
    }

    public void syncWithSpawnPacket() {
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        Packet p = FMLNetworkHandler.getEntitySpawningPacket((Entity)this);
        FzNetDispatch.addPacketFrom(p, this);
    }

    protected void func_70037_a(NBTTagCompound nbttagcompound) {
        try {
            this.putData(new DataInNBT(nbttagcompound));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected void func_70014_b(NBTTagCompound nbttagcompound) {
        try {
            this.putData(new DataOutNBT(nbttagcompound));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void readSpawnData(ByteBuf data) {
        try {
            this.putData(new DataInPacket((DataInput)new ByteBufInputStream(data), Side.CLIENT));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (IllegalStateException e) {
            e.printStackTrace();
        }
    }

    public void writeSpawnData(ByteBuf data) {
        try {
            this.putData(new DataOutPacket((DataOutput)new ByteBufOutputStream(data), Side.SERVER));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (IllegalStateException e) {
            e.printStackTrace();
        }
    }

    void putData(DataHelper data) throws IOException {
        this.executioner.putData(data);
        this.motionHandler.putData(data);
        int invSize = data.as(Share.VISIBLE, "inv#").putByte((byte)this.inv.length);
        this.resizeInventory(invSize);
        for (int i = 0; i < invSize; ++i) {
            ItemStack is = this.inv[i] == null ? EMPTY_ITEM : this.inv[i];
            is = data.as(Share.VISIBLE, "inv" + i).putItemStack(is);
            this.inv[i] = is == null ? is : (is.func_77973_b() == null ? null : is);
        }
        data.as(Share.VISIBLE, "sock");
        if (data.isReader()) {
            NBTTagCompound tag = data.putTag(new NBTTagCompound());
            TileEntity te = TileEntity.func_145827_c((NBTTagCompound)tag);
            this.socket = te instanceof TileEntitySocketBase ? (TileEntitySocketBase)te : new SocketEmpty();
        } else {
            NBTTagCompound output = new NBTTagCompound();
            this.socket.func_145841_b(output);
            data.putTag(output);
        }
        this.isSocketActive = data.as(Share.VISIBLE, "sockon").putBoolean(this.isSocketActive);
        this.isSocketPulsed = data.as(Share.VISIBLE, "sockpl").putBoolean(this.isSocketPulsed);
    }

    void broadcast(NetworkFactorization.MessageType message_type, Object ... msg) {
        FMLProxyPacket p = Core.network.entityPacket(this, message_type, msg);
        Core.network.broadcastPacket(null, this.getCurrentPos(), p);
    }

    public void broadcastBriefUpdate() {
        Coord a = this.getCurrentPos();
        Coord b = this.getNextPos();
        this.broadcast(NetworkFactorization.MessageType.servo_brief, (byte)this.motionHandler.orientation.ordinal(), this.motionHandler.speed_b, a.x, a.y, a.z, b.x, b.y, b.z, Float.valueOf(this.motionHandler.pos_progress));
    }

    @Override
    public boolean handleMessageFromClient(NetworkFactorization.MessageType messageType, DataInput input) throws IOException {
        if (messageType == NetworkFactorization.MessageType.DataHelperEditOnEntity) {
            DataInPacketClientEdited di = new DataInPacketClientEdited(input);
            this.socket.serialize("", di);
            this.func_70296_d();
            return true;
        }
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean handleMessageFromServer(NetworkFactorization.MessageType messageType, DataInput input) throws IOException {
        switch (messageType) {
            case OpenDataHelperGuiOnEntity: {
                if (!this.field_70170_p.field_72995_K) {
                    return false;
                }
                DataInPacket dip = new DataInPacket(input, Side.CLIENT);
                this.socket.serialize("", dip);
                Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiDataConfig(this.socket, this));
                return true;
            }
            case servo_item: {
                byte index;
                while ((index = input.readByte()) >= 0) {
                    this.inv[index] = FzUtil.readStack(input);
                }
                return true;
            }
            case servo_brief: {
                Coord a = this.getCurrentPos();
                Coord b = this.getNextPos();
                FzOrientation no = FzOrientation.getOrientation(input.readByte());
                if (no != this.motionHandler.prevOrientation) {
                    this.motionHandler.orientation = no;
                }
                this.motionHandler.speed_b = input.readByte();
                a.x = input.readInt();
                a.y = input.readInt();
                a.z = input.readInt();
                b.x = input.readInt();
                b.y = input.readInt();
                b.z = input.readInt();
                this.motionHandler.pos_progress = input.readFloat();
                if (this.motionHandler.speed_b > 0) {
                    this.motionHandler.stopped = false;
                }
                return true;
            }
            case servo_complete: {
                try {
                    DataInPacket data = new DataInPacket(input, Side.CLIENT);
                    this.putData(data);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                return true;
            }
            case servo_stopped: {
                this.motionHandler.stopped = input.readBoolean();
                return true;
            }
            case TileEntityMessageOnEntity: {
                NetworkFactorization.MessageType subMsg = NetworkFactorization.MessageType.read(input);
                return this.socket.handleMessageFromServer(subMsg, input);
            }
        }
        return this.socket.handleMessageFromServer(messageType, input);
    }

    public void func_70030_z() {
        super.func_70030_z();
        if (this.field_70128_L) {
            return;
        }
        if (this.field_70170_p.field_72995_K) {
            this.motionHandler.updateServoMotion();
            this.executioner.tick();
        } else {
            byte orig_speed = this.motionHandler.speed_b;
            FzOrientation orig_or = this.motionHandler.orientation;
            this.motionHandler.updateServoMotion();
            this.executioner.tick();
            if (orig_speed != this.motionHandler.speed_b || orig_or != this.motionHandler.orientation) {
                this.broadcastBriefUpdate();
            }
            if (this.executioner.stacks_changed) {
                try {
                    this.executioner.stacks_changed = false;
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    DataOutputStream dos = new DataOutputStream(baos);
                    Core.network.prefixEntityPacket(dos, this, NetworkFactorization.MessageType.servo_complete);
                    DataOutPacket data = new DataOutPacket(dos, Side.SERVER);
                    this.putData(data);
                    FMLProxyPacket toSend = Core.network.entityPacket(baos);
                    Core.network.broadcastPacket(null, this.getCurrentPos(), toSend);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    void updateSocket() {
        Coord here = this.getCurrentPos();
        here.setAsTileEntityLocation(this.socket);
        this.socket.facing = this.motionHandler.orientation.top;
        this.socket.genericUpdate(this, here, this.isSocketActive ^ this.isSocketPulsed);
        this.isSocketPulsed = false;
    }

    void onEnterNewBlock() {
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        this.socket.onEnterNewBlock();
        this.motionHandler.onEnterNewBlock();
        TileEntityServoRail rail = this.getCurrentPos().getTE(TileEntityServoRail.class);
        if (rail != null && rail.decoration != null && rail.decoration.preMotorHit(this)) {
            return;
        }
        this.executioner.onEnterNewBlock(rail);
    }

    public ServoStack getArgStack() {
        return this.executioner.getArgStack();
    }

    public ServoStack getInstructionsStack() {
        return this.executioner.getInstructionStack();
    }

    public void putError(Object error) {
        this.executioner.putError(error);
    }

    public Coord getCurrentPos() {
        return this.motionHandler.pos_prev;
    }

    public Coord getNextPos() {
        return this.motionHandler.pos_next;
    }

    public FzOrientation getOrientation() {
        return this.motionHandler.orientation;
    }

    public void setOrientation(FzOrientation orientation) {
        this.motionHandler.orientation = orientation;
    }

    public void changeOrientation(ForgeDirection fd) {
        this.motionHandler.changeOrientation(fd);
    }

    public void setNextDirection(ForgeDirection direction) {
        this.motionHandler.nextDirection = direction;
    }

    public void setTargetSpeed(byte newTarget) {
        this.motionHandler.setTargetSpeed((byte)(newTarget - 1));
    }

    public byte getTargetSpeed() {
        return (byte)(this.motionHandler.target_speed_index + 1);
    }

    public void penalizeSpeed() {
        this.motionHandler.penalizeSpeed();
    }

    public void setStopped(boolean stop) {
        this.motionHandler.setStopped(stop);
    }

    public boolean isStopped() {
        return this.motionHandler.stopped;
    }

    protected void func_70088_a() {
    }

    public boolean func_130002_c(EntityPlayer player) {
        if (this.field_70170_p.field_72995_K) {
            return true;
        }
        this.executioner.stacks_changed = true;
        ItemStack is = FzUtil.normalize(player.func_70694_bm());
        if (is == null) {
            return false;
        }
        Item item = is.func_77973_b();
        if (item instanceof ItemServoRailWidget) {
            ServoComponent sc = ServoComponent.fromItem(is);
            if (player.func_70093_af()) {
                if (!sc.onClick(player, this)) {
                    return false;
                }
                ItemStack updated = sc.toItem();
                is.func_77964_b(updated.func_77960_j());
                is.func_77982_d(updated.func_77978_p());
                return true;
            }
            if (sc instanceof Decorator) {
                Decorator dec = (Decorator)sc;
                dec.motorHit(this);
                return true;
            }
        }
        if (this.socket == null) {
            return false;
        }
        if (this.socket.activateOnServo(player, this)) {
            return false;
        }
        for (FactoryType ft : FactoryType.values()) {
            TileEntitySocketBase rep;
            ItemStack creator;
            TileEntityCommon tec = ft.getRepresentative();
            if (tec == null || !(tec instanceof TileEntitySocketBase) || (creator = (rep = (TileEntitySocketBase)tec).getCreatingItem()) == null || !FzUtil.couldMerge(is, creator)) continue;
            if (rep.getParentFactoryType() != this.socket.getFactoryType()) {
                rep.mentionPrereq(this);
                return false;
            }
            TileEntityCommon upgrade = ft.makeTileEntity();
            if (upgrade == null) continue;
            this.socket = (TileEntitySocketBase)upgrade;
            if (!player.field_71075_bZ.field_75098_d) {
                --is.field_77994_a;
            }
            Sound.servoInstall.playAt(new Coord(this));
            this.socket.installedOnServo(this);
            return true;
        }
        return false;
    }

    public boolean func_70097_a(DamageSource damageSource, float damage) {
        if (damageSource instanceof EntityDamageSourceIndirect) {
            return false;
        }
        Entity src = damageSource.func_76364_f();
        if (!(src instanceof EntityPlayer)) {
            return false;
        }
        if (this.field_70128_L) {
            return false;
        }
        EntityPlayer player = (EntityPlayer)src;
        this.despawn(player.field_71075_bZ.field_75098_d);
        return true;
    }

    void despawn(boolean creativeModeHit) {
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        this.func_70106_y();
        if (creativeModeHit) {
            return;
        }
        ArrayList<ItemStack> toDrop = new ArrayList<ItemStack>();
        toDrop.add(new ItemStack((Item)Core.registry.servo_placer));
        for (ItemStack is : this.inv) {
            toDrop.add(is);
        }
        if (this.socket != null) {
            this.socket.uninstall();
            FactoryType ft = this.socket.getFactoryType();
            while (ft != null) {
                TileEntitySocketBase sb = (TileEntitySocketBase)ft.getRepresentative();
                ItemStack is = sb.getCreatingItem();
                if (is != null) {
                    toDrop.add(is.func_77946_l());
                }
                ft = sb.getParentFactoryType();
            }
        }
        this.dropItemStacks(toDrop);
    }

    public void dropItemStacks(Iterable<ItemStack> toDrop) {
        for (ItemStack is : toDrop) {
            FzUtil.spawnItemStack(this, is);
        }
    }

    public boolean func_70067_L() {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70056_a(double x, double y, double z, float yaw, float pitch, int three) {
    }

    public void func_70107_b(double x, double y, double z) {
        this.field_70165_t = x;
        this.field_70163_u = y;
        this.field_70161_v = z;
        double dp = 1.0;
        this.field_70121_D.func_72324_b(x, y, z, x + dp, y + dp, z + dp);
    }

    public void func_70080_a(double x, double y, double z, float yaw, float pitch) {
        super.func_70080_a(x, y, z, yaw, pitch);
    }

    public void resizeInventory(int newSize) {
        if (newSize == this.inv.length) {
            return;
        }
        ItemStack[] origInv = this.inv;
        int min = Math.min(newSize, origInv.length);
        this.inv = new ItemStack[newSize];
        for (int i = 0; i < min; ++i) {
            this.inv[i] = origInv[i];
            origInv[i] = null;
        }
        for (ItemStack is : origInv) {
            if (is == null) continue;
            this.getCurrentPos().spawnItem(is);
        }
        this.inv_last_sent = new ItemStack[newSize];
    }

    public int func_70302_i_() {
        return this.inv.length;
    }

    public ItemStack func_70301_a(int i) {
        return this.inv[i];
    }

    public ItemStack func_70298_a(int i, int j) {
        ItemStack ret = this.inv[i].func_77979_a(j);
        this.inv[i] = FzUtil.normalize(this.inv[i]);
        return ret;
    }

    public ItemStack func_70304_b(int i) {
        return null;
    }

    public void func_70299_a(int i, ItemStack itemstack) {
        this.inv[i] = itemstack;
    }

    public String func_145825_b() {
        return "Servo Motor Inventory";
    }

    public boolean func_145818_k_() {
        return true;
    }

    public int func_70297_j_() {
        return 64;
    }

    public void func_70296_d() {
        ArrayList<Number> toSend = new ArrayList<Number>(this.inv.length * 2);
        for (byte i = 0; i < this.inv.length; i = (byte)(i + 1)) {
            if (FzUtil.identical(this.inv[i], this.inv_last_sent[i])) continue;
            toSend.add(i);
            toSend.add((Number)(this.inv[i] == null ? EMPTY_ITEM : this.inv[i]));
            this.inv_last_sent[i] = this.inv[i];
        }
        if (toSend.isEmpty()) {
            return;
        }
        toSend.add(-1);
        this.broadcast(NetworkFactorization.MessageType.servo_item, toSend.toArray());
        this.getCurrentPos().getChunk().func_76630_e();
        this.getNextPos().getChunk().func_76630_e();
    }

    public boolean func_70300_a(EntityPlayer entityplayer) {
        return false;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int i, ItemStack itemstack) {
        return true;
    }

    ArrayList<MovingObjectPosition> rayTrace() {
        this.ret.clear();
        Coord c = this.getCurrentPos();
        ForgeDirection top = this.motionHandler.orientation.top;
        ForgeDirection face = this.motionHandler.orientation.facing;
        ForgeDirection right = face.getRotation(top);
        AxisAlignedBB ab = AxisAlignedBB.func_72332_a().func_72299_a((double)(c.x + top.offsetX), (double)(c.y + top.offsetY), (double)(c.z + top.offsetZ), (double)(c.x + 1 + top.offsetX), (double)(c.y + 1 + top.offsetY), (double)(c.z + 1 + top.offsetZ));
        for (Entity entity : this.field_70170_p.func_72839_b((Entity)this, ab)) {
            if (!entity.func_70067_L()) continue;
            this.ret.add(new MovingObjectPosition(entity));
        }
        ServoMotor.nullVec.field_72449_c = 0.0;
        ServoMotor.nullVec.field_72448_b = 0.0;
        ServoMotor.nullVec.field_72450_a = 0.0;
        Coord targetBlock = c.add(top);
        this.mopBlock(this.ret, targetBlock, top.getOpposite());
        this.mopBlock(this.ret, targetBlock.add(top), top.getOpposite());
        this.mopBlock(this.ret, targetBlock.add(top.getOpposite()), top);
        if (this.ret.size() == 0) {
            this.mopBlock(this.ret, targetBlock.add(face), face.getOpposite());
            this.mopBlock(this.ret, targetBlock.add(face.getOpposite()), face);
            if (this.ret.size() == 0) {
                this.mopBlock(this.ret, targetBlock.add(right), right.getOpposite());
                this.mopBlock(this.ret, targetBlock.add(right.getOpposite()), right);
            }
        }
        return this.ret;
    }

    void mopBlock(ArrayList<MovingObjectPosition> list, Coord target, ForgeDirection side) {
        if (target.isAir()) {
            return;
        }
        list.add(target.createMop(side, nullVec));
    }

    @Override
    public boolean dumpBuffer(List<ItemStack> buffer) {
        if (buffer.isEmpty()) {
            return false;
        }
        FzUtil.FzInv me = FzUtil.openInventory(this, false);
        ItemStack got = buffer.get(0);
        if (got == null) {
            buffer.remove(0);
            return true;
        }
        ItemStack res = me.push(buffer.get(0));
        if (res == null) {
            buffer.remove(0);
        } else {
            buffer.set(0, res);
        }
        return true;
    }

    @Override
    public boolean extractCharge(int amount) {
        IChargeConductor wire = this.getCurrentPos().getTE(IChargeConductor.class);
        if (wire == null) {
            return false;
        }
        return wire.getCharge().tryTake(amount) >= amount;
    }

    @Override
    public void sendMessage(NetworkFactorization.MessageType msgType, Object ... msg) {
        Object[] buff = new Object[msg.length + 1];
        System.arraycopy(msg, 0, buff, 1, msg.length);
        buff[0] = msgType;
        FMLProxyPacket toSend = Core.network.entityPacket(this, NetworkFactorization.MessageType.TileEntityMessageOnEntity, buff);
        Core.network.broadcastPacket(null, this.getCurrentPos(), toSend);
    }
}

