/*
 * Decompiled with CFR 0.152.
 */
package factorization.servo;

import factorization.api.FzOrientation;
import factorization.api.Quaternion;
import factorization.common.BlockIcons;
import factorization.servo.ServoMotor;
import factorization.servo.ServoStack;
import factorization.shared.Core;
import factorization.shared.FzUtil;
import factorization.shared.ObjectModel;
import factorization.sockets.TileEntitySocketBase;
import java.util.Iterator;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.model.ModelZombie;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderBiped;
import net.minecraft.client.renderer.entity.RenderEntity;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Vec3;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.opengl.GL11;

public class RenderServoMotor
extends RenderEntity {
    ObjectModel sprocket = new ObjectModel(Core.getResource("models/servo/sprocket.obj"));
    ObjectModel chasis = new ObjectModel(Core.getResource("models/servo/chasis.obj"));
    static Vec3 quat_vector = Vec3.func_72443_a((double)0.0, (double)0.0, (double)0.0);
    static Quaternion start = new Quaternion();
    static Quaternion end = new Quaternion();
    private Quaternion q0 = new Quaternion();
    private Quaternion q1 = new Quaternion();
    private static boolean debug_servo_orientation = false;
    RenderItem renderItem = new RenderItem();
    static ItemStack equiped_item = null;
    static EntityLiving item_holder = new EntityLiving(null){

        public ItemStack func_70694_bm() {
            return equiped_item;
        }
    };
    static HolderRenderer holder_render = new HolderRenderer((ModelBiped)new ModelZombie(), 1.0f);
    static EntityLiving dummy_entity = new EntityEnderman(null);

    ForgeDirection getPerpendicular(ForgeDirection a, ForgeDirection b) {
        return a.getRotation(b);
    }

    float interp(double a, double b, double part) {
        double d = a - b;
        float r = (float)(b + d * part);
        double v = Math.min(1.0f, r * r * 4.0f);
        return (float)v;
    }

    public void func_76986_a(Entity ent, double x, double y, double z, float yaw, float partial) {
        Core.profileStartRender("servo");
        MovingObjectPosition mop = Minecraft.func_71410_x().field_71476_x;
        boolean highlighted = mop != null && mop.field_72308_g == ent;
        ServoMotor motor = (ServoMotor)ent;
        GL11.glPushMatrix();
        GL11.glEnable((int)32826);
        GL11.glTranslated((double)(x + 0.5), (double)(y + 0.5), (double)(z + 0.5));
        GL11.glPushMatrix();
        motor.motionHandler.interpolatePosition((float)Math.pow(motor.motionHandler.pos_progress, 2.0));
        float reorientInterpolation = this.interp(motor.motionHandler.servo_reorient, motor.motionHandler.prev_servo_reorient, partial);
        this.orientMotor(motor, partial, reorientInterpolation);
        this.renderMainModel(motor, partial, reorientInterpolation, false);
        this.renderSocketAttachment(motor, motor.socket, partial);
        boolean render_details = false;
        if (highlighted) {
            GL11.glDisable((int)3553);
            GL11.glPushAttrib((int)16448);
            GL11.glDisable((int)2896);
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
            float gray = 0.65f;
            GL11.glColor4f((float)gray, (float)gray, (float)gray, (float)0.8f);
            GL11.glLineWidth((float)1.5f);
            float d = 0.5f;
            float h = 0.25f;
            AxisAlignedBB ab = AxisAlignedBB.func_72330_a((double)(-d), (double)(-h), (double)(-d), (double)d, (double)h, (double)d);
            this.drawOutlinedBoundingBox(ab);
            ab.func_72317_d(ab.field_72340_a, ab.field_72338_b, ab.field_72339_c);
            GL11.glPopAttrib();
            GL11.glEnable((int)3553);
            EntityPlayer player = Core.proxy.getClientPlayer();
            if (player != null) {
                for (int i = 0; i < 9; ++i) {
                    ItemStack is = player.field_71071_by.func_70301_a(i);
                    if (is == null || is.func_77973_b() != Core.registry.logicMatrixProgrammer) continue;
                    render_details = true;
                    break;
                }
            }
        }
        this.renderInventory(motor, partial);
        GL11.glPopMatrix();
        if (render_details) {
            GL11.glDisable((int)2929);
            GL11.glRotatef((float)(-RenderManager.field_78727_a.field_78735_i), (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)RenderManager.field_78727_a.field_78732_j, (float)1.0f, (float)0.0f, (float)0.0f);
            this.renderStacks(motor);
            GL11.glEnable((int)2929);
        }
        GL11.glPopMatrix();
        motor.motionHandler.interpolatePosition(motor.motionHandler.pos_progress);
        GL11.glDisable((int)32826);
        Core.profileEndRender();
    }

    void drawOutlinedBoundingBox(AxisAlignedBB par1AxisAlignedBB) {
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78371_b(3);
        tessellator.func_78377_a(par1AxisAlignedBB.field_72340_a, par1AxisAlignedBB.field_72338_b, par1AxisAlignedBB.field_72339_c);
        tessellator.func_78377_a(par1AxisAlignedBB.field_72336_d, par1AxisAlignedBB.field_72338_b, par1AxisAlignedBB.field_72339_c);
        tessellator.func_78377_a(par1AxisAlignedBB.field_72336_d, par1AxisAlignedBB.field_72338_b, par1AxisAlignedBB.field_72334_f);
        tessellator.func_78377_a(par1AxisAlignedBB.field_72340_a, par1AxisAlignedBB.field_72338_b, par1AxisAlignedBB.field_72334_f);
        tessellator.func_78377_a(par1AxisAlignedBB.field_72340_a, par1AxisAlignedBB.field_72338_b, par1AxisAlignedBB.field_72339_c);
        tessellator.func_78381_a();
        tessellator.func_78371_b(3);
        tessellator.func_78377_a(par1AxisAlignedBB.field_72340_a, par1AxisAlignedBB.field_72337_e, par1AxisAlignedBB.field_72339_c);
        tessellator.func_78377_a(par1AxisAlignedBB.field_72336_d, par1AxisAlignedBB.field_72337_e, par1AxisAlignedBB.field_72339_c);
        tessellator.func_78377_a(par1AxisAlignedBB.field_72336_d, par1AxisAlignedBB.field_72337_e, par1AxisAlignedBB.field_72334_f);
        tessellator.func_78377_a(par1AxisAlignedBB.field_72340_a, par1AxisAlignedBB.field_72337_e, par1AxisAlignedBB.field_72334_f);
        tessellator.func_78377_a(par1AxisAlignedBB.field_72340_a, par1AxisAlignedBB.field_72337_e, par1AxisAlignedBB.field_72339_c);
        tessellator.func_78381_a();
        tessellator.func_78371_b(1);
        tessellator.func_78377_a(par1AxisAlignedBB.field_72340_a, par1AxisAlignedBB.field_72338_b, par1AxisAlignedBB.field_72339_c);
        tessellator.func_78377_a(par1AxisAlignedBB.field_72340_a, par1AxisAlignedBB.field_72337_e, par1AxisAlignedBB.field_72339_c);
        tessellator.func_78377_a(par1AxisAlignedBB.field_72336_d, par1AxisAlignedBB.field_72338_b, par1AxisAlignedBB.field_72339_c);
        tessellator.func_78377_a(par1AxisAlignedBB.field_72336_d, par1AxisAlignedBB.field_72337_e, par1AxisAlignedBB.field_72339_c);
        tessellator.func_78377_a(par1AxisAlignedBB.field_72336_d, par1AxisAlignedBB.field_72338_b, par1AxisAlignedBB.field_72334_f);
        tessellator.func_78377_a(par1AxisAlignedBB.field_72336_d, par1AxisAlignedBB.field_72337_e, par1AxisAlignedBB.field_72334_f);
        tessellator.func_78377_a(par1AxisAlignedBB.field_72340_a, par1AxisAlignedBB.field_72338_b, par1AxisAlignedBB.field_72334_f);
        tessellator.func_78377_a(par1AxisAlignedBB.field_72340_a, par1AxisAlignedBB.field_72337_e, par1AxisAlignedBB.field_72334_f);
        tessellator.func_78381_a();
    }

    void orientMotor(ServoMotor motor, float partial, float reorientInterpolation) {
        Quaternion qt;
        FzOrientation orientation = motor.motionHandler.orientation;
        FzOrientation prevOrientation = motor.motionHandler.prevOrientation;
        if (prevOrientation == FzOrientation.UNKNOWN) {
            prevOrientation = orientation;
        }
        if (debug_servo_orientation) {
            GL11.glDisable((int)2896);
            GL11.glDisable((int)3553);
            GL11.glLineWidth((float)4.0f);
            GL11.glBegin((int)3);
            FzOrientation o = orientation;
            GL11.glColor3f((float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glVertex3d((double)0.0, (double)0.0, (double)0.0);
            GL11.glVertex3d((double)o.facing.offsetX, (double)o.facing.offsetY, (double)o.facing.offsetZ);
            GL11.glVertex3d((double)(o.facing.offsetX + o.top.offsetX), (double)(o.facing.offsetY + o.top.offsetY), (double)(o.facing.offsetZ + o.top.offsetZ));
            GL11.glEnd();
            GL11.glLineWidth((float)2.0f);
            GL11.glBegin((int)3);
            o = prevOrientation;
            GL11.glColor3f((float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glVertex3d((double)0.0, (double)0.0, (double)0.0);
            GL11.glVertex3d((double)o.facing.offsetX, (double)o.facing.offsetY, (double)o.facing.offsetZ);
            GL11.glVertex3d((double)(o.facing.offsetX + o.top.offsetX), (double)(o.facing.offsetY + o.top.offsetY), (double)(o.facing.offsetZ + o.top.offsetZ));
            GL11.glEnd();
        }
        if (prevOrientation == orientation) {
            qt = Quaternion.fromOrientation(orientation);
        } else {
            this.q0.update(Quaternion.fromOrientation(prevOrientation));
            this.q1.update(Quaternion.fromOrientation(orientation));
            if (this.q0.dotProduct(this.q1) < 0.0) {
                this.q0.incrScale(-1.0);
            }
            this.q0.incrLerp(this.q1, reorientInterpolation);
            qt = this.q0;
        }
        qt.glRotate();
        GL11.glRotatef((float)90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        if (debug_servo_orientation) {
            GL11.glColor3f((float)1.0f, (float)0.0f, (float)1.0f);
            GL11.glBegin((int)3);
            GL11.glVertex3d((double)0.0, (double)0.0, (double)0.0);
            GL11.glVertex3d((double)1.0, (double)0.0, (double)0.0);
            GL11.glVertex3d((double)1.0, (double)1.0, (double)0.0);
            GL11.glVertex3d((double)0.0, (double)0.0, (double)0.0);
            GL11.glEnd();
            GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glEnable((int)3553);
            GL11.glEnable((int)2896);
        }
    }

    void renderSocketAttachment(ServoMotor motor, TileEntitySocketBase socket, float partial) {
        socket.field_145849_e = 0;
        socket.field_145848_d = 0;
        socket.field_145851_c = 0;
        socket.facing = ForgeDirection.UP;
        socket.renderInServo(motor, partial);
    }

    void renderInventory(ServoMotor motor, float partial) {
        ItemStack is = motor.inv[0];
        if (is == null) {
            return;
        }
        RenderServoMotor.dummy_entity.field_70170_p = motor.field_70170_p;
        holder_render.func_76976_a(this.field_76990_c);
        motor.socket.renderItemOnServo(this, motor, is, partial);
        RenderServoMotor.dummy_entity.field_70170_p = null;
    }

    protected ResourceLocation func_110775_a(Entity par1Entity) {
        return Core.blockAtlas;
    }

    void renderMainModel(ServoMotor motor, float partial, double ro, boolean hilighting) {
        double stretch_interp;
        GL11.glPushMatrix();
        this.func_110776_a(Core.blockAtlas);
        this.chasis.render(BlockIcons.servo$model$chasis);
        double rail_width = 0.4375;
        double radius = 0.6230500000000001;
        double constant = Math.PI * 2 * radius;
        double partial_rotation = FzUtil.interp((float)motor.motionHandler.prev_sprocket_rotation, (float)motor.motionHandler.sprocket_rotation, partial);
        double angle = constant * partial_rotation;
        radius = 0.22916666666666666;
        radius = -0.25;
        float rd = (float)(radius + rail_width);
        if (motor.motionHandler.orientation != motor.motionHandler.prevOrientation && motor.motionHandler.prevOrientation != FzOrientation.UNKNOWN && (stretch_interp = ro * 2.0) < 1.0) {
            if (stretch_interp > 0.5) {
                stretch_interp = 1.0 - stretch_interp;
            }
            rd = (float)((double)rd + stretch_interp / 8.0);
        }
        float height_d = 0.125f;
        GL11.glRotatef((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glPushMatrix();
        GL11.glTranslatef((float)0.0f, (float)height_d, (float)rd);
        GL11.glRotatef((float)((float)Math.toDegrees(angle)), (float)0.0f, (float)1.0f, (float)0.0f);
        this.sprocket.render(BlockIcons.servo$model$sprocket);
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        GL11.glTranslatef((float)0.0f, (float)height_d, (float)(-rd));
        GL11.glRotatef((float)((float)Math.toDegrees(-angle) + 40.0f), (float)0.0f, (float)1.0f, (float)0.0f);
        this.sprocket.render(BlockIcons.servo$model$sprocket);
        GL11.glPopMatrix();
        GL11.glPopMatrix();
    }

    public void renderItem(ItemStack is) {
        Block block;
        equiped_item = is;
        GL11.glPushMatrix();
        float s = 0.25f;
        GL11.glScalef((float)s, (float)s, (float)s);
        boolean needRotationFix = true;
        if (is.func_77973_b() instanceof ItemBlock && (block = Block.func_149634_a((Item)is.func_77973_b())) != null && RenderBlocks.func_147739_a((int)block.func_149645_b())) {
            needRotationFix = false;
        }
        if (needRotationFix) {
            GL11.glTranslatef((float)0.9375f, (float)0.0625f, (float)-0.0f);
            GL11.glRotatef((float)-335.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glRotatef((float)-50.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        }
        float scale = 1.5f;
        GL11.glScalef((float)scale, (float)scale, (float)scale);
        int itemColor = is.func_77973_b().func_82790_a(is, 0);
        float cr = (float)(itemColor >> 16 & 0xFF) / 255.0f;
        float cg = (float)(itemColor >> 8 & 0xFF) / 255.0f;
        float cb = (float)(itemColor & 0xFF) / 255.0f;
        GL11.glColor4f((float)cr, (float)cg, (float)cb, (float)1.0f);
        this.field_76990_c.field_78721_f.func_78443_a((EntityLivingBase)dummy_entity, is, 0);
        if (is.func_77973_b().func_77623_v()) {
            for (int x = 1; x < is.func_77973_b().getRenderPasses(is.func_77960_j()); ++x) {
                this.field_76990_c.field_78721_f.func_78443_a((EntityLivingBase)dummy_entity, is, x);
            }
        }
        GL11.glPopMatrix();
    }

    protected void func_82422_c() {
        GL11.glTranslatef((float)0.0f, (float)0.1875f, (float)0.0f);
    }

    void renderStacks(ServoMotor motor) {
        GL11.glDisable((int)2896);
        GL11.glPushMatrix();
        float scale = 0.03125f;
        GL11.glScalef((float)scale, (float)scale, (float)scale);
        this.renderStack(motor.getArgStack(), scale, 0);
        this.renderStack(motor.getInstructionsStack(), scale, 1);
        GL11.glPopMatrix();
        GL11.glEnable((int)2896);
    }

    void renderStack(ServoStack ss, float scale, int i) {
        GL11.glPushMatrix();
        GL11.glRotatef((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glTranslatef((float)0.0f, (float)(-0.9f / scale), (float)0.0f);
        int color = 0xFFFFCF;
        if (i == 0) {
            GL11.glTranslatef((float)-16.0f, (float)0.0f, (float)0.0f);
        } else if (i == 1) {
            GL11.glTranslatef((float)16.0f, (float)(8 * ss.getSize()), (float)0.0f);
            color = 0xCFFFCF;
        }
        if (this.renderStackWithColor(ss, color)) {
            // empty if block
        }
        GL11.glPopMatrix();
    }

    boolean renderStackWithColor(ServoStack stack, int color) {
        FontRenderer fr = this.func_76983_a();
        int count = stack.getSize();
        if (count == 0) {
            fr.func_85187_a("_", 0, 0, color, true);
            return false;
        }
        GL11.glPushMatrix();
        float s = 7.0f / (float)count;
        if (s > 1.0f) {
            s = 1.0f;
        }
        GL11.glScalef((float)s, (float)s, (float)s);
        GL11.glTranslatef((float)0.0f, (float)((float)count * 7.5f), (float)0.0f);
        fr.func_85187_a("_", 0, 0, color, true);
        Iterator<Object> it = stack.descendingIterator();
        while (it.hasNext()) {
            Object o = it.next();
            GL11.glTranslatef((float)0.0f, (float)-10.0f, (float)0.0f);
            fr.func_85187_a(o != null ? o.toString() : "null", 0, 0, color, true);
        }
        GL11.glPopMatrix();
        return true;
    }

    private static class HolderRenderer
    extends RenderBiped {
        public HolderRenderer(ModelBiped model, float someFloat) {
            super(model, someFloat);
        }

        public void renderItem(float partial) {
            this.func_77029_c(item_holder, partial);
        }
    }
}

