/*
 * Decompiled with CFR 0.152.
 */
package factorization.docs;

import factorization.docs.DocViewer;
import factorization.docs.Word;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.item.ItemStack;
import org.lwjgl.opengl.GL11;

public class ItemWord
extends Word {
    ItemStack is = null;
    ItemStack[] entries = null;

    public ItemWord(ItemStack is) {
        super(ItemWord.getDefaultHyperlink(is));
        this.is = is;
    }

    public ItemWord(ItemStack[] entries) {
        super(ItemWord.getDefaultHyperlink(entries));
        this.entries = entries;
    }

    public ItemWord(ItemStack is, String hyperlink) {
        super(hyperlink);
        this.is = is;
    }

    static String getDefaultHyperlink(ItemStack is) {
        if (is == null) {
            return null;
        }
        return "cgi/recipes/" + is.func_77977_a();
    }

    static String getDefaultHyperlink(ItemStack[] items) {
        if (items == null || items.length == 0) {
            return null;
        }
        if (items.length == 1) {
            return ItemWord.getDefaultHyperlink(items[0]);
        }
        return null;
    }

    @Override
    public String getLink() {
        return ItemWord.getDefaultHyperlink(this.getItem());
    }

    public String toString() {
        return this.is + " ==> " + this.getLink();
    }

    @Override
    public int getWidth(FontRenderer font) {
        return 16;
    }

    ItemStack getItem() {
        if (this.is != null) {
            return this.is;
        }
        if (this.entries == null) {
            return null;
        }
        long now = System.currentTimeMillis() / 1000L;
        return this.entries[(int)(now %= (long)this.entries.length)];
    }

    @Override
    public int draw(DocViewer doc, int x, int y) {
        ItemStack toDraw = this.getItem();
        if (toDraw == null) {
            return 16;
        }
        GL11.glPushAttrib((int)1048575);
        try {
            doc.drawItem(toDraw, x, y - 4);
        }
        catch (Throwable t) {
            t.printStackTrace();
            this.is = null;
            try {
                Tessellator.field_78398_a.func_78381_a();
            }
            catch (IllegalStateException e) {
                // empty catch block
            }
        }
        GL11.glPopAttrib();
        return 16;
    }

    @Override
    public void drawHover(DocViewer doc, int mouseX, int mouseY) {
        ItemStack toDraw = this.getItem();
        if (toDraw == null) {
            return;
        }
        GL11.glPushAttrib((int)1048575);
        doc.drawItemTip(toDraw, mouseX, mouseY);
        GL11.glPopAttrib();
    }
}

