/*
 * Decompiled with CFR 0.152.
 */
package factorization.docs;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import factorization.api.Coord;
import factorization.api.DeltaCoord;
import factorization.shared.Core;
import factorization.shared.FzUtil;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.World;
import net.minecraft.world.WorldSettings;
import net.minecraft.world.chunk.Chunk;

public class DocWorld
extends WorldClient {
    static final Minecraft mc = Minecraft.func_71410_x();
    static final int LEN = 4096;
    int[] blockIds;
    int[] blockMetadatas;
    ArrayList<TileEntity> tileEntities = new ArrayList();
    ArrayList<Entity> entities = new ArrayList();
    public int diagonal = 32;
    Coord orig = new Coord((World)this, 0, 0, 0);
    private static final String BLOCK_IDS = "i";
    private static final String BLOCK_METADATA = "m";
    private static final String TE_LIST = "t";
    private static final String ENTITY_LIST = "e";
    private static final String DIAGONAL = "d";
    private static final String ORIG_ENT_POS = "o";
    Chunk myChunk = new Chunk((World)this, 0, 0){

        public Block func_150810_a(int x, int y, int z) {
            return DocWorld.this.func_147439_a(x, y, z);
        }

        public TileEntity func_150806_e(int x, int y, int z) {
            return DocWorld.this.func_147438_o(x, y, z);
        }

        public TileEntity getTileEntityUnsafe(int x, int y, int z) {
            return DocWorld.this.func_147438_o(x, y, z);
        }

        public boolean func_76606_c(int par1, int par2) {
            return false;
        }

        public int func_76628_c(int x, int y, int z) {
            return DocWorld.this.func_72805_g(x, y, z);
        }
    };

    public DocWorld() {
        super(mc.func_147114_u(), new WorldSettings(DocWorld.mc.field_71441_e.func_72912_H()), 0, DocWorld.mc.field_71441_e.field_73013_u, DocWorld.mc.field_71424_I);
        this.blockIds = new int[4096];
        this.blockMetadatas = new int[4096];
    }

    public DocWorld(NBTTagCompound tag) {
        this();
        this.orig.readFromNBT(ORIG_ENT_POS, tag);
        this.blockIds = tag.func_74759_k(BLOCK_IDS);
        this.blockMetadatas = tag.func_74759_k(BLOCK_METADATA);
        NBTTagList teList = tag.func_150295_c(TE_LIST, 10);
        this.tileEntities.clear();
        for (int i = 0; i < teList.func_74745_c(); ++i) {
            NBTTagCompound tc = teList.func_150305_b(i);
            TileEntity te = TileEntity.func_145827_c((NBTTagCompound)tc);
            if (te == null) continue;
            te.func_145834_a((World)this);
            this.tileEntities.add(te);
        }
        this.entities.clear();
        NBTTagList entList = tag.func_150295_c(ENTITY_LIST, 10);
        for (int i = 0; i < entList.func_74745_c(); ++i) {
            NBTTagCompound tc = entList.func_150305_b(i);
            Entity e = EntityList.func_75615_a((NBTTagCompound)tc, (World)this);
            if (e == null) continue;
            e.field_70170_p = this;
            this.entities.add(e);
        }
        this.diagonal = tag.func_74762_e(DIAGONAL);
    }

    void writeToTag(NBTTagCompound tag) {
        this.orig.writeToNBT(ORIG_ENT_POS, tag);
        tag.func_74783_a(BLOCK_IDS, this.blockIds);
        tag.func_74783_a(BLOCK_METADATA, this.blockMetadatas);
        NBTTagList teList = new NBTTagList();
        for (TileEntity te : this.tileEntities) {
            NBTTagCompound tc = new NBTTagCompound();
            te.func_145841_b(tc);
            teList.func_74742_a((NBTBase)tc);
        }
        tag.func_74782_a(TE_LIST, (NBTBase)teList);
        NBTTagList entList = new NBTTagList();
        for (Entity ent : this.entities) {
            NBTTagCompound tc = new NBTTagCompound();
            ent.func_70039_c(tc);
            entList.func_74742_a((NBTBase)tc);
        }
        tag.func_74782_a(ENTITY_LIST, (NBTBase)entList);
        tag.func_74768_a(DIAGONAL, this.diagonal);
    }

    protected boolean func_72916_c(int chunkX, int chunkZ) {
        return chunkX == 0 && chunkZ == 0;
    }

    private int getIndex(int x, int y, int z) {
        if (x < 0 || y < 0 || z < 0) {
            return -1;
        }
        if (x > 15 || y > 15 || z > 15) {
            return -1;
        }
        return x + (y << 4) + (z << 8);
    }

    public Block func_147439_a(int x, int y, int z) {
        int i = this.getIndex(x, y, z);
        if (i == -1) {
            return Blocks.field_150350_a;
        }
        int id = this.blockIds[i];
        if (id == -10) {
            return Core.registry.factory_block;
        }
        if (id == -11) {
            return Core.registry.resource_block;
        }
        if (id == -12) {
            return Core.registry.dark_iron_ore;
        }
        return FzUtil.getBlock(id);
    }

    public int func_72805_g(int x, int y, int z) {
        int i = this.getIndex(x, y, z);
        if (i == -1) {
            return 0;
        }
        return this.blockMetadatas[i];
    }

    public TileEntity func_147438_o(int x, int y, int z) {
        for (TileEntity te : this.tileEntities) {
            if (te.field_145851_c != x || te.field_145848_d != y || te.field_145849_e != z) continue;
            return te;
        }
        return null;
    }

    public int func_72957_l(int par1, int par2, int par3) {
        return 15;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_72925_a(EnumSkyBlock par1EnumSkyBlock, int par2, int par3, int par4) {
        return 15;
    }

    void setIdMdTe(DeltaCoord dc, Block block, int md, TileEntity te) {
        int i = this.getIndex(dc.x, dc.y, dc.z);
        if (i == -1) {
            return;
        }
        int useId = FzUtil.getId(block);
        if (block == Core.registry.factory_block) {
            useId = -10;
        } else if (block == Core.registry.resource_block) {
            useId = -11;
        } else if (block == Core.registry.dark_iron_ore) {
            useId = -12;
        }
        this.blockIds[i] = useId;
        this.blockMetadatas[i] = md;
        if (te == null) {
            return;
        }
        TileEntity clone = FzUtil.cloneTileEntity(te);
        clone.field_145851_c = dc.x;
        clone.field_145848_d = dc.y;
        clone.field_145849_e = dc.z;
        this.tileEntities.add(clone);
    }

    void addEntity(Entity ent) {
        if (ent == null) {
            return;
        }
        this.entities.add(ent);
    }

    public Chunk func_72964_e(int chunkX, int chunkZ) {
        if (chunkX != 0 || chunkZ != 0) {
            return super.func_72964_e(chunkX, chunkZ);
        }
        return this.myChunk;
    }
}

