/*
 * Decompiled with CFR 0.152.
 */
package factorization.common;

import factorization.shared.Core;
import factorization.weird.ContainerPocket;
import java.util.HashMap;
import net.minecraft.entity.player.EntityPlayer;

public enum Command {
    craftClear(2, true),
    craftSwirl(3, true),
    craftBalance(4, true),
    craftOpen(5, true),
    craftFill(11, true);

    public byte id;
    boolean executeLocally = false;
    public Command reverse = this;

    private Command(int id) {
        this.id = (byte)id;
        name.map.put(this.id, this);
    }

    private Command(int id, boolean executeLocally) {
        this(id);
        this.executeLocally = executeLocally;
    }

    void setReverse(Command rev) {
        rev.reverse = this;
        this.reverse = rev;
    }

    public static void fromNetwork(EntityPlayer player, byte s, byte arg) {
        Command c = name.map.get(s);
        if (c == null) {
            Core.logWarning("Received invalid command #" + s, new Object[0]);
            return;
        }
        c.call(player, arg);
    }

    public void call(EntityPlayer player) {
        this.call(player, (byte)0);
    }

    public void call(EntityPlayer player, byte arg) {
        if (player == null) {
            return;
        }
        if (player.field_70170_p.field_72995_K) {
            Core.network.sendCommand(player, this, arg);
            if (!this.executeLocally) {
                return;
            }
        }
        switch (this) {
            case craftClear: 
            case craftSwirl: 
            case craftBalance: 
            case craftFill: {
                if (!(player.field_71070_bA instanceof ContainerPocket)) break;
                ((ContainerPocket)player.field_71070_bA).executeCommand(this, arg);
                break;
            }
            case craftOpen: {
                Core.registry.pocket_table.tryOpen(player);
                break;
            }
            default: {
                Core.logWarning("Command " + (Object)((Object)this) + " is missing handler", new Object[0]);
            }
        }
    }

    static class name {
        static HashMap<Byte, Command> map = new HashMap();

        name() {
        }
    }
}

