/*
 * Decompiled with CFR 0.152.
 */
package factorization.charge;

import factorization.api.Charge;
import factorization.api.Coord;
import factorization.api.IChargeConductor;
import factorization.api.IMeterInfo;
import factorization.notify.MessageUpdater;
import factorization.notify.Notify;
import factorization.shared.Core;
import factorization.shared.FzUtil;
import factorization.shared.ItemFactorization;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.StringUtils;
import net.minecraft.world.World;

public class ItemChargeMeter
extends ItemFactorization {
    public ItemChargeMeter() {
        super("tool/charge_meter", Core.TabType.TOOLS);
        this.func_77625_d(1);
    }

    public boolean func_77648_a(ItemStack par1ItemStack, EntityPlayer par2EntityPlayer, World par3World, int par4, int par5, int par6, int par7, float par8, float par9, float par10) {
        return this.tryPlaceIntoWorld(par1ItemStack, par2EntityPlayer, par3World, par4, par5, par6, par7, par8, par9, par10);
    }

    public boolean tryPlaceIntoWorld(ItemStack is, final EntityPlayer player, World w, int x, int y, int z, int side, float vecx, float vecy, float vecz) {
        if (w.field_72995_K) {
            return true;
        }
        Coord here = new Coord(w, x, y, z);
        final TileEntity te = here.getTE();
        if (te == null) {
            return false;
        }
        final IChargeConductor ic = here.getTE(IChargeConductor.class);
        if (ic == null) {
            final IMeterInfo im = here.getTE(IMeterInfo.class);
            if (im == null) {
                return false;
            }
            Notify.recuring(player, te, new MessageUpdater(){
                String origInfo = null;

                @Override
                public boolean update(boolean firstMessage) {
                    String info = im.getInfo();
                    if (FzUtil.stringsEqual(info, this.origInfo)) {
                        return true;
                    }
                    this.origInfo = info;
                    if (!firstMessage) {
                        Notify.withStyle(Notify.Style.UPDATE);
                    }
                    Notify.send(player, (Object)te, "%s", info);
                    return true;
                }
            });
            return true;
        }
        Notify.recuring(player, te, new MessageUpdater(){
            String lastMessage = null;

            @Override
            public boolean update(boolean firstMessage) {
                Charge.ChargeDensityReading ret = Charge.getChargeDensity(ic);
                float density = (float)ret.totalCharge / (float)ret.conductorCount;
                String d = String.format("%.1f", Float.valueOf(density));
                String inf = ic.getInfo();
                inf = inf == null || inf.length() == 0 ? "" : "\n" + inf;
                EntityPlayer toNotify = player;
                if (player.getClass() != EntityPlayerMP.class || StringUtils.func_151246_b((String)player.func_70005_c_()) || player.func_70005_c_().startsWith("[")) {
                    toNotify = null;
                }
                String msg = Core.dev_environ ? "Charge: " + ic.getCharge().getValue() + "/" + ret.totalCharge + "\nConductors: " + ret.conductorCount : "Charge: " + ic.getCharge().getValue();
                if (FzUtil.stringsEqual(this.lastMessage, msg = msg + inf)) {
                    return true;
                }
                if (!firstMessage) {
                    Notify.withStyle(Notify.Style.UPDATE);
                }
                this.lastMessage = msg;
                Notify.send(player, (Object)ic, "%s", msg, "");
                return true;
            }
        });
        return true;
    }
}

