/*
 * Decompiled with CFR 0.152.
 */
package factorization.weird;

import factorization.api.Quaternion;
import factorization.common.BlockIcons;
import factorization.common.FactoryType;
import factorization.shared.BlockRenderHelper;
import factorization.shared.Core;
import factorization.shared.FactorizationBlockRender;
import factorization.weird.TileEntityDayBarrel;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.opengl.GL11;

public class BlockRenderDayBarrel
extends FactorizationBlockRender {
    @Override
    public boolean render(RenderBlocks rb) {
        if (this.world_mode) {
            this.doRender(rb, 0);
            return true;
        }
        if (!this.world_mode) {
            this.doRender(rb, 0);
            GL11.glPushAttrib((int)16384);
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
            this.doRender(rb, 1);
            GL11.glPopAttrib();
        }
        return false;
    }

    @Override
    public boolean renderSecondPass(RenderBlocks rb) {
        this.doRender(rb, 1);
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void doRender(RenderBlocks rb, int pass) {
        TileEntityDayBarrel barrel;
        BlockRenderHelper block = Core.registry.blockRender;
        if (this.world_mode) {
            if (!(this.te instanceof TileEntityDayBarrel)) return;
            barrel = (TileEntityDayBarrel)this.te;
        } else {
            barrel = (TileEntityDayBarrel)FactoryType.DAYBARREL.getRepresentative();
            barrel.loadFromStack(this.is);
        }
        if (pass == 0) {
            for (int i = 0; i < 6; ++i) {
                block.setTexture(i, barrel.getIcon(ForgeDirection.getOrientation((int)i)));
            }
        } else {
            BlockIcons.BarrelTextureset set;
            switch (barrel.type) {
                case HOPPING: {
                    set = BlockIcons.hopping;
                    break;
                }
                case SILKY: {
                    set = BlockIcons.silky;
                    break;
                }
                case STICKY: {
                    set = BlockIcons.sticky;
                    break;
                }
                default: {
                    set = BlockIcons.normal;
                }
            }
            block.useTexture(set.side);
            block.setTexture(0, set.top);
            block.setTexture(1, set.top);
            block.setTexture(4, set.front);
        }
        float blockOffset = pass == 0 ? 0.0f : -0.001953125f;
        block.setBlockBoundsOffset(blockOffset, blockOffset, blockOffset);
        if (this.world_mode) {
            Tessellator.field_78398_a.func_78380_c(block.func_149677_c(this.w, this.x, this.y, this.z));
            Quaternion q = Quaternion.fromOrientation(barrel.orientation.getSwapped());
            block.beginWithMirroredUVs();
            block.rotateMiddle(q);
            block.renderRotated(Tessellator.field_78398_a, this.x, this.y, this.z);
            return;
        } else {
            block.renderForInventory(rb);
            float d = 0.015625f;
            block.setBlockBoundsOffset(0.015625f, 0.0f, 0.015625f);
        }
    }

    @Override
    public FactoryType getFactoryType() {
        return FactoryType.DAYBARREL;
    }
}

