/*
 * Decompiled with CFR 0.152.
 */
package factorization.sockets;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import factorization.api.Coord;
import factorization.api.FzOrientation;
import factorization.api.IChargeConductor;
import factorization.api.datahelpers.DataInNBT;
import factorization.api.datahelpers.DataInPacket;
import factorization.api.datahelpers.DataInPacketClientEdited;
import factorization.api.datahelpers.DataOutNBT;
import factorization.api.datahelpers.DataOutPacket;
import factorization.api.datahelpers.IDataSerializable;
import factorization.common.BlockIcons;
import factorization.common.FactoryType;
import factorization.notify.Notify;
import factorization.servo.LoggerDataHelper;
import factorization.servo.RenderServoMotor;
import factorization.servo.ServoMotor;
import factorization.shared.BlockClass;
import factorization.shared.Core;
import factorization.shared.FzNetDispatch;
import factorization.shared.FzUtil;
import factorization.shared.NetworkFactorization;
import factorization.shared.Sound;
import factorization.shared.TileEntityCommon;
import factorization.sockets.GuiDataConfig;
import factorization.sockets.ISocketHolder;
import factorization.sockets.SocketEmpty;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.opengl.GL11;

public abstract class TileEntitySocketBase
extends TileEntityCommon
implements ISocketHolder,
IDataSerializable {
    public ForgeDirection facing = ForgeDirection.UP;
    private static final Vec3 nullVec = Vec3.func_72443_a((double)0.0, (double)0.0, (double)0.0);
    private static float[] pitch = new float[]{-90.0f, 90.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f};
    private static float[] yaw = new float[]{0.0f, 0.0f, 180.0f, 0.0f, 90.0f, -90.0f, 0.0f};

    @Override
    public final BlockClass getBlockClass() {
        return BlockClass.Socket;
    }

    @Override
    public final byte getExtraInfo() {
        return (byte)this.facing.ordinal();
    }

    @Override
    public final void useExtraInfo(byte b) {
        this.facing = ForgeDirection.getOrientation((int)b);
    }

    @Override
    public void onPlacedBy(EntityPlayer player, ItemStack is, int side) {
        super.onPlacedBy(player, is, side);
        this.facing = ForgeDirection.getOrientation((int)side);
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.facing = ForgeDirection.getOrientation((int)tag.func_74771_c("fc"));
        try {
            this.serialize("", new DataInNBT(tag));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound tag) {
        super.func_145841_b(tag);
        tag.func_74774_a("fc", (byte)this.facing.ordinal());
        try {
            this.serialize("", new DataOutNBT(tag));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public boolean sanitize(ServoMotor motor) {
        LoggerDataHelper dh = new LoggerDataHelper(motor);
        try {
            this.serialize("", dh);
        }
        catch (IOException e) {
            e.printStackTrace();
            return true;
        }
        return dh.hadError;
    }

    protected Iterable<Entity> getEntities(ISocketHolder socket, Coord c, ForgeDirection top, int d) {
        Entity ent = null;
        if (socket instanceof Entity) {
            ent = (Entity)socket;
        }
        int one = 1;
        AxisAlignedBB ab = AxisAlignedBB.func_72332_a().func_72299_a((double)(c.x + top.offsetX), (double)(c.y + top.offsetY), (double)(c.z + top.offsetZ), (double)(c.x + one + top.offsetX), (double)(c.y + one + top.offsetY), (double)(c.z + one + top.offsetZ));
        if (d != 0) {
            ab.field_72340_a -= (double)d;
            ab.field_72338_b -= (double)d;
            ab.field_72339_c -= (double)d;
            ab.field_72336_d += (double)d;
            ab.field_72337_e += (double)d;
            ab.field_72334_f += (double)d;
            if (top.offsetX + top.offsetY + top.offsetZ > 1) {
                ab.field_72340_a += (double)(d * top.offsetX);
                ab.field_72338_b += (double)(d * top.offsetY);
                ab.field_72339_c += (double)(d * top.offsetZ);
            } else {
                ab.field_72336_d -= (double)(d * top.offsetX);
                ab.field_72337_e -= (double)(d * top.offsetY);
                ab.field_72334_f -= (double)(d * top.offsetZ);
            }
        }
        return this.field_145850_b.func_72839_b(ent, ab);
    }

    protected final boolean rayTrace(ISocketHolder socket, Coord coord, FzOrientation orientation, boolean powered, boolean lookAround, boolean onlyFirst) {
        ForgeDirection top = orientation.top;
        ForgeDirection face = orientation.facing;
        ForgeDirection right = face.getRotation(top);
        for (Entity entity : this.getEntities(socket, coord, top, 0)) {
            if (entity == socket || !this.handleRay(socket, new MovingObjectPosition(entity), false, powered)) continue;
            return true;
        }
        TileEntitySocketBase.nullVec.field_72449_c = 0.0;
        TileEntitySocketBase.nullVec.field_72448_b = 0.0;
        TileEntitySocketBase.nullVec.field_72450_a = 0.0;
        Coord targetBlock = coord.add(top);
        if (this.mopBlock(targetBlock, top.getOpposite(), socket, false, powered)) {
            return true;
        }
        if (onlyFirst) {
            return false;
        }
        if (this.mopBlock(targetBlock.add(top), top.getOpposite(), socket, false, powered)) {
            return true;
        }
        if (this.mopBlock(coord, top, socket, true, powered)) {
            return true;
        }
        if (!lookAround) {
            return false;
        }
        if (this.mopBlock(targetBlock.add(face), face.getOpposite(), socket, false, powered)) {
            return true;
        }
        if (this.mopBlock(targetBlock.add(face.getOpposite()), face, socket, false, powered)) {
            return true;
        }
        if (this.mopBlock(targetBlock.add(right), right.getOpposite(), socket, false, powered)) {
            return true;
        }
        return this.mopBlock(targetBlock.add(right.getOpposite()), right, socket, false, powered);
    }

    boolean mopBlock(Coord target, ForgeDirection side, ISocketHolder socket, boolean mopIsThis, boolean powered) {
        TileEntitySocketBase.nullVec.field_72450_a = this.field_145851_c + side.offsetX;
        TileEntitySocketBase.nullVec.field_72448_b = this.field_145848_d + side.offsetY;
        TileEntitySocketBase.nullVec.field_72449_c = this.field_145849_e + side.offsetZ;
        return this.handleRay(socket, target.createMop(side, nullVec), mopIsThis, powered);
    }

    @Override
    public final ForgeDirection[] getValidRotations() {
        return full_rotation_array;
    }

    @Override
    public final boolean rotate(ForgeDirection axis) {
        if (this.getClass() != SocketEmpty.class) {
            return false;
        }
        if (axis == this.facing) {
            return false;
        }
        this.facing = axis;
        return true;
    }

    @Override
    public boolean isBlockSolidOnSide(int side) {
        return side == this.facing.getOpposite().ordinal();
    }

    @Override
    public final void sendMessage(NetworkFactorization.MessageType msgType, Object ... msg) {
        this.broadcastMessage(null, msgType, msg);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(ForgeDirection dir) {
        if (dir == this.facing || dir.getOpposite() == this.facing) {
            return BlockIcons.socket$face;
        }
        return BlockIcons.socket$side;
    }

    protected boolean isBlockPowered() {
        return this.field_145850_b.func_72864_z(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    @Override
    public boolean dumpBuffer(List<ItemStack> buffer) {
        if (buffer.size() == 0) {
            return false;
        }
        ItemStack is = buffer.get(0);
        if (is == null) {
            buffer.remove(0);
            return true;
        }
        Coord here = this.getCoord();
        here.adjust(this.facing.getOpposite());
        IInventory invTe = here.getTE(IInventory.class);
        if (invTe == null) {
            return true;
        }
        FzUtil.FzInv inv = FzUtil.openInventory(invTe, this.facing);
        if (inv == null) {
            return true;
        }
        int origSize = is.field_77994_a;
        int newSize = 0;
        if (inv.push(is) == null) {
            buffer.remove(0);
        } else {
            newSize = is.field_77994_a;
        }
        if (origSize != newSize) {
            this.func_70296_d();
        }
        return !buffer.isEmpty();
    }

    public void func_145845_h() {
        this.genericUpdate(this, this.getCoord(), this.isBlockPowered());
    }

    @Override
    protected void onRemove() {
        super.onRemove();
        this.uninstall();
        FactoryType ft = this.getFactoryType();
        Coord at = this.getCoord();
        while (ft != null) {
            TileEntitySocketBase sb = (TileEntitySocketBase)ft.getRepresentative();
            ItemStack is = sb.getCreatingItem();
            if (is != null) {
                at.spawnItem(ItemStack.func_77944_b((ItemStack)is));
            }
            ft = sb.getParentFactoryType();
        }
    }

    @Override
    public ItemStack getPickedBlock() {
        if (this instanceof SocketEmpty) {
            return FactoryType.SOCKET_EMPTY.itemStack();
        }
        ItemStack is = this.getCreatingItem();
        return is == null ? null : ItemStack.func_77944_b((ItemStack)is);
    }

    @Override
    public ItemStack getDroppedBlock() {
        return FactoryType.SOCKET_EMPTY.itemStack();
    }

    protected EntityPlayer getFakePlayer() {
        int i;
        EntityPlayer player = FzUtil.makePlayer(this.getCoord(), "socket");
        player.field_70170_p = this.field_145850_b;
        player.field_70169_q = player.field_70165_t = (double)this.field_145851_c + 0.5 + (double)this.facing.offsetX;
        player.field_70167_r = player.field_70163_u = (double)this.field_145848_d + 0.5 - (double)player.func_70047_e() + (double)this.facing.offsetY;
        player.field_70166_s = player.field_70161_v = (double)this.field_145849_e + 0.5 + (double)this.facing.offsetZ;
        for (i = 0; i < player.field_71071_by.field_70462_a.length; ++i) {
            player.field_71071_by.field_70462_a[i] = null;
        }
        i = this.facing.ordinal();
        player.field_70125_A = player.field_70127_C = pitch[i];
        player.field_70177_z = player.field_70126_B = yaw[i];
        player.field_70721_aZ = 0.0f;
        return player;
    }

    protected IInventory getBackingInventory(ISocketHolder socket) {
        if (socket == this) {
            TileEntity te = this.field_145850_b.func_147438_o(this.field_145851_c - this.facing.offsetX, this.field_145848_d - this.facing.offsetY, this.field_145849_e - this.facing.offsetZ);
            if (te instanceof IInventory) {
                return (IInventory)te;
            }
            return null;
        }
        if (socket instanceof IInventory) {
            return (IInventory)socket;
        }
        return null;
    }

    @Override
    public boolean extractCharge(int amount) {
        if (this instanceof IChargeConductor) {
            IChargeConductor cc = (IChargeConductor)((Object)this);
            return cc.getCharge().tryTake(amount) >= amount;
        }
        return false;
    }

    public void genericUpdate(ISocketHolder socket, Coord coord, boolean powered) {
    }

    @Override
    public abstract FactoryType getFactoryType();

    public abstract ItemStack getCreatingItem();

    public abstract FactoryType getParentFactoryType();

    public abstract boolean canUpdate();

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean handleMessageFromServer(NetworkFactorization.MessageType messageType, DataInput input) throws IOException {
        if (super.handleMessageFromServer(messageType, input)) {
            return true;
        }
        if (messageType == NetworkFactorization.MessageType.OpenDataHelperGui) {
            if (!this.field_145850_b.field_72995_K) {
                return false;
            }
            DataInPacket dip = new DataInPacket(input, Side.CLIENT);
            this.serialize("", dip);
            Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiDataConfig(this));
            return true;
        }
        return false;
    }

    @Override
    public boolean handleMessageFromClient(NetworkFactorization.MessageType messageType, DataInput input) throws IOException {
        if (super.handleMessageFromClient(messageType, input)) {
            return true;
        }
        if (messageType == NetworkFactorization.MessageType.DataHelperEdit) {
            DataInPacketClientEdited di = new DataInPacketClientEdited(input);
            this.serialize("", di);
            this.func_70296_d();
            return true;
        }
        return false;
    }

    public boolean handleRay(ISocketHolder socket, MovingObjectPosition mop, boolean mopIsThis, boolean powered) {
        return true;
    }

    public void uninstall() {
    }

    @Override
    public boolean activate(EntityPlayer player, ForgeDirection side) {
        ItemStack held = player.func_70694_bm();
        if (held != null && held.func_77973_b() == Core.registry.logicMatrixProgrammer) {
            if (!this.getFactoryType().hasGui) {
                if (this.getClass() == SocketEmpty.class) {
                    this.facing = (ForgeDirection)FzUtil.shiftEnum((Enum)this.facing, (Enum[])ForgeDirection.VALID_DIRECTIONS, (int)1);
                    if (this.field_145850_b.field_72995_K) {
                        new Coord(this).redraw();
                    }
                    return true;
                }
                return false;
            }
            if (this.field_145850_b.field_72995_K) {
                return true;
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(baos);
            DataOutPacket dop = new DataOutPacket(dos, Side.SERVER);
            try {
                Coord coord = this.getCoord();
                Core.network.prefixTePacket(dos, coord, NetworkFactorization.MessageType.OpenDataHelperGui);
                this.serialize("", dop);
                Core.network.broadcastPacket(player, coord, FzNetDispatch.generate(baos));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return false;
        }
        if (held != null) {
            boolean isValidItem = false;
            for (FactoryType ft : FactoryType.values()) {
                TileEntitySocketBase rep;
                ItemStack creator;
                TileEntityCommon tec = ft.getRepresentative();
                if (tec == null || !(tec instanceof TileEntitySocketBase) || (creator = (rep = (TileEntitySocketBase)tec).getCreatingItem()) == null || !FzUtil.couldMerge(held, creator)) continue;
                isValidItem = true;
                if (this.field_145850_b.field_72995_K) break;
                if (rep.getParentFactoryType() != this.getFactoryType()) {
                    rep.mentionPrereq(this);
                    return false;
                }
                TileEntityCommon upgrade = ft.makeTileEntity();
                if (upgrade == null) continue;
                this.replaceWith((TileEntitySocketBase)upgrade, this);
                if (!player.field_71075_bZ.field_75098_d) {
                    --held.field_77994_a;
                }
                Sound.socketInstall.playAt(this);
                return true;
            }
            if (isValidItem) {
                return false;
            }
        }
        return false;
    }

    public void mentionPrereq(ISocketHolder holder) {
        FactoryType pft = this.getParentFactoryType();
        if (pft == null) {
            return;
        }
        TileEntityCommon tec = pft.getRepresentative();
        if (!(tec instanceof TileEntitySocketBase)) {
            return;
        }
        ItemStack is = ((TileEntitySocketBase)tec).getCreatingItem();
        if (is == null) {
            return;
        }
        Notify.withItem(is);
        String msg = "Needs {ITEM_NAME}";
        if (holder instanceof Entity) {
            Notify.send((Entity)holder, msg, new String[0]);
        } else {
            Notify.send((TileEntity)holder, msg, new String[0]);
        }
    }

    protected void replaceWith(TileEntitySocketBase replacement, ISocketHolder socket) {
        this.func_145843_s();
        replacement.facing = this.facing;
        if (socket == this) {
            Coord at = this.getCoord();
            at.setTE(replacement);
            replacement.getBlockClass().enforce(at);
            at.markBlockForUpdate();
            Core.network.broadcastPacket(null, at, replacement.getDescriptionPacket());
        } else if (socket instanceof ServoMotor) {
            ServoMotor motor = (ServoMotor)socket;
            motor.socket = replacement;
            motor.syncWithSpawnPacket();
        }
    }

    public boolean activateOnServo(EntityPlayer player, ServoMotor motor) {
        if (this.func_145831_w() == null || this.func_145831_w().field_72995_K) {
            return false;
        }
        ItemStack held = player.func_70694_bm();
        if (held == null) {
            return false;
        }
        if (held.func_77973_b() != Core.registry.logicMatrixProgrammer) {
            return false;
        }
        if (!this.getFactoryType().hasGui) {
            return false;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        DataOutPacket dop = new DataOutPacket(dos, Side.SERVER);
        try {
            Coord coord = this.getCoord();
            Core.network.prefixEntityPacket(dos, motor, NetworkFactorization.MessageType.OpenDataHelperGuiOnEntity);
            this.serialize("", dop);
            Core.network.broadcastPacket(player, coord, Core.network.entityPacket(baos));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return false;
    }

    public void onEnterNewBlock() {
    }

    @SideOnly(value=Side.CLIENT)
    public void renderTesr(ServoMotor motor, float partial) {
    }

    @SideOnly(value=Side.CLIENT)
    public void renderStatic(ServoMotor motor, Tessellator tess) {
    }

    @SideOnly(value=Side.CLIENT)
    public void renderInServo(ServoMotor motor, float partial) {
        float s = 0.75f;
        GL11.glScalef((float)s, (float)s, (float)s);
        float d = -0.5f;
        float y = -0.125f;
        GL11.glTranslatef((float)d, (float)y, (float)d);
        GL11.glDisable((int)2896);
        GL11.glPushMatrix();
        this.renderTesr(motor, partial);
        GL11.glPopMatrix();
        Tessellator tess = Tessellator.field_78398_a;
        tess.func_78382_b();
        this.renderStatic(motor, tess);
        tess.func_78381_a();
        GL11.glTranslatef((float)(-d), (float)(-y), (float)(-d));
        GL11.glEnable((int)2896);
    }

    @SideOnly(value=Side.CLIENT)
    public void renderItemOnServo(RenderServoMotor render, ServoMotor motor, ItemStack is, float partial) {
        GL11.glPushMatrix();
        GL11.glTranslatef((float)0.40625f, (float)0.28125f, (float)0.0f);
        GL11.glRotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        render.renderItem(is);
        GL11.glPopMatrix();
    }

    public void installedOnServo(ServoMotor servoMotor) {
    }
}

