/*
 * Decompiled with CFR 0.152.
 */
package factorization.sockets;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import factorization.api.FzOrientation;
import factorization.api.Quaternion;
import factorization.api.datahelpers.DataHelper;
import factorization.api.datahelpers.IDataSerializable;
import factorization.common.BlockIcons;
import factorization.common.FactoryType;
import factorization.servo.ServoMotor;
import factorization.shared.BlockRenderHelper;
import factorization.shared.Core;
import factorization.sockets.TileEntitySocketBase;
import java.io.IOException;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;

public class SocketBareMotor
extends TileEntitySocketBase {
    @Override
    public IDataSerializable serialize(String prefix, DataHelper data) throws IOException {
        return this;
    }

    @Override
    public FactoryType getFactoryType() {
        return FactoryType.SOCKET_BARE_MOTOR;
    }

    @Override
    public boolean canUpdate() {
        return false;
    }

    @Override
    public ItemStack getCreatingItem() {
        return new ItemStack((Item)Core.registry.motor);
    }

    @Override
    public FactoryType getParentFactoryType() {
        return FactoryType.SOCKET_EMPTY;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderStatic(ServoMotor motor, Tessellator tess) {
        BlockRenderHelper block = BlockRenderHelper.instance;
        Quaternion rotation = Quaternion.fromOrientation(FzOrientation.fromDirection(this.facing.getOpposite()));
        IIcon metal = BlockIcons.motor_texture;
        float d = 0.25f;
        float yd = -d + 0.003f;
        block.useTextures(metal, null, metal, metal, metal, metal);
        float yoffset = 0.3125f;
        float sd = motor == null ? 0.0f : 0.125f;
        block.func_149676_a(d, d + yd + yoffset + 0.125f + sd, d, 1.0f - d, 1.0f - (d + 0.0f) + yd + yoffset, 1.0f - d);
        block.beginWithMirroredUVs();
        block.rotateCenter(rotation);
        block.renderRotated(tess, this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }
}

