/*
 * Decompiled with CFR 0.152.
 */
package factorization.shared;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Field;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.util.IIcon;

@SideOnly(value=Side.CLIENT)
public class FactorizationTextureLoader {
    public static void register(IIconRegister reg, Class base, Object instance, String base_prefix) {
        try {
            Field[] fields;
            for (Field f : fields = base.getFields()) {
                String prefix = base_prefix;
                if (f.getAnnotation(Ignore.class) != null) continue;
                Directory dir = f.getAnnotation(Directory.class);
                if (dir != null) {
                    prefix = prefix + dir.value() + "/";
                }
                if (IIconGroup.class.isAssignableFrom(f.getType())) {
                    IIconGroup ig = (IIconGroup)f.get(instance);
                    if (ig == null) {
                        ig = (IIconGroup)f.getType().newInstance();
                    }
                    ig.prefix(f.getName());
                    f.set(instance, ig);
                    FactorizationTextureLoader.register(reg, f.getType(), ig, prefix + ig.group_prefix);
                    ig.afterRegister();
                }
                if (!IIcon.class.isAssignableFrom(f.getType())) continue;
                String icon_file = prefix + f.getName();
                f.set(instance, reg.func_94245_a(icon_file.replace('$', '/')));
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static abstract class IIconGroup {
        public String group_prefix;

        public IIconGroup prefix(String prefix) {
            this.group_prefix = prefix + "_";
            return this;
        }

        public void afterRegister() {
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface Ignore {
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface Directory {
        public String value();
    }
}

