/*
 * Decompiled with CFR 0.152.
 */
package factorization.shared;

import factorization.api.Coord;
import factorization.api.ICoord;
import factorization.api.VectorUV;
import factorization.charge.WireRenderingCube;
import factorization.common.BlockIcons;
import factorization.common.FactoryType;
import factorization.shared.BlockFactorization;
import factorization.shared.BlockRenderHelper;
import factorization.shared.Core;
import factorization.shared.ItemRenderCapture;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.opengl.GL11;

public abstract class FactorizationBlockRender
implements ICoord {
    public boolean world_mode;
    public boolean use_vertex_offset;
    public IBlockAccess w;
    public int x;
    public int y;
    public int z;
    public int metadata;
    public TileEntity te;
    public ItemStack is;
    public IItemRenderer.ItemRenderType renderType;
    private static FactorizationBlockRender[] renderMap = new FactorizationBlockRender[255];
    private static FactorizationBlockRender defaultRender;
    private static RenderBlocks rb;
    static float[] directionLighting;

    public static void setDefaultRender(FactoryType ft) {
        assert (defaultRender != null);
        FactorizationBlockRender.renderMap[ft.md] = defaultRender;
    }

    public static FactorizationBlockRender getRenderer(int md) {
        FactorizationBlockRender ret = renderMap[md];
        if (ret == null) {
            FactorizationBlockRender.renderMap[md] = defaultRender;
            Core.logFine("Using default renderer for ID " + md, new Object[0]);
            return defaultRender;
        }
        return ret;
    }

    public FactorizationBlockRender() {
        this.initialize(this.getFactoryType());
    }

    public FactorizationBlockRender(FactoryType ft) {
        this.initialize(ft);
    }

    private void initialize(FactoryType ft) {
        if (ft != null) {
            int md = ft.md;
            if (renderMap[md] != null) {
                throw new RuntimeException("Tried to overwrite a renderer");
            }
            FactorizationBlockRender.renderMap[md] = this;
        } else {
            if (defaultRender != null) {
                throw new RuntimeException("Tried to overwrite a renderer");
            }
            defaultRender = this;
        }
    }

    public abstract boolean render(RenderBlocks var1);

    public abstract FactoryType getFactoryType();

    public boolean renderSecondPass(RenderBlocks rb) {
        return false;
    }

    @Override
    public Coord getCoord() {
        if (!this.world_mode) {
            if (this.te != null) {
                return new Coord(this.te);
            }
            return null;
        }
        if (this.te != null && this.te.func_145831_w() != null) {
            return new Coord(this.te);
        }
        return new Coord((World)Minecraft.func_71410_x().field_71441_e, this.x, this.y, this.z);
    }

    public final void renderInWorld(IBlockAccess w, int wx, int wy, int wz, int md, TileEntity te) {
        this.world_mode = true;
        this.w = w;
        this.x = wx;
        this.y = wy;
        this.z = wz;
        this.use_vertex_offset = true;
        this.metadata = md;
        this.te = te;
    }

    public final void renderInInventory() {
        this.world_mode = false;
        this.z = 0;
        this.y = 0;
        this.x = 0;
        this.use_vertex_offset = true;
        this.te = null;
        this.is = ItemRenderCapture.getRenderingItem();
        this.renderType = ItemRenderCapture.getRenderType();
    }

    public final void setTileEntity(TileEntity t) {
        this.te = t;
    }

    public final void clearWorldReferences() {
        this.te = null;
        this.w = null;
        this.z = 0;
        this.y = 0;
        this.x = 0;
    }

    public final void setMetadata(int md) {
        this.metadata = md;
    }

    protected void renderNormalBlock(RenderBlocks rb, int md) {
        BlockFactorization b = Core.registry.factory_rendering_block;
        rb.func_147782_a(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
        if (this.world_mode) {
            rb.func_147784_q((Block)b, this.x, this.y, this.z);
        } else {
            Core.registry.factory_rendering_block.fake_normal_render = true;
            rb.func_147800_a((Block)b, md, 1.0f);
            Core.registry.factory_rendering_block.fake_normal_render = false;
        }
    }

    protected void renderCauldron(RenderBlocks rb, IIcon lid, IIcon metal) {
        this.renderCauldron(rb, lid, metal, 1.0f);
    }

    protected void renderCauldron(RenderBlocks rb, IIcon lid, IIcon metal, float height) {
        Tessellator tessellator = Tessellator.field_78398_a;
        BlockRenderHelper block = BlockRenderHelper.instance;
        block.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, height, 1.0f);
        block.useTextures(metal, lid, metal, metal, metal, metal);
        if (this.world_mode) {
            block.render(rb, this.getCoord());
            float d = 0.125f;
            boolean origAO = rb.field_147863_w;
            rb.func_147782_a((double)d, (double)d, (double)d, (double)(1.0f - d), (double)height, (double)(1.0f - d));
            block.func_149676_a(d, d, d, 1.0f - d, 1.0f - d, 1.0f - d);
            rb.field_147863_w = false;
            rb.func_147798_e((Block)block, (double)((float)(this.x + 1) - 2.0f * d), (double)this.y, (double)this.z, metal);
            rb.func_147761_c((Block)block, (double)this.x, (double)this.y, (double)((float)(this.z + 1) - 2.0f * d), metal);
            rb.func_147764_f((Block)block, (double)((float)(this.x - 1) + 2.0f * d), (double)this.y, (double)this.z, metal);
            rb.func_147734_d((Block)block, (double)this.x, (double)this.y, (double)((float)(this.z - 1) + 2.0f * d), metal);
            rb.func_147806_b((Block)block, (double)this.x, (double)((float)this.y - height + 1.0f * d), (double)this.z, metal);
            rb.field_147863_w = origAO;
        } else {
            GL11.glDisable((int)2884);
            block.renderForInventory(rb);
            GL11.glEnable((int)2884);
        }
    }

    protected void renderPart(RenderBlocks rb, IIcon texture, float b1, float b2, float b3, float b4, float b5, float b6) {
        BlockFactorization block = Core.registry.factory_rendering_block;
        rb.func_147782_a((double)b1, (double)b2, (double)b3, (double)b4, (double)b5, (double)b6);
        block.func_149676_a(b1, b2, b3, b4, b5, b6);
        if (this.world_mode) {
            BlockFactorization.force_texture = texture;
            rb.func_147784_q((Block)block, this.x, this.y, this.z);
            BlockFactorization.force_texture = null;
        } else {
            this.renderPartInvTexture(rb, (Block)block, texture);
        }
        rb.func_147782_a(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
        block.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
    }

    private void renderPartInvTexture(RenderBlocks renderblocks, Block block, IIcon texture) {
        Tessellator tessellator = Tessellator.field_78398_a;
        block.func_149683_g();
        GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
        tessellator.func_78382_b();
        tessellator.func_78375_b(0.0f, -1.0f, 0.0f);
        renderblocks.func_147768_a(block, 0.0, 0.0, 0.0, texture);
        tessellator.func_78375_b(0.0f, 1.0f, 0.0f);
        renderblocks.func_147806_b(block, 0.0, 0.0, 0.0, texture);
        tessellator.func_78375_b(0.0f, 0.0f, -1.0f);
        renderblocks.func_147761_c(block, 0.0, 0.0, 0.0, texture);
        tessellator.func_78375_b(0.0f, 0.0f, 1.0f);
        renderblocks.func_147734_d(block, 0.0, 0.0, 0.0, texture);
        tessellator.func_78375_b(-1.0f, 0.0f, 0.0f);
        renderblocks.func_147798_e(block, 0.0, 0.0, 0.0, texture);
        tessellator.func_78375_b(1.0f, 0.0f, 0.0f);
        renderblocks.func_147764_f(block, 0.0, 0.0, 0.0, texture);
        tessellator.func_78381_a();
        GL11.glTranslatef((float)0.5f, (float)0.5f, (float)0.5f);
    }

    private static ForgeDirection getFaceDirection(VectorUV[] vecs, VectorUV center) {
        VectorUV here = vecs[0].add(vecs[2]);
        here.scale(0.5);
        here = here.add(center);
        double x = Math.abs(here.x);
        double y = Math.abs(here.y);
        double z = Math.abs(here.z);
        if (x >= y && x >= z) {
            return here.x >= 0.0 ? ForgeDirection.WEST : ForgeDirection.EAST;
        }
        if (y >= x && y >= z) {
            return here.y >= 0.0 ? ForgeDirection.UP : ForgeDirection.DOWN;
        }
        if (z >= x && z >= y) {
            return here.z >= 0.0 ? ForgeDirection.SOUTH : ForgeDirection.NORTH;
        }
        return ForgeDirection.UP;
    }

    private static float getNormalizedLighting(VectorUV[] vecs, VectorUV center) {
        return directionLighting[FactorizationBlockRender.getFaceDirection(vecs, center).ordinal()];
    }

    private float interpolate(float a, float b, float scale) {
        return a * scale + b * (1.0f - scale);
    }

    protected void renderCube(WireRenderingCube rc) {
        if (!this.world_mode) {
            Tessellator.field_78398_a.func_78382_b();
            GL11.glDisable((int)2896);
        }
        float delta = 0.00390625f;
        double zfight = rc.corner.x * (double)delta;
        zfight *= rc.corner.y * (double)delta;
        zfight *= rc.corner.z * (double)delta;
        zfight = 1.0025f;
        for (int face = 0; face < 6; ++face) {
            VectorUV[] vecs = rc.faceVerts(face);
            float color = directionLighting[face];
            Tessellator.field_78398_a.func_78386_a(color, color, color);
            for (int i = 0; i < vecs.length; ++i) {
                VectorUV vec = vecs[i];
                this.vertex(rc, (float)(vec.x * zfight), (float)(vec.y * zfight), (float)(vec.z * zfight), (float)vec.u, (float)vec.v);
            }
        }
        if (!this.world_mode) {
            Tessellator.field_78398_a.func_78381_a();
            GL11.glEnable((int)2896);
        }
    }

    protected void vertex(WireRenderingCube rc, float x, float y, float z, float u, float v) {
        IIcon wire = BlockIcons.wire;
        Tessellator.field_78398_a.func_78374_a((double)this.x + 0.5 + (double)(x / 16.0f), (double)this.y + 0.5 + (double)(y / 16.0f), (double)this.z + 0.5 + (double)(z / 16.0f), (double)wire.func_94214_a((double)u), (double)wire.func_94207_b((double)v));
    }

    public static void renderItemIIcon(IIcon icon) {
        if (icon == null) {
            return;
        }
        TextureManager tex = Minecraft.func_71410_x().field_71446_o;
        tex.func_110577_a(tex.func_130087_a(1));
        Tessellator tessellator = Tessellator.field_78398_a;
        float f = icon.func_94209_e();
        float f1 = icon.func_94212_f();
        float f2 = icon.func_94206_g();
        float f3 = icon.func_94210_h();
        float f4 = 0.0f;
        float f5 = 0.3f;
        float f6 = 1.5f;
        ItemRenderer.func_78439_a((Tessellator)tessellator, (float)f1, (float)f2, (float)f, (float)f3, (int)icon.func_94211_a(), (int)icon.func_94216_b(), (float)0.0625f);
    }

    public void renderMotor(RenderBlocks rb, float yoffset) {
        IIcon metal = BlockIcons.motor_texture;
        float d = 0.25f;
        float yd = -d + 0.003f;
        this.renderPart(rb, metal, d, d + yd + yoffset, d, 1.0f - d, 1.0f - (d + 0.0f) + yd + yoffset, 1.0f - d);
    }

    protected void renderRotatedHelper(BlockRenderHelper block) {
        Tessellator tess = Tessellator.field_78398_a;
        if (this.world_mode) {
            block.renderRotated(tess, this.x, this.y, this.z);
        } else {
            tess.func_78382_b();
            block.renderRotated(tess, 0, 0, 0);
            tess.func_78381_a();
        }
    }

    protected void renderBlock(RenderBlocks rb, BlockRenderHelper block) {
        if (this.world_mode) {
            block.render(rb, this.x, this.y, this.z);
        } else {
            block.renderForInventory(rb);
        }
    }

    static {
        rb = new RenderBlocks();
        directionLighting = new float[]{0.5f, 1.0f, 0.8f, 0.8f, 0.6f, 0.6f};
    }
}

