/*
 * Decompiled with CFR 0.152.
 */
package factorization.shared;

import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBed;
import net.minecraft.block.BlockBrewingStand;
import net.minecraft.block.BlockCauldron;
import net.minecraft.block.BlockCocoa;
import net.minecraft.block.BlockCrops;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.BlockEndPortal;
import net.minecraft.block.BlockFarmland;
import net.minecraft.block.BlockFlowerPot;
import net.minecraft.block.BlockFurnace;
import net.minecraft.block.BlockHugeMushroom;
import net.minecraft.block.BlockMobSpawner;
import net.minecraft.block.BlockNetherWart;
import net.minecraft.block.BlockOre;
import net.minecraft.block.BlockPistonMoving;
import net.minecraft.block.BlockPortal;
import net.minecraft.block.BlockRedstoneComparator;
import net.minecraft.block.BlockRedstoneLight;
import net.minecraft.block.BlockRedstoneRepeater;
import net.minecraft.block.BlockRedstoneTorch;
import net.minecraft.block.BlockRedstoneWire;
import net.minecraft.block.BlockReed;
import net.minecraft.block.BlockSign;
import net.minecraft.block.BlockSilverfish;
import net.minecraft.block.BlockSkull;
import net.minecraft.block.BlockSlab;
import net.minecraft.block.BlockTripWire;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;

public class BlockHelper {
    static BlockStyle getBlockStyle(Block block) {
        return BlockHelper.classifyBlock(block);
    }

    private static BlockStyle classifyBlock(Block block) {
        if (block == Blocks.field_150414_aQ) {
            return BlockStyle.CAKE;
        }
        if (block == Blocks.field_150450_ax || block == Blocks.field_150439_ay) {
            return BlockStyle.REDSTONE_ORE;
        }
        if (block == Blocks.field_150326_M) {
            return BlockStyle.PISTON_EXTENSION;
        }
        if (block == Blocks.field_150394_bc || block == Blocks.field_150393_bb) {
            return BlockStyle.STEM;
        }
        if (block instanceof BlockSign || block instanceof BlockFlowerPot || block instanceof BlockRedstoneWire || block instanceof BlockBrewingStand || block instanceof BlockReed || block instanceof BlockTripWire || block instanceof BlockCauldron || block instanceof BlockRedstoneRepeater || block instanceof BlockRedstoneComparator || block instanceof BlockRedstoneTorch || block instanceof BlockFarmland || block instanceof BlockFurnace || block instanceof BlockHugeMushroom || block instanceof BlockRedstoneLight) {
            return BlockStyle.USE_ID_DROPPED;
        }
        if (block instanceof BlockCocoa || block instanceof BlockNetherWart || block instanceof BlockSkull) {
            return BlockStyle.USE_GET_BLOCK_DROPPED;
        }
        if (block instanceof BlockPistonMoving || block instanceof BlockPortal || block instanceof BlockEndPortal || block instanceof BlockSilverfish || block instanceof BlockMobSpawner) {
            return BlockStyle.NOTHING;
        }
        if (block instanceof BlockOre) {
            return BlockStyle.CLONE_MD;
        }
        if (block instanceof BlockSlab) {
            return BlockStyle.SLAB;
        }
        if (block instanceof BlockCrops) {
            return BlockStyle.CROP;
        }
        if (block instanceof BlockBed) {
            return BlockStyle.BED;
        }
        if (block instanceof BlockDoor) {
            return BlockStyle.DOOR;
        }
        return BlockStyle.USE_GET_DAMAGE_VALUE;
    }

    private static ItemStack makeItemStack(Item itemId, int stackSize, int damage) {
        if (itemId == null) {
            return null;
        }
        return new ItemStack(itemId, stackSize, damage);
    }

    public static ItemStack getPlacingItem(Block block, MovingObjectPosition target, World world, int x, int y, int z) {
        switch (BlockHelper.classifyBlock(block)) {
            default: {
                return null;
            }
            case USE_GET_DAMAGE_VALUE: {
                return new ItemStack(block, 1, block.func_149643_k(world, x, y, z));
            }
            case USE_ID_DROPPED: 
            case BED: {
                int md = world.func_72805_g(x, y, z);
                return BlockHelper.makeItemStack(block.func_149650_a(md, world.field_73012_v, 0), 1, 0);
            }
            case USE_GET_BLOCK_DROPPED: {
                int md = world.func_72805_g(x, y, z);
                ArrayList drops = block.getDrops(world, x, y, z, md, 0);
                if (drops.isEmpty()) {
                    return null;
                }
                return (ItemStack)drops.get(0);
            }
            case CLONE_MD: {
                int md = world.func_72805_g(x, y, z);
                return new ItemStack(block, 1, md);
            }
            case STEM: {
                if (block == Blocks.field_150393_bb) {
                    return new ItemStack(Items.field_151080_bb);
                }
                if (block == Blocks.field_150394_bc) {
                    return new ItemStack(Items.field_151081_bc);
                }
                return null;
            }
            case SLAB: {
                int md = world.func_72805_g(x, y, z);
                int dropped = block.func_149745_a(world.field_73012_v);
                return BlockHelper.makeItemStack(block.func_149650_a(md, world.field_73012_v, 0), dropped, block.func_149692_a(md));
            }
            case CAKE: {
                int md = world.func_72805_g(x, y, z);
                return md == 0 ? new ItemStack(Items.field_151105_aU) : null;
            }
            case CROP: {
                return new ItemStack(block.func_149650_a(0, world.field_73012_v, 0), 1, block.func_149643_k(world, x, y, z));
            }
            case DOOR: {
                int md = world.func_72805_g(x, y, z);
                Item doorId = block.func_149650_a(md, world.field_73012_v, 0);
                if (doorId == null) {
                    return null;
                }
                return new ItemStack(doorId, 1, 0);
            }
            case REDSTONE_ORE: 
        }
        return new ItemStack(Blocks.field_150450_ax);
    }

    public static enum BlockStyle {
        UNDECIDED,
        NOTHING,
        USE_GET_DAMAGE_VALUE,
        USE_ID_DROPPED,
        USE_GET_BLOCK_DROPPED,
        CLONE_MD,
        STEM,
        SLAB,
        CAKE,
        CROP,
        DOOR,
        REDSTONE_ORE,
        PISTON_EXTENSION,
        BED;

    }
}

