/*
 * Decompiled with CFR 0.152.
 */
package factorization.servo;

import factorization.api.Coord;
import factorization.api.datahelpers.DataHelper;
import factorization.api.datahelpers.Share;
import factorization.notify.Notify;
import factorization.servo.EntryAction;
import factorization.servo.Instruction;
import factorization.servo.ServoComponent;
import factorization.servo.ServoMotor;
import factorization.servo.ServoStack;
import factorization.servo.TileEntityServoRail;
import factorization.servo.instructions.IntegerValue;
import java.io.IOException;
import net.minecraft.nbt.NBTTagCompound;

public class Executioner {
    private final transient ServoMotor motor;
    public static final byte JMP_NONE = 0;
    public static final byte JMP_NEXT_INSTRUCTION = 1;
    public static final byte JMP_NEXT_TILE = 2;
    protected ServoStack argumentStack = new ServoStack(this);
    protected ServoStack pendingInstructions = new ServoStack(this);
    protected Instruction enterBlockInstruction = null;
    public byte jmp = 0;
    public boolean cpu_blocked = false;
    public EntryAction entry_action = EntryAction.ENTRY_EXECUTE;
    transient boolean stacks_changed = false;

    public Executioner(ServoMotor motor) {
        this.motor = motor;
    }

    public void tick() {
        if (this.cpu_blocked) {
            return;
        }
        boolean found_blocking_instruction = false;
        while (this.pendingInstructions.getSize() > 0) {
            Object obj = this.pendingInstructions.peek();
            if (!(obj instanceof Instruction)) {
                this.argumentStack.push(this.pendingInstructions.pop());
                continue;
            }
            Instruction insn = (Instruction)obj;
            switch (insn.getBlockingBehavior()) {
                case BLOCK_UNTIL_NEXT_ENTRY: {
                    this.cpu_blocked = true;
                }
                case BLOCK_FOR_TICK: {
                    if (found_blocking_instruction) {
                        return;
                    }
                    found_blocking_instruction = true;
                    break;
                }
            }
            this.pendingInstructions.pop();
            insn.motorHit(this.motor);
        }
    }

    public void onEnterNewBlock(TileEntityServoRail rail) {
        this.cpu_blocked = false;
        switch (this.entry_action) {
            default: {
                if (rail == null || rail.decoration == null) {
                    if (this.jmp == 2) {
                        this.jmp = 0;
                    }
                    return;
                }
                if (this.motor.getCurrentPos().isWeaklyPowered()) {
                    if (this.jmp == 2) {
                        this.jmp = 0;
                    }
                    return;
                }
                if (this.jmp != 0) {
                    this.jmp = 0;
                    return;
                }
                rail.decoration.motorHit(this.motor);
                break;
            }
            case ENTRY_LOAD: {
                if (!(rail.decoration instanceof Instruction)) break;
                this.argumentStack.push(rail.decoration.copyComponent());
                break;
            }
            case ENTRY_WRITE: {
                ServoStack ss = this.argumentStack;
                if (ss.getSize() == 0) {
                    this.motor.putError("IO stack is emtpy!");
                    break;
                }
                Object o = ss.pop();
                if (o instanceof Instruction) {
                    rail.decoration = (Instruction)((Instruction)o).copyComponent();
                    new Coord(rail).markBlockForUpdate();
                } else if (o instanceof Integer) {
                    int val = (Integer)o;
                    IntegerValue iv = new IntegerValue();
                    iv.setVal(val);
                    rail.decoration = iv;
                    new Coord(rail).markBlockForUpdate();
                } else {
                    this.motor.putError("Can't write " + o + ", sorry!");
                }
                if (ss.getSize() != 0) break;
                this.entry_action = EntryAction.ENTRY_IGNORE;
            }
            case ENTRY_IGNORE: 
        }
        if (this.enterBlockInstruction != null) {
            this.enterBlockInstruction.motorHit(this.motor);
        }
    }

    void putData(DataHelper data) throws IOException {
        this.argumentStack = data.as(Share.VISIBLE, "stack4").put(this.argumentStack);
        this.pendingInstructions = data.as(Share.VISIBLE, "pendingInstructions").put(this.pendingInstructions);
        if (data.isReader()) {
            NBTTagCompound tag = data.as(Share.VISIBLE, "onEntry").put(new NBTTagCompound());
            ServoComponent sc = ServoComponent.load(tag);
            if (sc instanceof Instruction) {
                this.enterBlockInstruction = (Instruction)sc;
            }
        } else {
            NBTTagCompound tag = new NBTTagCompound();
            if (this.enterBlockInstruction != null) {
                this.enterBlockInstruction.save(tag);
            }
            data.as(Share.VISIBLE, "onEntry").put(tag);
        }
        this.jmp = data.as(Share.VISIBLE, "jmp").putByte(this.jmp);
        this.cpu_blocked = data.as(Share.VISIBLE, "cpuBlock").putBoolean(this.cpu_blocked);
        this.entry_action = data.as(Share.VISIBLE, "entryAction").putEnum(this.entry_action);
    }

    public ServoStack getArgStack() {
        return this.argumentStack;
    }

    public ServoStack getInstructionStack() {
        return this.pendingInstructions;
    }

    public void putError(Object error) {
        if (!this.motor.field_70170_p.field_72995_K) {
            Notify.send(this.motor.getCurrentPos(), "%s", error.toString());
        }
    }

    public void markDirty() {
        this.stacks_changed = true;
    }
}

