/*
 * Decompiled with CFR 0.152.
 */
package factorization.notify;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import factorization.api.Coord;
import factorization.notify.Message;
import factorization.notify.Notify;
import factorization.notify.NotifyImplementation;
import factorization.notify.RenderMessagesProxy;
import java.util.ArrayList;
import java.util.Iterator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.Vec3;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import org.lwjgl.opengl.GL11;

public class RenderMessages
extends RenderMessagesProxy {
    static ArrayList<Message> messages = new ArrayList();
    RenderItem renderItem;

    public RenderMessages() {
        NotifyImplementation.loadBus(this);
        this.renderItem = new RenderItem();
    }

    @Override
    public void addMessage(Object locus, ItemStack item, String format, String ... args) {
        Vec3 testPos;
        EntityClientPlayerMP player = Minecraft.func_71410_x().field_71439_g;
        if (player == null || player.field_70170_p == null) {
            return;
        }
        Message msg = new Message(player.field_70170_p, locus, item, format, args);
        if (msg.style.contains((Object)Notify.Style.CLEAR)) {
            messages.clear();
            return;
        }
        if (msg.style.contains((Object)Notify.Style.UPDATE) || msg.style.contains((Object)Notify.Style.UPDATE_SAME_ITEM)) {
            this.updateMessage(msg);
            return;
        }
        boolean force_position = msg.style.contains((Object)Notify.Style.FORCE);
        if (messages.size() > 4 && !force_position) {
            messages.remove(0);
        }
        if ((testPos = msg.getPosition(0.0f)) == null) {
            return;
        }
        for (Message m : messages) {
            if (!(m.getPosition(0.0f).func_72438_d(testPos) < 1.05) || force_position) continue;
            m.creationTime = 0L;
        }
        if (!(msg.msg != null && msg.msg.trim().length() != 0 || msg.show_item && msg.item != null)) {
            return;
        }
        messages.add(msg);
    }

    void updateMessage(Message update) {
        for (Message msg : messages) {
            if (!msg.locus.equals(update.locus)) continue;
            if (!update.style.contains((Object)Notify.Style.UPDATE_SAME_ITEM)) {
                msg.item = update.item;
            }
            msg.msg = update.msg;
            return;
        }
    }

    @SubscribeEvent
    public void renderMessages(RenderWorldLastEvent event) {
        this.doRenderMessages(event);
    }

    void doRenderMessages(RenderWorldLastEvent event) {
        WorldClient w = Minecraft.func_71410_x().field_71441_e;
        if (w == null) {
            return;
        }
        if (messages.size() == 0) {
            return;
        }
        Iterator<Message> it = messages.iterator();
        long approximateNow = System.currentTimeMillis();
        EntityLivingBase camera = Minecraft.func_71410_x().field_71451_h;
        double cx = camera.field_70142_S + (camera.field_70165_t - camera.field_70142_S) * (double)event.partialTicks;
        double cy = camera.field_70137_T + (camera.field_70163_u - camera.field_70137_T) * (double)event.partialTicks;
        double cz = camera.field_70136_U + (camera.field_70161_v - camera.field_70136_U) * (double)event.partialTicks;
        GL11.glPushMatrix();
        GL11.glTranslated((double)(-cx), (double)(-cy), (double)(-cz));
        GL11.glPushAttrib((int)3042);
        GL11.glDepthMask((boolean)false);
        GL11.glDisable((int)2929);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        while (it.hasNext()) {
            Message m = it.next();
            long timeExisted = approximateNow - m.creationTime;
            if (timeExisted > m.lifeTime || m.world != w || !m.stillValid()) {
                it.remove();
                continue;
            }
            if (!m.style.contains((Object)Notify.Style.DRAWFAR)) {
                Vec3 pos = m.getPosition(event.partialTicks);
                double dist = camera.func_70011_f(pos.field_72450_a, pos.field_72448_b, pos.field_72449_c);
                if (dist > 8.0) continue;
            }
            GL11.glDisable((int)2896);
            float lifeLeft = (float)(m.lifeTime - timeExisted) / 1000.0f;
            float opacity = 1.0f;
            if (lifeLeft < 1.0f) {
                opacity = lifeLeft / 1.0f;
            }
            if (!((double)(opacity = (float)Math.sin(opacity)) > 0.12)) continue;
            this.renderMessage(m, event.partialTicks, opacity);
        }
        GL11.glEnable((int)2896);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glPopMatrix();
        GL11.glPopAttrib();
    }

    private void renderMessage(Message m, float partial, float opacity) {
        int width = 0;
        String[] lines = m.msg.split("\n");
        FontRenderer fr = Minecraft.func_71410_x().field_71466_p;
        for (String line : lines) {
            width = Math.max(width, fr.func_78256_a(line));
        }
        int halfWidth = (width += 2) / 2;
        float scaling = 0.026666667f;
        scaling *= 0.6666667f;
        GL11.glPushMatrix();
        int lineCount = lines.length;
        float centeringOffset = 0.0f;
        if (m.show_item) {
            if (lineCount == 1) {
                centeringOffset = 5.0f;
            }
            lineCount = Math.max(2, lineCount);
        }
        Vec3 vec = m.getPosition(partial);
        float x = (float)vec.field_72450_a;
        float y = (float)vec.field_72448_b;
        float z = (float)vec.field_72449_c;
        Coord co = m.asCoordMaybe();
        if (co != null && !m.position_important) {
            AxisAlignedBB bb = co.getCollisionBoundingBoxFromPool();
            y = bb != null ? (float)((double)y + (bb.field_72337_e - bb.field_72338_b)) : (y += 0.5f);
        }
        GL11.glTranslatef((float)(x + 0.5f), (float)y, (float)(z + 0.5f));
        float pvx = RenderManager.field_78727_a.field_78732_j;
        float pvy = -RenderManager.field_78727_a.field_78735_i;
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71474_y.field_74320_O == 2) {
            pvx = -pvx;
        }
        GL11.glRotatef((float)pvy, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)pvx, (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glScalef((float)(-scaling), (float)(-scaling), (float)scaling);
        GL11.glTranslatef((float)0.0f, (float)(-10 * lineCount), (float)0.0f);
        Tessellator tess = Tessellator.field_78398_a;
        int var16 = (lineCount - 1) * 10;
        GL11.glDisable((int)3553);
        tess.func_78382_b();
        double item_add = 0.0;
        if (m.show_item) {
            item_add += 24.0;
        }
        float c = 0.0f;
        tess.func_78369_a(c, c, c, Math.min(opacity, 0.2f));
        tess.func_78377_a((double)(-halfWidth - 1), -1.0, 0.0);
        tess.func_78377_a((double)(-halfWidth - 1), (double)(8 + var16), 0.0);
        tess.func_78377_a((double)(halfWidth + 1) + item_add, (double)(8 + var16), 0.0);
        tess.func_78377_a((double)(halfWidth + 1) + item_add, -1.0, 0.0);
        tess.func_78381_a();
        GL11.glEnable((int)3553);
        int i = 0;
        int B = (int)(255.0f * Math.min(1.0f, 0.5f + opacity));
        int color = (B << 16) + (B << 8) + B + ((int)(255.0f * opacity) << 24);
        GL11.glTranslatef((float)0.0f, (float)centeringOffset, (float)0.0f);
        for (String line : lines) {
            fr.func_78276_b(line, -fr.func_78256_a(line) / 2, 10 * i, color);
            ++i;
        }
        if (m.show_item) {
            GL11.glTranslatef((float)0.0f, (float)(-centeringOffset), (float)0.0f);
            TextureManager re = mc.field_71446_o;
            GL11.glTranslatef((float)(halfWidth + 4), (float)(-lineCount / 2), (float)0.0f);
            this.renderItem.field_77023_b -= 50.0f;
            this.renderItem.func_82406_b(fr, re, m.item, 0, 0);
            this.renderItem.field_77023_b += 50.0f;
        }
        GL11.glPopMatrix();
    }

    @Override
    public void onscreen(String message, String[] formatArgs) {
        Minecraft mc = Minecraft.func_71410_x();
        String msg = I18n.func_135052_a((String)message, (Object[])formatArgs);
        mc.field_71456_v.func_110326_a(msg, false);
    }
}

