/*
 * Decompiled with CFR 0.152.
 */
package factorization.notify;

import com.google.common.base.Joiner;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerStartingEvent;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.common.network.internal.FMLProxyPacket;
import cpw.mods.fml.relauncher.Side;
import factorization.notify.Notify;
import factorization.notify.NotifyNetwork;
import factorization.notify.RecuringNotification;
import factorization.notify.RenderMessagesProxy;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Iterator;
import net.minecraft.command.CommandBase;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.MinecraftForge;

@Mod(modid="factorization.notify", name="Factorization Notification System", version="1.0")
public class NotifyImplementation
extends Notify {
    public static final String modId = "factorization.notify";
    public static final String name = "Factorization Notification System";
    public static final String version = "1.0";
    @SidedProxy(clientSide="factorization.notify.RenderMessages", serverSide="factorization.notify.RenderMessagesProxy")
    public static RenderMessagesProxy proxy;
    public static NotifyNetwork net;
    static ArrayList<RecuringNotification> recuring_notifications;

    public NotifyImplementation() {
        Notify.instance = this;
        NotifyImplementation.loadBus(this);
    }

    static void loadBus(Object obj) {
        FMLCommonHandler.instance().bus().register(obj);
        MinecraftForge.EVENT_BUS.register(obj);
    }

    @Mod.EventHandler
    public void setParent(FMLPreInitializationEvent event) {
        String FZ = "factorization";
        if (Loader.isModLoaded((String)"factorization")) {
            event.getModMetadata().parent = "factorization";
        }
    }

    @Mod.EventHandler
    public void registerServerCommands(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new CommandBase(){

            public void func_71515_b(ICommandSender sender, String[] args) {
                if (!(sender instanceof TileEntity) && !(sender instanceof Entity)) {
                    return;
                }
                EnumSet<Notify.Style> theStyle = EnumSet.noneOf(Notify.Style.class);
                ItemStack heldItem = null;
                if (sender instanceof EntityLivingBase) {
                    heldItem = ((EntityLivingBase)sender).func_70694_bm();
                }
                ItemStack sendItem = null;
                for (int i = 0; i < args.length; ++i) {
                    String s = args[i];
                    if (s.equalsIgnoreCase("--long")) {
                        theStyle.add(Notify.Style.LONG);
                    } else {
                        if (!s.equalsIgnoreCase("--show-item") || heldItem == null) break;
                        theStyle.add(Notify.Style.DRAWITEM);
                        sendItem = heldItem;
                    }
                    args[i] = null;
                }
                String msg = Joiner.on((String)" ").skipNulls().join((Object[])args);
                msg = msg.replace("\\n", "\n");
                Notify.send(null, (Object)sender, theStyle, sendItem, "%s", msg);
            }

            public String func_71518_a(ICommandSender icommandsender) {
                return "/mutter [--long] [--show-item] [--refer-item] some text. Clears if empty";
            }

            public String func_71517_b() {
                return "mutter";
            }

            public boolean func_71519_b(ICommandSender sender) {
                return sender instanceof Entity;
            }

            public int func_82362_a() {
                return 0;
            }

            public int compareTo(ICommand otherCmd) {
                return this.func_71517_b().compareTo(otherCmd.func_71517_b());
            }

            public int compareTo(Object obj) {
                return this.compareTo((ICommand)obj);
            }
        });
    }

    @Override
    protected void doSend(EntityPlayer player, Object where, EnumSet<Notify.Style> style, ItemStack item, String format, String[] args) {
        if (where == null) {
            return;
        }
        format = this.styleMessage(style, format);
        if (player != null && player.field_70170_p.field_72995_K || FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT) {
            proxy.addMessage(where, item, format, args);
        } else {
            FMLProxyPacket packet = NotifyNetwork.notifyPacket(where, item, format, args);
            NotifyNetwork.broadcast(packet, player);
        }
    }

    public static void recieve(EntityPlayer player, Object where, ItemStack item, String styledFormat, String[] args) {
        if (where == null) {
            return;
        }
        proxy.addMessage(where, item, styledFormat, args);
    }

    String styleMessage(EnumSet<Notify.Style> style, String format) {
        if (style == null) {
            return "\n" + format;
        }
        String prefix = "";
        String sep = "";
        for (Notify.Style s : style) {
            prefix = prefix + sep + s.toString();
            sep = " ";
        }
        return prefix + "\n" + format;
    }

    static EnumSet<Notify.Style> loadStyle(String firstLine) {
        EnumSet<Notify.Style> ret = EnumSet.noneOf(Notify.Style.class);
        for (String s : firstLine.split(" ")) {
            try {
                ret.add(Notify.Style.valueOf(s));
            }
            catch (IllegalArgumentException e) {
                // empty catch block
            }
        }
        return ret;
    }

    @SubscribeEvent
    public void updateRecuringNotifications(TickEvent.ServerTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        Iterator<RecuringNotification> iterator = recuring_notifications.iterator();
        while (iterator.hasNext()) {
            RecuringNotification rn = iterator.next();
            if (rn.isInvalid()) {
                iterator.remove();
                continue;
            }
            if (!rn.updater.update(rn.first)) {
                iterator.remove();
            }
            rn.first = false;
        }
    }

    @Override
    protected void addRecuringNotification(RecuringNotification newRN) {
        Iterator<RecuringNotification> iterator = recuring_notifications.iterator();
        while (iterator.hasNext()) {
            RecuringNotification rn = iterator.next();
            if (!rn.where.equals(newRN.where) || newRN.player != null && newRN.player != rn.player) continue;
            iterator.remove();
        }
        recuring_notifications.add(newRN);
    }

    @Override
    protected void doSendOnscreenMessage(EntityPlayer player, String message, String[] formatArgs) {
        if (player.field_70170_p.field_72995_K) {
            proxy.onscreen(message, formatArgs);
        } else {
            FMLProxyPacket packet = NotifyNetwork.onscreenPacket(message, formatArgs);
            NotifyNetwork.broadcast(packet, player);
        }
    }

    static {
        net = new NotifyNetwork();
        recuring_notifications = new ArrayList();
    }
}

