/*
 * Decompiled with CFR 0.152.
 */
package factorization.notify;

import factorization.api.Coord;
import factorization.notify.MessageUpdater;
import factorization.notify.RecuringNotification;
import java.util.EnumSet;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;

public abstract class Notify {
    protected static Notify instance;
    private static EnumSet<Style> noStyle;
    private static String[] emptyArray;
    private static ItemStack item;
    private static EnumSet<Style> style;

    public static boolean enabled() {
        return instance != null;
    }

    public static boolean send(EntityPlayer player, Object where, EnumSet<Style> style, ItemStack item, String format, String ... args) {
        if (instance == null) {
            return false;
        }
        instance.doSend(player, where, style, item, format, args);
        style = noStyle;
        item = null;
        return true;
    }

    public static boolean send(Object where, String msg, String ... args) {
        if (instance == null) {
            return false;
        }
        instance.doSend(null, where, style, item, msg, args);
        style = noStyle;
        item = null;
        return true;
    }

    public static boolean send(EntityPlayer player, Object where, String msg, String ... args) {
        if (instance == null) {
            return false;
        }
        instance.doSend(player, where, style, item, msg, args);
        style = noStyle;
        item = null;
        return true;
    }

    public static void withItem(ItemStack is) {
        item = is;
    }

    public static void withStyle(Style ... args) {
        style = EnumSet.noneOf(Style.class);
        for (int i = 0; i < args.length; ++i) {
            style.add(args[i]);
        }
    }

    public static void clear(EntityPlayer player) {
        instance.doSend(player, new Coord((Entity)player), EnumSet.of(Style.CLEAR), null, "", emptyArray);
    }

    public static void recuring(EntityPlayer player, Object where, MessageUpdater updater) {
        RecuringNotification rn = new RecuringNotification(player, where, updater);
        instance.addRecuringNotification(rn);
    }

    public static void onscreen(EntityPlayer player, String message, String ... formatArguments) {
        instance.doSendOnscreenMessage(player, message, formatArguments);
    }

    public static void simpleSend(EntityPlayer player, int blockX, int blockY, int blockZ, String message, String ... formatParameters) {
        Notify.send(player, (Object)new Coord(player.field_70170_p, blockX, blockY, blockZ), message, formatParameters);
    }

    protected abstract void doSend(EntityPlayer var1, Object var2, EnumSet<Style> var3, ItemStack var4, String var5, String[] var6);

    protected abstract void addRecuringNotification(RecuringNotification var1);

    protected abstract void doSendOnscreenMessage(EntityPlayer var1, String var2, String[] var3);

    static {
        noStyle = EnumSet.noneOf(Style.class);
        emptyArray = new String[0];
        item = null;
        style = noStyle;
    }

    public static enum Style {
        FORCE,
        LONG,
        CLEAR,
        EXACTPOSITION,
        DRAWITEM,
        UPDATE,
        UPDATE_SAME_ITEM,
        DRAWFAR;

    }
}

