/*
 * Decompiled with CFR 0.152.
 */
package factorization.docs;

import factorization.docs.AbstractTypesetter;
import factorization.docs.IndexDocumentation;
import factorization.docs.Tokenizer;
import factorization.docs.Word;
import factorization.docs.WordPage;

public class IndexerTypesetter
extends AbstractTypesetter {
    String filename;

    public IndexerTypesetter(String filename) {
        super(null, 0, 0);
        this.filename = filename;
    }

    void printError(String msg) {
        System.err.println(this.filename + ": " + msg);
    }

    @Override
    protected void handleCommand(Tokenizer tokenizer, String cmd, String link, String style) {
        if (cmd.equalsIgnoreCase("\\topic")) {
            String subject = this.getParameter(cmd, tokenizer);
            if (subject == null) {
                this.printError("Missing item name parameter");
                return;
            }
            IndexDocumentation.foundTopic(subject, this.filename);
        } else if (cmd.equalsIgnoreCase("\\link") || cmd.equalsIgnoreCase("\\index")) {
            String target = this.getParameter(cmd, tokenizer);
            if (target == null) {
                this.printError("Missing a link target");
                return;
            }
            IndexDocumentation.foundLink(target);
        }
    }

    @Override
    WordPage newPage() {
        return null;
    }

    @Override
    void emitWord(Word w) {
    }
}

