/*
 * Decompiled with CFR 0.152.
 */
package factorization.docs;

import com.google.common.io.Closeables;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.event.FMLServerStartingEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import factorization.api.Coord;
import factorization.api.DeltaCoord;
import factorization.api.ICoordFunction;
import factorization.docs.DocViewer;
import factorization.docs.DocWorld;
import factorization.docs.IDocGenerator;
import factorization.docs.ItemListViewer;
import factorization.docs.RecipeViewer;
import factorization.notify.Notify;
import factorization.shared.Core;
import factorization.shared.FzUtil;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.base64.Base64;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.resources.IResource;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.input.Mouse;

public class DocumentationModule
implements ICommand {
    public static final DocumentationModule instance = new DocumentationModule();
    static HashMap<String, IDocGenerator> generators = new HashMap();
    static HashMap<String, ArrayList<ItemStack>> nameCache = null;
    public static IResourceManager overrideResourceManager = null;

    public static ArrayList<ItemStack> lookup(String name2) {
        return DocumentationModule.getNameItemCache().get(name2);
    }

    public static HashMap<String, ArrayList<ItemStack>> getNameItemCache() {
        if (nameCache == null) {
            DocumentationModule.loadCache();
        }
        return nameCache;
    }

    private static void loadCache() {
        ArrayList items = new ArrayList();
        for (Item it : Item.field_150901_e) {
            if (it == null) continue;
            try {
                it.func_150895_a(it, null, items);
            }
            catch (Throwable t) {
                Core.logWarning("Error getting sub-items from item: " + it, new Object[0]);
                t.printStackTrace();
            }
        }
        nameCache = new HashMap(items.size());
        for (ItemStack is : items) {
            if (is == null) continue;
            String itemName = is.func_77977_a();
            ArrayList<Object> list = nameCache.get(itemName);
            if (list == null) {
                list = new ArrayList();
                nameCache.put(itemName, list);
            }
            list.add(is);
        }
    }

    public static void registerGenerator(String name2, IDocGenerator gen) {
        generators.put(name2, gen);
    }

    public void serverStarts(FMLServerStartingEvent event) {
        if (FMLCommonHandler.instance().getSide() == Side.CLIENT) {
            event.registerServerCommand((ICommand)this);
        }
    }

    public int compareTo(Object arg0) {
        if (arg0 instanceof ICommand) {
            ICommand other = (ICommand)arg0;
            return this.func_71517_b().compareTo(other.func_71517_b());
        }
        return 0;
    }

    public String func_71517_b() {
        return "fzdoc-figure";
    }

    public String func_71518_a(ICommandSender icommandsender) {
        return "/fzdoc-serialize generates an FZDoc \\figure command";
    }

    public List func_71514_a() {
        return null;
    }

    public boolean func_71519_b(ICommandSender icommandsender) {
        return icommandsender instanceof EntityPlayer && MinecraftServer.func_71276_C().func_71203_ab().func_72353_e(icommandsender.func_70005_c_());
    }

    public List func_71516_a(ICommandSender icommandsender, String[] astring) {
        return null;
    }

    public boolean func_82358_a(String[] astring, int i) {
        return false;
    }

    void msg(ICommandSender player, String msg) {
        player.func_145747_a((IChatComponent)new ChatComponentText(msg));
    }

    int measure(Coord bottom, ForgeDirection east, ForgeDirection west, Block gold) {
        Coord at = bottom.copy();
        ForgeDirection d = bottom.add(east).is(gold) ? east : west;
        int size = 0;
        while (at.is(gold)) {
            at.adjust(d);
            ++size;
        }
        return size * (d.offsetX + d.offsetY + d.offsetZ);
    }

    public void func_71515_b(ICommandSender icommandsender, String[] astring) {
        Block gold;
        if (!(icommandsender instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)icommandsender;
        Coord peak = new Coord((Entity)player).add(ForgeDirection.DOWN);
        if (!peak.is(gold = Blocks.field_150340_R)) {
            this.msg((ICommandSender)player, "Not on a gold block");
            return;
        }
        int ySize = 0;
        Coord at = peak.copy();
        while (at.is(gold)) {
            at.adjust(ForgeDirection.DOWN);
            --ySize;
        }
        at.adjust(ForgeDirection.UP);
        Coord bottom = at.copy();
        int xSize = this.measure(bottom, ForgeDirection.EAST, ForgeDirection.WEST, gold);
        int zSize = this.measure(bottom, ForgeDirection.SOUTH, ForgeDirection.NORTH, gold);
        if (xSize * ySize * zSize == 0) {
            this.msg((ICommandSender)player, "Invalid dimensions");
            return;
        }
        if (Math.abs(xSize) > 15) {
            this.msg((ICommandSender)player, "X axis is too large");
            return;
        }
        if (Math.abs(ySize) > 15) {
            this.msg((ICommandSender)player, "Y ayis is too large");
            return;
        }
        if (Math.abs(zSize) > 15) {
            this.msg((ICommandSender)player, "Z azis is too large");
            return;
        }
        xSize = (int)((float)xSize - 2.0f * Math.signum(xSize));
        zSize = (int)((float)zSize - 2.0f * Math.signum(zSize));
        peak.x = (int)((float)peak.x + Math.signum(xSize));
        peak.z = (int)((float)peak.z + Math.signum(zSize));
        Coord max = peak.copy();
        Coord min = peak.add(xSize, ++ySize, zSize);
        Coord.sort(min, max);
        Notify.send(max, "max", new String[0]);
        Notify.send(min, "min", new String[0]);
        DocWorld dw = this.copyChunkToWorld(min, max);
        NBTTagCompound worldTag = new NBTTagCompound();
        dw.writeToTag(worldTag);
        try {
            String encoded = DocumentationModule.encodeNBT(worldTag);
            String cmd = "\\figure{\n" + encoded + "}";
            cmd = cmd.replace("\u0000", "");
            System.out.println(cmd);
            FzUtil.copyStringToClipboard(cmd);
            this.msg((ICommandSender)player, "\\figure command copied to the clipboard");
        }
        catch (Throwable t) {
            this.msg((ICommandSender)player, "An error occured");
            t.printStackTrace();
        }
    }

    DocWorld copyChunkToWorld(final Coord min, Coord max) {
        final DocWorld w = new DocWorld();
        DeltaCoord size = max.difference(min);
        DeltaCoord maxSize = new DeltaCoord(15, 15, 15);
        final DeltaCoord start = new DeltaCoord(0, 0, 0);
        Coord.iterateCube(min, max, new ICoordFunction(){

            @Override
            public void handle(Coord here) {
                if (here.isAir()) {
                    return;
                }
                DeltaCoord dc = here.difference(min).add(start);
                w.setIdMdTe(dc, here.getId(), here.getMd(), here.getTE());
            }
        });
        DeltaCoord d = max.difference(min);
        d.y /= 2;
        w.diagonal = (int)(d.magnitude() + 1.0);
        this.copyEntities(w, min, max);
        w.orig.set(min);
        return w;
    }

    void copyEntities(DocWorld dw20, Coord min, Coord max) {
        AxisAlignedBB ab = Coord.aabbFromRange(min, max);
        List ents = min.w.func_72839_b(null, ab);
        for (Entity ent : ents) {
            if (ent instanceof EntityPlayer) continue;
            dw20.addEntity(ent);
        }
    }

    static void debugBytes(String header, byte[] d) {
        System.out.println(header + " #" + d.length);
        for (byte b : d) {
            System.out.print(" " + Integer.toString(b));
        }
        System.out.println();
    }

    static String encodeNBT(NBTTagCompound tag) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(new GZIPOutputStream(baos));
        CompressedStreamTools.func_74800_a((NBTTagCompound)tag, (DataOutput)dos);
        dos.close();
        byte[] compressedData = baos.toByteArray();
        ByteBuf enc = Base64.encode((ByteBuf)Unpooled.copiedBuffer((byte[])compressedData));
        return new String(enc.array());
    }

    static NBTTagCompound decodeNBT(String contents) throws IOException {
        ByteBuf decoded = Base64.decode((ByteBuf)Unpooled.copiedBuffer((byte[])contents.getBytes()));
        ByteBufInputStream bais = new ByteBufInputStream(decoded);
        return CompressedStreamTools.func_74794_a((DataInput)new DataInputStream(new GZIPInputStream((InputStream)bais)));
    }

    public static DocWorld loadWorld(String text) {
        try {
            NBTTagCompound tag = DocumentationModule.decodeNBT(text);
            return new DocWorld(tag);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static ResourceLocation getResourceForName(String name2) {
        return Core.getResource("doc/" + name2 + ".txt");
    }

    public static InputStream getDocumentResource(String name2) {
        try {
            IResourceManager irm = overrideResourceManager != null ? overrideResourceManager : Minecraft.func_71410_x().func_110442_L();
            IResource src = irm.func_110536_a(DocumentationModule.getResourceForName(name2));
            return src.func_110527_b();
        }
        catch (Throwable e) {
            if (e instanceof IOException) {
                return null;
            }
            e.printStackTrace();
            return null;
        }
    }

    public static String readDocument(String name2) {
        try {
            return DocumentationModule.dispatchDocument(name2);
        }
        catch (Throwable e) {
            e.printStackTrace();
            String txt = e.getMessage();
            for (StackTraceElement ste : e.getStackTrace()) {
                txt = txt + "\n\n    at " + ste.getFileName() + "(" + ste.getFileName() + ":" + ste.getLineNumber() + ")";
            }
            return "\\obf{5*5*5*2*2 Internal Server Error\n\nAn error was encountered while trying to execute your request.}\n\n" + txt;
        }
    }

    private static String readContents(String name2, InputStream is) throws IOException {
        int length;
        if (is == null) {
            return "\\obf{101*2*2 Not Found:} " + name2;
        }
        StringBuilder build = new StringBuilder();
        byte[] buf = new byte[1024];
        while ((length = is.read(buf)) != -1) {
            build.append(new String(buf, 0, length));
        }
        return build.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String dispatchDocument(String name2) throws IOException {
        if (name2.startsWith("cgi/")) {
            return "\\generate{" + name2.replace("cgi/", "") + "}";
        }
        InputStream is = null;
        try {
            is = DocumentationModule.getDocumentResource(name2);
            String string = DocumentationModule.readContents(name2, is);
            return string;
        }
        finally {
            Closeables.close((Closeable)is, (boolean)false);
        }
    }

    public static String textifyItem(ItemStack is) {
        String name2 = is.func_77977_a();
        return "\\#{" + name2 + "} " + is.func_82833_r();
    }

    @SideOnly(value=Side.CLIENT)
    public static void openPageForHilightedItem() {
        int mouseY;
        Minecraft mc = Minecraft.func_71410_x();
        if (!(mc.field_71462_r instanceof GuiContainer)) {
            return;
        }
        GuiContainer screen = (GuiContainer)mc.field_71462_r;
        int mouseX = Mouse.getEventX() * screen.field_146294_l / mc.field_71443_c;
        Slot slot = screen.func_146975_c(mouseX, mouseY = screen.field_146295_m - Mouse.getEventY() * screen.field_146295_m / mc.field_71440_d - 1);
        if (slot == null) {
            return;
        }
        DocumentationModule.tryOpenBookForItem(slot.func_75211_c());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SideOnly(value=Side.CLIENT)
    public static boolean tryOpenBookForItem(ItemStack is) {
        if (is == null) {
            return false;
        }
        Minecraft mc = Minecraft.func_71410_x();
        EntityClientPlayerMP player = mc.field_71439_g;
        if (!player.field_71075_bZ.field_75098_d) {
            ItemStack manual = player.func_70694_bm();
            if (manual == null) {
                return false;
            }
            if (manual.func_77973_b() != Core.registry.docbook) {
                return false;
            }
        }
        String name2 = is.func_77977_a();
        InputStream topic_index = DocumentationModule.getDocumentResource("topic_index");
        if (topic_index == null) {
            return false;
        }
        BufferedReader br = new BufferedReader(new InputStreamReader(topic_index));
        try {
            String line;
            while ((line = br.readLine()) != null) {
                String[] bits = line.split("\t");
                if (bits.length < 2 || !bits[0].equalsIgnoreCase(name2)) continue;
                String filename = bits[1];
                mc.func_147108_a((GuiScreen)new DocViewer(filename));
                boolean bl = true;
                return bl;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            FzUtil.closeNoisily("closing topic_index", topic_index);
        }
        if (Loader.isModLoaded((String)"NotEnoughItems") || Loader.isModLoaded((String)"craftguide")) {
            return false;
        }
        mc.func_147108_a((GuiScreen)new DocViewer("cgi/recipes/for/" + name2));
        return true;
    }

    static void registerGenerators() {
        DocumentationModule.registerGenerator("items", new ItemListViewer());
        DocumentationModule.registerGenerator("recipes", new RecipeViewer());
    }
}

