/*
 * Decompiled with CFR 0.152.
 */
package factorization.coremod;

import cpw.mods.fml.relauncher.FMLRelaunchLog;
import factorization.coremod.MethodAppends;
import java.io.IOException;
import java.util.List;
import net.minecraft.launchwrapper.IClassTransformer;
import net.minecraft.launchwrapper.LaunchClassLoader;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LineNumberNode;
import org.objectweb.asm.tree.MethodNode;

public class ASMTransformer
implements IClassTransformer {
    List<MethodNode> apendeeMethods = null;

    public byte[] transform(String name2, String transformedName, byte[] basicClass) {
        if (transformedName.equals("net.minecraft.block.Block")) {
            return this.applyTransform(basicClass, new Append(transformedName, "a(Lafn;IIILafi;)V", "func_149723_a", "onBlockDestroyedByExplosion"), new Append(transformedName, "a(Lafi;)Z", "func_149659_a", "canDropFromExplosion"));
        }
        if (transformedName.equals("net.minecraft.client.gui.inventory.GuiContainer")) {
            return this.applyTransform(basicClass, new Append(transformedName, "a(CI)V", "func_73869_a", "keyTyped"));
        }
        return basicClass;
    }

    byte[] applyTransform(byte[] basicClass, Append ... changes) {
        ClassReader cr = new ClassReader(basicClass);
        ClassNode cn = new ClassNode();
        cr.accept((ClassVisitor)cn, 0);
        for (MethodNode m : cn.methods) {
            for (Append change : changes) {
                if (!change.applies(m)) continue;
                MethodNode method = this.getMethod(change.srgName);
                this.appendMethod(m, method);
                change.satisfied = true;
            }
        }
        for (Append change : changes) {
            if (change.satisfied) continue;
            throw new RuntimeException("Unable to find method " + cn.name + "." + change.srgName + " (" + change.mcpName + ")");
        }
        ClassWriter cw = new ClassWriter(3);
        cn.accept((ClassVisitor)cw);
        return cw.toByteArray();
    }

    MethodNode getMethod(String methodName) {
        if (this.apendeeMethods == null) {
            ClassReader cr = new ClassReader(this.getAppendeeBytecodeBytecode());
            ClassNode cn = new ClassNode();
            cr.accept((ClassVisitor)cn, 0);
            this.apendeeMethods = cn.methods;
        }
        for (MethodNode m : this.apendeeMethods) {
            if (!m.name.equals(methodName)) continue;
            return m;
        }
        throw new RuntimeException("Couldn't find method " + methodName);
    }

    boolean isReturn(int op) {
        return op == 172 || op == 173 || op == 174 || op == 175 || op == 176 || op == 177;
    }

    void appendMethod(MethodNode base, MethodNode toAppend) {
        AbstractInsnNode base_end = base.instructions.getLast();
        while (!this.isReturn(base_end.getOpcode())) {
            base_end = base_end.getPrevious();
        }
        AbstractInsnNode ins = toAppend.instructions.getFirst();
        while (ins != null) {
            AbstractInsnNode next = ins.getNext();
            if (!(ins instanceof LineNumberNode)) {
                base.instructions.insertBefore(base_end, ins);
            }
            ins = next;
        }
        base.instructions.remove(base_end);
    }

    byte[] getAppendeeBytecodeBytecode() {
        LaunchClassLoader rcl = (LaunchClassLoader)this.getClass().getClassLoader();
        try {
            return rcl.getClassBytes(MethodAppends.class.getCanonicalName());
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    void printInstructions(AbstractInsnNode ins) {
        while (ins != null) {
            System.out.print(ins.getOpcode() + "  ");
            if (ins instanceof JumpInsnNode) {
                System.out.println("Jump to " + ((JumpInsnNode)ins).label.getLabel());
            } else if (ins instanceof LabelNode) {
                System.out.println("Label: " + ((LabelNode)ins).getLabel());
            } else {
                System.out.println(ins);
            }
            ins = ins.getNext();
        }
    }

    void log(Object msg) {
        FMLRelaunchLog.info((String)msg.toString(), (Object[])new Object[0]);
    }

    static class Append {
        String srgName;
        String mcpName;
        String obfDescr;
        boolean satisfied = false;

        Append(String className, String obfDescr, String srgName, String mcpName) {
            this.obfDescr = obfDescr;
            this.srgName = srgName;
            this.mcpName = mcpName;
        }

        boolean applies(MethodNode method) {
            String mDescr = method.name + method.desc;
            String name2 = method.name;
            return mDescr.equals(this.obfDescr) || name2.equals(this.srgName) || name2.equals(this.mcpName);
        }
    }
}

