/*
 * Decompiled with CFR 0.152.
 */
package factorization.charge;

import cpw.mods.fml.common.network.internal.FMLProxyPacket;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import factorization.api.Charge;
import factorization.api.Coord;
import factorization.api.IChargeConductor;
import factorization.api.datahelpers.DataHelper;
import factorization.api.datahelpers.DataInNBT;
import factorization.api.datahelpers.DataOutNBT;
import factorization.api.datahelpers.Share;
import factorization.charge.ChargeSparks;
import factorization.common.BlockIcons;
import factorization.common.FactoryType;
import factorization.shared.BlockClass;
import factorization.shared.Core;
import factorization.shared.FzUtil;
import factorization.shared.NetworkFactorization;
import factorization.shared.TileEntityCommon;
import java.io.DataInput;
import java.io.IOException;
import java.util.Random;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.IIcon;
import net.minecraft.util.Vec3;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityLeydenJar
extends TileEntityCommon
implements IChargeConductor {
    private Charge charge = new Charge(this);
    int storage = 0;
    static final double max_efficiency = 0.75;
    static final double min_efficiency = 0.05;
    static final int charge_threshold = 70;
    static final int discharge_threshold = 40;
    public static final int max_storage = 1280000;
    static final int max_charge_per_tick = 200;
    static final int max_discharge_per_tick = 50;
    public ChargeSparks sparks = null;
    char last_light = (char)65535;
    private static Random rand = new Random();
    int last_storage = -1;

    @Override
    public FactoryType getFactoryType() {
        return FactoryType.LEYDENJAR;
    }

    @Override
    public BlockClass getBlockClass() {
        return BlockClass.MachineDynamicLightable;
    }

    public double getLevel() {
        return (double)this.storage / 1280000.0;
    }

    @Override
    public String getInfo() {
        return "Storage: " + (int)(this.getLevel() * 100.0) + "%";
    }

    @Override
    public Charge getCharge() {
        return this.charge;
    }

    public double getEfficiency() {
        double range = 0.7;
        return 0.05 + range * (1.0 - this.getLevel());
    }

    private static double randomizeDirection(int i) {
        if (i == 0) {
            double r;
            double turn = Math.PI * 2;
            return (r += (r = Math.cos(rand.nextDouble() * (Math.PI * 2)) - 1.0) < -1.0 ? 2.0 : 0.0) * 0.3 + 0.5;
        }
        return (double)i * 0.4 + 0.5;
    }

    public void updateSparks(ChargeSparks the_sparks) {
        double level = this.getLevel() * 4.0 / 5.0;
        if (level > rand.nextDouble()) {
            Vec3 src = Vec3.func_72443_a((double)0.5, (double)(TileEntityLeydenJar.randomizeDirection(0) / 2.0 + 0.2), (double)0.5);
            ForgeDirection fo = ForgeDirection.getOrientation((int)(2 + rand.nextInt(4)));
            Vec3 dest = Vec3.func_72443_a((double)TileEntityLeydenJar.randomizeDirection(fo.offsetX), (double)TileEntityLeydenJar.randomizeDirection(fo.offsetY), (double)TileEntityLeydenJar.randomizeDirection(fo.offsetZ));
            the_sparks.spark(src, dest, 12, 1, 3, 2.0, 8.0, 15656349);
        }
        the_sparks.update();
    }

    public void func_145845_h() {
        int free;
        int to_give;
        this.charge.update();
        Coord here = this.getCoord();
        if (this.field_145850_b.field_72995_K) {
            if (this.sparks == null) {
                this.sparks = new ChargeSparks(10);
            }
            this.updateSparks(this.sparks);
            char now_light = (char)this.getDynamicLight();
            if (this.last_light == '\uffffffff') {
                this.last_light = now_light;
            }
            if (Math.abs(this.last_light - now_light) > 1) {
                this.last_light = now_light;
                here.updateBlockLight();
                here.redraw();
            }
            return;
        }
        if (here.isPowered()) {
            return;
        }
        boolean change = false;
        int charge_value = this.charge.getValue();
        if (charge_value > 70) {
            double efficiency = this.getEfficiency();
            int free2 = 1280000 - this.storage;
            int to_take = Math.min(charge_value - 70, 200);
            int gain = (int)((double)(to_take = Math.min(free2, to_take)) * efficiency);
            if (gain > 0) {
                this.storage = (int)((double)this.storage + (double)this.charge.deplete(to_take) * efficiency);
                change = true;
            }
        } else if (charge_value < 40 && (to_give = Math.min(Math.min(this.storage, free = 40 - charge_value), 50)) > 0) {
            this.storage -= this.charge.addValue(to_give);
            change = true;
        }
        if (change) {
            this.func_70296_d();
            this.updateClients();
        }
    }

    void updateClients() {
        if (this.storage != this.last_storage) {
            this.broadcastMessage(null, NetworkFactorization.MessageType.LeydenjarLevel, this.storage);
            this.last_storage = this.storage;
        }
    }

    @Override
    public boolean handleMessageFromServer(NetworkFactorization.MessageType messageType, DataInput input) throws IOException {
        if (super.handleMessageFromServer(messageType, input)) {
            return true;
        }
        if (messageType == NetworkFactorization.MessageType.LeydenjarLevel) {
            this.storage = input.readInt();
            return true;
        }
        return false;
    }

    void handleData(DataHelper data) throws IOException {
        this.storage = data.as(Share.VISIBLE, "store").putInt(this.storage);
    }

    @Override
    public void func_145841_b(NBTTagCompound tag) {
        super.func_145841_b(tag);
        try {
            this.handleData(new DataOutNBT(tag));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        try {
            this.handleData(new DataInNBT(tag));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(ForgeDirection dir) {
        return BlockIcons.leyden_metal;
    }

    @Override
    public void onPlacedBy(EntityPlayer player, ItemStack is, int side) {
        if (is.func_77942_o()) {
            NBTTagCompound tag = FzUtil.getTag(is);
            this.storage = tag.func_74762_e("storage");
        }
    }

    @Override
    public FMLProxyPacket getDescriptionPacket() {
        return super.getDescriptionPacketWith(new Object[]{NetworkFactorization.MessageType.LeydenjarLevel, this.storage});
    }

    @Override
    public int getDynamicLight() {
        return (int)(this.getLevel() * 7.0);
    }

    @Override
    public ItemStack getDroppedBlock() {
        ItemStack is = new ItemStack((Item)Core.registry.item_factorization, 1, this.getFactoryType().md);
        NBTTagCompound tag = FzUtil.getTag(is);
        tag.func_74768_a("storage", this.storage);
        return is;
    }

    @Override
    public int getComparatorValue(ForgeDirection side) {
        return (int)(this.getLevel() * 15.0);
    }
}

