/*
 * Decompiled with CFR 0.152.
 */
package clashsoft.cslib.util;

import clashsoft.cslib.util.EnumFontColor;

public class CSUtil {
    public static boolean checkClass(String name) {
        try {
            Class.forName(name, false, ClassLoader.getSystemClassLoader());
            return true;
        }
        catch (ClassNotFoundException ex) {
            return false;
        }
    }

    public static int combineColors(int ... colors) {
        int r = 0;
        int g = 0;
        int b = 0;
        for (int i : colors) {
            r += i >> 16 & 0xFF;
            g += i >> 8 & 0xFF;
            b += i >> 0 & 0xFF;
        }
        return ((r /= colors.length) & 0xFF) << 16 | ((g /= colors.length) & 0xFF) << 8 | ((b /= colors.length) & 0xFF) << 0;
    }

    public static String fontColor(int light, int r, int g, int b) {
        return "\u00a7" + Integer.toHexString(CSUtil.fontColorInt(light, r, g, b));
    }

    public static int fontColorInt(int light, int r, int g, int b) {
        int i;
        int n = i = b > 0 ? 1 : 0;
        if (g > 0) {
            i |= 2;
        }
        if (r > 0) {
            i |= 4;
        }
        if (light > 0) {
            i |= 8;
        }
        return i;
    }

    public static String fontColor(EnumFontColor fontColor) {
        return CSUtil.fontColor(fontColor.getLight(), fontColor.getRed(), fontColor.getGreen(), fontColor.getBlue());
    }

    public static int fontColorInt(EnumFontColor fontColor) {
        return CSUtil.fontColorInt(fontColor.getLight(), fontColor.getRed(), fontColor.getGreen(), fontColor.getBlue());
    }

    public static String getAppdataDirectory() {
        String OS = System.getProperty("os.name").toUpperCase();
        if (OS.contains("WIN")) {
            return System.getenv("APPDATA");
        }
        if (OS.contains("MAC")) {
            return System.getProperty("user.home") + "/Library/Application Support";
        }
        if (OS.contains("NUX")) {
            return System.getProperty("user.home");
        }
        return System.getProperty("user.dir");
    }

    public static int tryParse(String text, int _default) {
        try {
            return Integer.parseInt(text);
        }
        catch (NumberFormatException ex) {
            return _default;
        }
    }

    public static int tryParse(String text, int radix, int _default) {
        try {
            return Integer.parseInt(text, radix);
        }
        catch (NumberFormatException ex) {
            return _default;
        }
    }
}

